/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.security.encryption.cipher;

import java.io.File;
import java.text.ParseException;
import org.silverpeas.core.util.EncodingUtil;
import org.silverpeas.kernel.util.StringUtil;

public class CipherKey {
    private byte[] key;
    private String keyFilePath;

    private CipherKey(byte[] aKey) {
        this.key = (byte[])aKey.clone();
    }

    private CipherKey(String aKeyFilePath) {
        this.keyFilePath = aKeyFilePath;
    }

    public static CipherKey aKeyFromHexText(String hexKey) throws ParseException {
        return new CipherKey(EncodingUtil.fromHex(hexKey));
    }

    public static CipherKey aKeyFromBase64Text(String base64Key) {
        return new CipherKey(StringUtil.fromBase64((String)base64Key));
    }

    public static CipherKey aKeyFromBinary(byte[] binaryKey) {
        return new CipherKey(binaryKey);
    }

    public static CipherKey aKeyFromFilePath(String path) {
        return new CipherKey(path);
    }

    public boolean isInFile() {
        if (StringUtil.isDefined((String)this.keyFilePath)) {
            File keyFile = new File(this.keyFilePath);
            return keyFile.exists() && keyFile.isFile();
        }
        return false;
    }

    public boolean isNotInFile() {
        return !this.isInFile();
    }

    public boolean isRaw() {
        return this.key != null;
    }

    public byte[] getRawKey() {
        return this.key;
    }

    public String getKeyFilePath() {
        return this.keyFilePath;
    }
}

