/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.security.encryption.cipher;

import java.io.FileNotFoundException;
import java.util.Collection;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import org.bouncycastle.operator.OutputEncryptor;
import org.silverpeas.core.security.encryption.cipher.Cipher;
import org.silverpeas.core.security.encryption.cipher.CipherKey;
import org.silverpeas.core.security.encryption.cipher.CryptoException;
import org.silverpeas.core.security.encryption.cipher.CryptographicAlgorithmName;
import org.silverpeas.core.security.encryption.cipher.PKS12KeyStore;
import org.silverpeas.core.security.encryption.cipher.PKS12KeyStoreWallet;
import org.silverpeas.core.util.Charsets;

public class CMSCipher
implements Cipher {
    protected CMSCipher() {
    }

    @Override
    public CryptographicAlgorithmName getAlgorithmName() {
        return CryptographicAlgorithmName.CMS;
    }

    @Override
    public byte[] encrypt(String data, CipherKey keyFilePath) throws CryptoException {
        try {
            byte[] buffer = this.stringToByteArray(data);
            CMSEnvelopedDataGenerator gen = new CMSEnvelopedDataGenerator();
            if (keyFilePath.isNotInFile()) {
                throw new FileNotFoundException("The PKS#12 file '" + String.valueOf(keyFilePath) + "' doesn't exist!");
            }
            PKS12KeyStoreWallet wallet = PKS12KeyStoreWallet.getInstance();
            PKS12KeyStore keyStore = wallet.getKeyStore(keyFilePath.getKeyFilePath());
            JceKeyTransRecipientInfoGenerator generator = new JceKeyTransRecipientInfoGenerator(keyStore.getCertificate()).setProvider("BC");
            gen.addRecipientInfoGenerator((RecipientInfoGenerator)generator);
            OutputEncryptor encryptor = new JceCMSContentEncryptorBuilder(CMSAlgorithm.AES128_CBC).setProvider("BC").build();
            CMSEnvelopedData envData = gen.generate((CMSTypedData)new CMSProcessableByteArray(buffer), encryptor);
            return envData.getEncoded();
        }
        catch (CryptoException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CryptoException("The encryption failed!", e);
        }
    }

    @Override
    public String decrypt(byte[] encryptedData, CipherKey keyFilePath) throws CryptoException {
        try {
            CMSEnvelopedData ced = new CMSEnvelopedData(encryptedData);
            Collection recipients = ced.getRecipientInfos().getRecipients();
            RecipientInformation info = (RecipientInformation)recipients.iterator().next();
            if (!keyFilePath.isNotInFile()) {
                throw new FileNotFoundException("The PKS#12 file '" + String.valueOf(keyFilePath) + "' doesn't exist!");
            }
            PKS12KeyStoreWallet wallet = PKS12KeyStoreWallet.getInstance();
            PKS12KeyStore keyStore = wallet.getKeyStore(keyFilePath.getKeyFilePath());
            byte[] contents = info.getContent((Recipient)new JceKeyTransEnvelopedRecipient(keyStore.getPrivatekey()));
            return this.byteArrayToString(contents);
        }
        catch (CryptoException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CryptoException("The decryption failed!", e);
        }
    }

    private String byteArrayToString(byte[] bArray) {
        return new String(bArray, Charsets.UTF_8);
    }

    private byte[] stringToByteArray(String theString) {
        return theString.getBytes(Charsets.UTF_8);
    }

    @Override
    public CipherKey generateCipherKey() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

