/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.security.authentication.password.service;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.core.security.authentication.password.constant.PasswordRuleType;
import org.silverpeas.core.security.authentication.password.rule.AtLeastXDigitPasswordRule;
import org.silverpeas.core.security.authentication.password.rule.AtLeastXLowercasePasswordRule;
import org.silverpeas.core.security.authentication.password.rule.AtLeastXSpecialCharPasswordRule;
import org.silverpeas.core.security.authentication.password.rule.AtLeastXUppercasePasswordRule;
import org.silverpeas.core.security.authentication.password.rule.BlankForbiddenPasswordRule;
import org.silverpeas.core.security.authentication.password.rule.MaxLengthPasswordRule;
import org.silverpeas.core.security.authentication.password.rule.MinLengthPasswordRule;
import org.silverpeas.core.security.authentication.password.rule.PasswordRule;
import org.silverpeas.core.security.authentication.password.rule.SequentialForbiddenPasswordRule;
import org.silverpeas.core.security.authentication.password.service.PasswordCheck;
import org.silverpeas.core.security.authentication.password.service.PasswordRulesService;
import org.silverpeas.core.template.SilverpeasTemplates;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.cache.model.ExternalCache;
import org.silverpeas.kernel.util.StringUtil;

@Service
@Singleton
public class DefaultPasswordRulesService
implements PasswordRulesService {
    protected static SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.password.settings.password");
    protected static int nbMatchingCombinedRules = settings.getInteger("password.combination.nbMatchingRules", 0);
    private final Map<PasswordRuleType, PasswordRule> allPasswordRules = new LinkedHashMap<PasswordRuleType, PasswordRule>(PasswordRuleType.values().length);
    private final Map<PasswordRuleType, PasswordRule> requiredPasswordRules = new LinkedHashMap<PasswordRuleType, PasswordRule>(PasswordRuleType.values().length);
    private final Map<PasswordRuleType, PasswordRule> combinedPasswordRules = new LinkedHashMap<PasswordRuleType, PasswordRule>(PasswordRuleType.values().length);
    private final Random random = new SecureRandom();

    @PostConstruct
    protected void loadRules() {
        this.allPasswordRules.clear();
        this.requiredPasswordRules.clear();
        this.combinedPasswordRules.clear();
        for (PasswordRule rule : new PasswordRule[]{new MinLengthPasswordRule(), new MaxLengthPasswordRule(), new BlankForbiddenPasswordRule(), new SequentialForbiddenPasswordRule(), new AtLeastXUppercasePasswordRule(), new AtLeastXLowercasePasswordRule(), new AtLeastXDigitPasswordRule(), new AtLeastXSpecialCharPasswordRule()}) {
            this.allPasswordRules.put(rule.getType(), rule);
            if (rule.isRequired()) {
                this.requiredPasswordRules.put(rule.getType(), rule);
            }
            if (!rule.isCombined()) continue;
            this.combinedPasswordRules.put(rule.getType(), rule);
        }
    }

    @Override
    public PasswordRule getRule(PasswordRuleType passwordRuleType) {
        return this.allPasswordRules.get((Object)passwordRuleType);
    }

    @Override
    public Collection<PasswordRule> getRules() {
        return new ArrayList<PasswordRule>(this.allPasswordRules.values());
    }

    @Override
    public Collection<PasswordRule> getRequiredRules() {
        return new ArrayList<PasswordRule>(this.requiredPasswordRules.values());
    }

    @Override
    public Collection<PasswordRule> getCombinedRules() {
        return new ArrayList<PasswordRule>(this.combinedPasswordRules.values());
    }

    @Override
    public PasswordCheck check(String password) {
        PasswordCheck passwordCheck = new PasswordCheck(this.getCombinedRules(), nbMatchingCombinedRules);
        for (PasswordRule rule : this.getRequiredRules()) {
            if (rule.check(password)) continue;
            passwordCheck.addRequiredError(rule);
        }
        for (PasswordRule rule : this.getCombinedRules()) {
            if (rule.check(password)) continue;
            passwordCheck.addCombinedError(rule);
        }
        if (passwordCheck.isCorrect()) {
            ExternalCache cache = CacheAccessorProvider.getApplicationCacheAccessor().getCache();
            String id = cache.add((Object)password, 60, 0);
            passwordCheck.setId(id);
        }
        return passwordCheck;
    }

    @Override
    public boolean isChecked(String checkId, String password) {
        ExternalCache cache = CacheAccessorProvider.getApplicationCacheAccessor().getCache();
        return StringUtil.isDefined((String)checkId) && StringUtil.isDefined((String)password) && password.equals(cache.get((Object)checkId));
    }

    @Override
    public String generate() {
        long start = System.currentTimeMillis();
        PasswordRule sequentialForbidden = this.getRule(PasswordRuleType.SEQUENTIAL_FORBIDDEN);
        String generatedPassword = this.generate(sequentialForbidden);
        if (sequentialForbidden.isRequired()) {
            while (System.currentTimeMillis() - start <= 5000L && !sequentialForbidden.check(generatedPassword)) {
                generatedPassword = this.generate(sequentialForbidden);
            }
        }
        return generatedPassword;
    }

    private String generate(PasswordRule sequentialForbidden) {
        String currentRandomPasswordPart;
        ArrayList<PasswordRule> rules = new ArrayList<PasswordRule>(this.getRules());
        ArrayList<PasswordRule> requiredRules = new ArrayList<PasswordRule>(this.getRequiredRules());
        ArrayList<PasswordRule> combinedRules = new ArrayList<PasswordRule>(this.getCombinedRules());
        int minLength = (Integer)this.getRule(PasswordRuleType.MIN_LENGTH).getValue();
        int maxLength = (Integer)this.getRule(PasswordRuleType.MAX_LENGTH).getValue();
        int requiredPasswordLength = minLength + this.random(maxLength - minLength + 1);
        List<String> randomPasswordParts = new ArrayList<String>();
        HashSet<PasswordRule> combinedRulesPerformed = new HashSet<PasswordRule>();
        for (int currentPasswordLength = 0; currentPasswordLength < requiredPasswordLength; currentPasswordLength += currentRandomPasswordPart.length()) {
            PasswordRule currentRule = this.getPasswordRule(requiredRules, combinedRules, combinedRulesPerformed, rules);
            if (currentRule.isCombined()) {
                combinedRulesPerformed.add(currentRule);
            }
            if (!StringUtil.isDefined((String)(currentRandomPasswordPart = currentRule.random()))) continue;
            while (currentPasswordLength + currentRandomPasswordPart.length() > maxLength) {
                currentRandomPasswordPart = currentRandomPasswordPart.substring(0, currentRandomPasswordPart.length() - 1);
            }
            randomPasswordParts.add(currentRandomPasswordPart);
        }
        Collections.shuffle(randomPasswordParts);
        String generatedPassword = StringUtils.join(randomPasswordParts, (String)"");
        for (int i = 0; i < 10 && sequentialForbidden.isRequired() && !sequentialForbidden.check(generatedPassword); ++i) {
            randomPasswordParts = Arrays.asList(generatedPassword.split(""));
            Collections.shuffle(randomPasswordParts);
            generatedPassword = StringUtils.join(randomPasswordParts, (String)"");
        }
        return generatedPassword;
    }

    private PasswordRule getPasswordRule(List<PasswordRule> requiredRules, List<PasswordRule> combinedRules, Set<PasswordRule> combinedRulesPerformed, List<PasswordRule> rules) {
        PasswordRule currentRule = !requiredRules.isEmpty() ? requiredRules.remove(this.random(requiredRules.size())) : (!combinedRules.isEmpty() && combinedRulesPerformed.size() < nbMatchingCombinedRules ? combinedRules.remove(this.random(combinedRules.size())) : rules.get(this.random(rules.size())));
        return currentRule;
    }

    private int random(int maxValue) {
        return this.random.nextInt(maxValue);
    }

    @Override
    public String getExtraRuleMessage(String language) {
        return SilverpeasTemplates.createSilverpeasTemplateOnCore((String)"password").applyFileTemplate("extraRules_" + language).trim();
    }
}

