/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.scheduler.quartz;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.inject.Singleton;
import org.quartz.JobDetail;
import org.quartz.JobExecutionException;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.persistence.Transaction;
import org.silverpeas.core.persistence.TransactionRuntimeException;
import org.silverpeas.core.scheduler.Job;
import org.silverpeas.core.scheduler.PersistentScheduling;
import org.silverpeas.core.scheduler.SchedulerEventListener;
import org.silverpeas.core.scheduler.SchedulerException;
import org.silverpeas.core.scheduler.quartz.JobExecutor;
import org.silverpeas.core.scheduler.quartz.QuartzScheduler;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@Service
@Singleton
@PersistentScheduling
public class PersistentQuartzScheduler
extends QuartzScheduler {
    private static final String QUARTZ_PROPERTIES = "org.silverpeas.scheduler.settings.persistent-scheduler";

    protected PersistentQuartzScheduler() {
    }

    public void init() {
        this.setUpQuartzScheduler(QUARTZ_PROPERTIES);
    }

    public void release() throws SchedulerException {
        this.shutdown();
    }

    @Override
    protected String encodeJob(Job job) {
        return job.getClass().getName();
    }

    @Override
    protected String encodeEventListener(SchedulerEventListener listener) {
        return listener.getClass().getName();
    }

    protected Class<PersistentJobExecutor> getJobExecutor() {
        return PersistentJobExecutor.class;
    }

    @Override
    protected <T> void execute(QuartzScheduler.SchedulingTask<T> schedulingTask) throws org.quartz.SchedulerException {
        try {
            Transaction.performInOne(() -> {
                schedulingTask.execute();
                return null;
            });
        }
        catch (TransactionRuntimeException e) {
            throw new org.quartz.SchedulerException(e.getCause());
        }
    }

    public static class PersistentJobExecutor
    extends JobExecutor {
        @Override
        protected Job getJob(JobDetail jobDetail) throws JobExecutionException {
            String jobClass = jobDetail.getJobDataMap().getString("job");
            String jobName = jobDetail.getKey().getName();
            return (Job)this.getByReflection(jobClass, jobName);
        }

        @Override
        protected SchedulerEventListener getSchedulerEventListener(JobDetail jobDetail) throws JobExecutionException {
            String listenerClass = jobDetail.getJobDataMap().getString("listener");
            return (SchedulerEventListener)this.getByReflection(listenerClass, null);
        }

        private <T> T getByReflection(String className, String param) throws JobExecutionException {
            Class<?> propertyClass;
            try {
                propertyClass = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new JobExecutionException((Throwable)e);
            }
            try {
                return (T)ServiceProvider.getService(propertyClass, (Annotation[])new Annotation[0]);
            }
            catch (SilverpeasRuntimeException e) {
                SilverLogger.getLogger(this.getClass()).debug("The " + className + " isn't in the IoC container", new Object[0]);
                try {
                    if (StringUtil.isDefined((String)param)) {
                        Constructor<?> constructor = propertyClass.getDeclaredConstructor(String.class);
                        return (T)constructor.newInstance(param);
                    }
                    Constructor<?> constructor = propertyClass.getDeclaredConstructor(new Class[0]);
                    return (T)constructor.newInstance(new Object[0]);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e2) {
                    throw new JobExecutionException((Throwable)e2);
                }
            }
        }
    }
}

