/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.scheduler.quartz;

import java.util.Date;
import org.quartz.JobDetail;
import org.quartz.JobExecutionException;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.core.scheduler.Job;
import org.silverpeas.core.scheduler.JobExecutionContext;
import org.silverpeas.core.scheduler.SchedulerEvent;
import org.silverpeas.core.scheduler.SchedulerEventListener;
import org.silverpeas.kernel.logging.SilverLogger;

public abstract class JobExecutor
implements org.quartz.Job {
    protected abstract Job getJob(JobDetail var1) throws JobExecutionException;

    protected abstract SchedulerEventListener getSchedulerEventListener(JobDetail var1) throws JobExecutionException;

    public final void execute(org.quartz.JobExecutionContext jec) throws JobExecutionException {
        JobDetail jobDetail = jec.getJobDetail();
        jobDetail.getJobDataMap().put("scheduled", false);
        Job job = this.getJob(jobDetail);
        SchedulerEventListener eventListener = this.getSchedulerEventListener(jobDetail);
        JobExecutionContext context = JobExecutionContext.createWith((String)job.getName(), (Date)jec.getFireTime());
        this.execute(context, job, eventListener);
    }

    protected final void execute(JobExecutionContext context, Job job, SchedulerEventListener eventListener) {
        CacheAccessorProvider.getThreadCacheAccessor().getCache().clear();
        if (eventListener == null) {
            try {
                job.execute(context);
            }
            catch (Exception ex) {
                SilverLogger.getLogger((Object)this).error(ex.getMessage(), (Throwable)ex);
            }
        } else {
            try {
                eventListener.triggerFired(SchedulerEvent.triggerFired((JobExecutionContext)context));
                job.execute(context);
                eventListener.jobSucceeded(SchedulerEvent.jobSucceeded((JobExecutionContext)context));
            }
            catch (Exception ex) {
                try {
                    eventListener.jobFailed(SchedulerEvent.jobFailed((JobExecutionContext)context, (Throwable)ex));
                }
                catch (Exception e) {
                    SilverLogger.getLogger((Object)this).error("Error while executing job {0}: {1}", (Object[])new String[]{job.getName(), e.getMessage()}, (Throwable)e);
                }
            }
        }
    }
}

