/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.persistence.jcr;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import org.apache.jackrabbit.util.Text;
import org.silverpeas.core.util.DateUtil;

public class JcrDataConverter {
    public static final String SPACE_TOKEN = "__";
    public static final String PATH_SEPARATOR = "/";
    private static final String ILLEGAL_JCR_CHARACTERS_REGEXP = "[%:\\[\\]*'\"|\t\r\n]";

    private JcrDataConverter() {
    }

    public static String convertToJcrPath(String name) {
        String coolName = name.replace(" ", SPACE_TOKEN);
        StringBuilder buffer = new StringBuilder(coolName.length() + 10);
        StringTokenizer tokenizer = new StringTokenizer(coolName, PATH_SEPARATOR, true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (PATH_SEPARATOR.equals(token)) {
                buffer.append(token);
                continue;
            }
            buffer.append(Text.escapeIllegalJcrChars((String)token));
        }
        return buffer.toString();
    }

    public static String escapeIllegalJcrChars(String name) {
        return name.replaceAll(ILLEGAL_JCR_CHARACTERS_REGEXP, " ").trim();
    }

    public static String convertFromJcrPath(String name) {
        return Text.unescapeIllegalJcrChars((String)name.replace(SPACE_TOKEN, " "));
    }

    public static Date parseDate(String date) throws ParseException {
        return DateUtil.parse((String)date);
    }

    public static String formatDate(Date date) {
        return DateUtil.formatDate((Date)date);
    }

    public static String formatDate(Calendar calendar) {
        return DateUtil.formatDate((Calendar)calendar);
    }

    public static void setTime(Calendar calendar, String time) {
        DateUtil.setTime((Calendar)calendar, (String)time);
    }

    public static String formatTime(Date date) {
        return DateUtil.formatTime((Date)date);
    }

    public static String formatTime(Calendar calendar) {
        return DateUtil.formatTime((Calendar)calendar);
    }

    public static String formatDateForXpath(Date date) {
        return "xs:dateTime('" + JcrDataConverter.getXpathFormattedDate(date) + "T" + JcrDataConverter.getXpathFormattedTime(date) + JcrDataConverter.getTimeZone(date) + "')";
    }

    protected static String getTimeZone(Date date) {
        SimpleDateFormat xpathTimezoneFormat = new SimpleDateFormat("Z");
        String timeZone = xpathTimezoneFormat.format(date);
        return timeZone.substring(0, timeZone.length() - 2) + ":" + timeZone.substring(timeZone.length() - 2);
    }

    protected static String getXpathFormattedTime(Date date) {
        SimpleDateFormat xpathTimeFormatter = new SimpleDateFormat("HH:mm:ss.SSS");
        return xpathTimeFormatter.format(date);
    }

    protected static String getXpathFormattedDate(Date date) {
        SimpleDateFormat xpathDateFormatter = new SimpleDateFormat("yyyy-MM-dd");
        return xpathDateFormatter.format(date);
    }
}

