/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.user.server.channel.silvermail;

import java.util.Date;
import java.util.Map;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.silverpeas.core.notification.user.client.NotificationParameterNames;
import org.silverpeas.core.notification.user.server.NotificationData;
import org.silverpeas.core.notification.user.server.NotificationServerException;
import org.silverpeas.core.notification.user.server.channel.AbstractListener;
import org.silverpeas.core.notification.user.server.channel.silvermail.SILVERMAILMessage;
import org.silverpeas.core.notification.user.server.channel.silvermail.SILVERMAILPersistence;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@MessageDriven(activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Queue"), @ActivationConfigProperty(propertyName="acknowledgeMode", propertyValue="Auto-acknowledge"), @ActivationConfigProperty(propertyName="messageSelector", propertyValue="CHANNEL='SILVERMAIL'"), @ActivationConfigProperty(propertyName="destinationLookup", propertyValue="jms/queue/notificationsQueue")}, description="Message driven bean to silverpeas notification box")
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class SILVERMAILListener
extends AbstractListener
implements MessageListener {
    public void onMessage(Message msg) {
        try {
            this.processMessage(msg);
        }
        catch (NotificationServerException e) {
            SilverLogger.getLogger((Object)this).error("Server notification processing failure", (Throwable)((Object)e));
        }
    }

    @Override
    public void send(NotificationData data) throws NotificationServerException {
        try {
            Map keyValue = data.getTargetParam();
            String tmpSubjectString = (String)keyValue.get(NotificationParameterNames.SUBJECT.toString());
            String tmpSourceString = (String)keyValue.get(NotificationParameterNames.SOURCE.toString());
            String tmpUrlString = (String)keyValue.get(NotificationParameterNames.URL.toString());
            Date tmpDate = (Date)keyValue.get(NotificationParameterNames.DATE.toString());
            SILVERMAILMessage sm = new SILVERMAILMessage();
            sm.setUserId(Integer.parseInt(data.getTargetReceipt()));
            String senderName = StringUtil.isDefined((String)data.getSenderName()) ? data.getSenderName() : "";
            sm.setSenderName(senderName);
            sm.setSubject(tmpSubjectString);
            sm.setUrl(tmpUrlString);
            sm.setSource(tmpSourceString);
            sm.setDate(tmpDate);
            sm.setBody(data.getMessage());
            SILVERMAILPersistence.addMessage(sm);
        }
        catch (Exception e) {
            throw new NotificationServerException(e);
        }
    }
}

