/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.user.client.model;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.inject.Singleton;
import javax.transaction.Transactional;
import org.silverpeas.core.notification.NotificationException;
import org.silverpeas.core.notification.user.client.NotificationMetaData;
import org.silverpeas.core.notification.user.client.UserRecipient;
import org.silverpeas.core.notification.user.client.model.SentNotificationDAO;
import org.silverpeas.core.notification.user.client.model.SentNotificationDetail;
import org.silverpeas.core.notification.user.client.model.SentNotificationInterface;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.personalization.service.PersonalizationServiceProvider;
import org.silverpeas.core.security.authorization.ForbiddenRuntimeException;
import org.silverpeas.kernel.exception.NotFoundException;

@Singleton
public class SentNotificationInterfaceImpl
implements SentNotificationInterface {
    protected SentNotificationInterfaceImpl() {
    }

    @Override
    @Transactional
    public void saveNotifUser(NotificationMetaData metaData, Set<UserRecipient> usersSet) throws NotificationException {
        try (Connection con = DBUtil.openConnection();){
            ArrayList<String> users = new ArrayList<String>();
            for (UserRecipient user : usersSet) {
                users.add(user.getUserId());
            }
            String language = PersonalizationServiceProvider.getPersonalizationService().getUserSettings(metaData.getSender()).getLanguage();
            SentNotificationDetail notif = new SentNotificationDetail(Integer.parseInt(metaData.getSender()), metaData.getMessageType(), metaData.getDate(), metaData.getTitle(language), metaData.getSource(), metaData.getLink().getLinkUrl(), metaData.getSessionId(), metaData.getComponentId(), metaData.getContent(language));
            notif.setUsers(users);
            int id = SentNotificationDAO.saveNotifUser(con, notif);
            notif.setNotifId(id);
        }
        catch (Exception e) {
            throw new NotificationException((Throwable)e);
        }
    }

    @Override
    public List<SentNotificationDetail> getAllNotifByUser(String userId) throws NotificationException {
        List<SentNotificationDetail> list;
        block8: {
            Connection con = DBUtil.openConnection();
            try {
                list = SentNotificationDAO.getAllNotifByUser(con, userId);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new NotificationException((Throwable)e);
                }
            }
            con.close();
        }
        return list;
    }

    @Override
    public SentNotificationDetail getNotification(String userId, int notifId) throws NotificationException {
        SentNotificationDetail notif;
        try (Connection con = DBUtil.openConnection();){
            notif = SentNotificationDAO.getNotif(con, notifId);
        }
        catch (Exception e) {
            throw new NotificationException((Throwable)e);
        }
        if (notif == null) {
            throw new NotFoundException(String.format("Sent notification %s not found for user %s", notifId, userId));
        }
        if (Integer.parseInt(userId) != notif.getUserId()) {
            throw new ForbiddenRuntimeException(String.format("Forbidden access to the sent notification %s for user %s", notifId, userId));
        }
        return notif;
    }

    @Override
    @Transactional
    public void deleteNotif(String userId, int notifId) throws NotificationException {
        try (Connection con = DBUtil.openConnection();){
            SentNotificationDetail toDel = this.getNotification(userId, notifId);
            SentNotificationDAO.deleteNotif(con, toDel.getNotifId());
        }
        catch (ForbiddenRuntimeException | NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NotificationException((Throwable)e);
        }
    }

    @Override
    @Transactional
    public void deleteNotifByUser(String userId) throws NotificationException {
        try (Connection con = DBUtil.openConnection();){
            SentNotificationDAO.deleteNotifByUser(con, userId);
        }
        catch (Exception e) {
            throw new NotificationException((Throwable)e);
        }
    }
}

