/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.user.client;

import org.silverpeas.core.admin.domain.model.Domain;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.kernel.logging.SilverLogger;

public interface NotificationURLProvider {
    default public String getApplicationURL() {
        return URLUtil.getApplicationURL();
    }

    default public String computeURL(Integer userId, String urlBase) {
        return this.computeURL(Integer.toString(userId), urlBase);
    }

    default public String computeURL(String userId, String urlBase) {
        return urlBase.startsWith("http") ? urlBase : this.getUserAutoRedirectURL(userId, urlBase);
    }

    default public String getUserAutoRedirectURL(String userId, String target) {
        String encodedTarget = URLUtil.encodeURL(target);
        try {
            UserDetail ud = UserDetail.getById(userId);
            Domain dom = ud.getDomain();
            String url = URLUtil.isPermalink(target) ? dom.getSilverpeasServerURL() + this.getApplicationURL() + target : this.getUserAutoRedirectURL(dom) + encodedTarget;
            return url;
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error("Error while getting user auto redirect url {0} for user {1}", (Object[])new String[]{target, userId}, (Throwable)e);
            return "ErrorGettingDomainServer" + encodedTarget;
        }
    }

    default public String getUserAutoRedirectURL(Domain dom) {
        return dom.getSilverpeasServerURL() + this.getApplicationURL() + "/autoRedirect.jsp?domainId=" + dom.getId() + "&goto=";
    }

    default public String getUserAutoRedirectSilverpeasServerURL(String userId) {
        return this.getUserAutoRedirectServerURL(userId) + this.getApplicationURL();
    }

    default public String getUserAutoRedirectServerURL(String userId) {
        UserDetail ud = UserDetail.getById(userId);
        Domain dom = ud.getDomain();
        return dom.getSilverpeasServerURL();
    }
}

