/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.user;

import org.silverpeas.core.contribution.publication.model.PublicationPK;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.notification.user.ComponentInstanceManualUserNotification;
import org.silverpeas.core.notification.user.NotificationContext;
import org.silverpeas.core.notification.user.UserNotification;
import org.silverpeas.core.security.authorization.ForbiddenRuntimeException;
import org.silverpeas.core.security.authorization.NodeAccessControl;
import org.silverpeas.core.security.authorization.PublicationAccessControl;
import org.silverpeas.kernel.util.StringUtil;

public abstract class AbstractComponentInstanceManualUserNotification
implements ComponentInstanceManualUserNotification {
    protected boolean check(NotificationContext context) {
        String componentId = context.getComponentId();
        if (StringUtil.isDefined((String)componentId)) {
            String publicationId = context.getPublicationId();
            if (StringUtil.isDefined((String)publicationId)) {
                return PublicationAccessControl.get().isUserAuthorized(context.getSender().getId(), new PublicationPK(publicationId, componentId));
            }
            String nodeId = context.getNodeId();
            if (StringUtil.isDefined((String)nodeId)) {
                return NodeAccessControl.get().isUserAuthorized(context.getSender().getId(), new NodePK(nodeId, componentId));
            }
        }
        return true;
    }

    public final UserNotification initializesWith(NotificationContext context) {
        if (!this.check(context)) {
            throw new ForbiddenRuntimeException("Cannot access resource with " + String.valueOf(context));
        }
        return this.createUserNotification(context);
    }

    protected abstract UserNotification createUserNotification(NotificationContext var1);
}

