/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.node.service;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.silverpeas.core.admin.component.model.ComponentInst;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.service.Administration;
import org.silverpeas.core.admin.user.model.ProfileInst;
import org.silverpeas.core.admin.user.notification.ProfileInstEvent;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.node.service.NodeProfileInstUpdater;
import org.silverpeas.core.notification.system.CDIResourceEventListener;
import org.silverpeas.kernel.SilverpeasRuntimeException;

@Service
public class NodeProfileInstEventListener
extends CDIResourceEventListener<ProfileInstEvent> {
    @Inject
    private Administration admin;
    @Inject
    private NodeProfileInstUpdater updater;

    @Transactional
    public void onUpdate(ProfileInstEvent event) {
        ProfileInst before = (ProfileInst)event.getTransition().getBefore();
        if (before.isOnComponentInstance()) {
            ProfileInst after = (ProfileInst)event.getTransition().getAfter();
            int instanceId = before.getComponentFatherId();
            ComponentInst instance = this.getComponentInstanceId(instanceId);
            List<String> groupsAfter = after.getAllGroups();
            Set<String> removedGroups = before.getAllGroups().stream().filter(group -> !groupsAfter.contains(group)).collect(Collectors.toSet());
            this.updater.getRemoverFor(instance.getId()).ofGroups(removedGroups).apply();
        }
    }

    private ComponentInst getComponentInstanceId(int localComponentId) {
        try {
            return this.admin.getComponentInst(String.valueOf(localComponentId));
        }
        catch (AdminException e) {
            throw new SilverpeasRuntimeException((Throwable)((Object)e));
        }
    }
}

