/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.io.temp;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.lang3.tuple.Pair;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.core.thread.ManagedThreadPool;
import org.silverpeas.kernel.logging.SilverLogger;

public class LastModifiedDateFileTask
implements Runnable {
    private static final Map<File, Long> requestMap = new LinkedHashMap<File, Long>();
    private static boolean running = false;

    private static void startIfNotAlreadyDone() {
        if (!LastModifiedDateFileTask.isRunning()) {
            running = true;
            ManagedThreadPool.getPool().invoke(new Runnable[]{new LastModifiedDateFileTask()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addFile(File file) {
        Map<File, Long> map = requestMap;
        synchronized (map) {
            requestMap.put(file, System.currentTimeMillis());
            LastModifiedDateFileTask.startIfNotAlreadyDone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRunning() {
        Map<File, Long> map = requestMap;
        synchronized (map) {
            return running;
        }
    }

    private LastModifiedDateFileTask() {
    }

    @Override
    public void run() {
        Pair<File, Long> pair = this.nextRequest();
        while (pair != null) {
            CacheAccessorProvider.getThreadCacheAccessor().getCache().clear();
            try {
                File currentFile = (File)pair.getKey();
                Long lastModifiedDate = (Long)pair.getValue();
                if (currentFile.isFile()) {
                    this.setLastModifiedDate(currentFile, lastModifiedDate);
                } else if (currentFile.isDirectory()) {
                    for (File file : FileUtils.listFilesAndDirs((File)currentFile, (IOFileFilter)FileFilterUtils.trueFileFilter(), (IOFileFilter)FileFilterUtils.trueFileFilter())) {
                        this.setLastModifiedDate(file, lastModifiedDate);
                    }
                }
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)e);
            }
            pair = this.nextRequest();
        }
    }

    private void setLastModifiedDate(File file, long lastModifiedDate) {
        boolean isOk = file.setLastModified(lastModifiedDate);
        if (!isOk) {
            SilverLogger.getLogger((Object)this).warn("Unable set last modification date to file " + file.getPath(), new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<File, Long> nextRequest() {
        Map<File, Long> map = requestMap;
        synchronized (map) {
            Pair nextRequest;
            if (!requestMap.isEmpty()) {
                File file = requestMap.keySet().iterator().next();
                Long newLastModifiedTime = requestMap.remove(file);
                nextRequest = Pair.of((Object)file, (Object)newLastModifiedTime);
            } else {
                nextRequest = null;
                running = false;
            }
            return nextRequest;
        }
    }
}

