/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.io.media.video.ffmpeg;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.exec.CommandLine;
import org.silverpeas.core.io.media.video.VideoThumbnailExtractorException;
import org.silverpeas.core.io.media.video.ffmpeg.FFmpegToolManager;
import org.silverpeas.core.util.exec.ExternalExecution;
import org.silverpeas.core.util.exec.ExternalExecutionException;

public class FFmpegUtil
extends ExternalExecution {
    public static boolean isActivated() {
        return FFmpegToolManager.isActivated();
    }

    static CommandLine buildFFmpegThumbnailExtractorCommandLine(File inputFile, File outputFile, double position) {
        HashMap<String, File> files = new HashMap<String, File>(2);
        files.put("inputFile", inputFile);
        files.put("outputFile", outputFile);
        CommandLine commandLine = new CommandLine("ffmpeg");
        commandLine.addArgument("-ss", false);
        commandLine.addArgument(Double.toString(position), false);
        commandLine.addArgument("-i", false);
        commandLine.addArgument("${inputFile}", false);
        commandLine.addArgument("-vframes", false);
        commandLine.addArgument("1", false);
        commandLine.addArgument("-vf", false);
        commandLine.addArgument("scale=600:-1", false);
        commandLine.addArgument("${outputFile}", false);
        commandLine.setSubstitutionMap(files);
        return commandLine;
    }

    public static List<String> extractVideoThumbnail(File videoFile, File outputFile, double position) {
        CommandLine cmd = FFmpegUtil.buildFFmpegThumbnailExtractorCommandLine(videoFile, outputFile, position);
        try {
            return FFmpegUtil.exec(cmd);
        }
        catch (ExternalExecutionException e) {
            throw new VideoThumbnailExtractorException((Exception)((Object)e));
        }
    }
}

