/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.io.media.image.option;

import java.util.stream.Stream;
import org.silverpeas.kernel.util.StringUtil;

public enum Orientation {
    TOP_LEFT("TopLeft"),
    TOP_RIGHT("TopRight"),
    BOTTOM_RIGHT("BottomRight"),
    BOTTOM_LEFT("BottomLeft"),
    LEFT_TOP("LeftTop"),
    RIGHT_TOP("RightTop"),
    RIGHT_BOTTOM("RightBottom"),
    LEFT_BOTTOM("LeftBottom"),
    AUTO("auto");

    private final String toolName;

    private Orientation(String toolName) {
        this.toolName = toolName;
    }

    public static Orientation decode(String orientation) {
        return Stream.of(Orientation.values()).filter(v -> v.toolName.equalsIgnoreCase(orientation) || StringUtil.isInteger((String)orientation) && v.ordinal() + 1 == Integer.parseInt(orientation)).findFirst().orElse(null);
    }

    public String getToolName() {
        return this.toolName;
    }
}

