/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.io.file;

import java.io.File;
import org.silverpeas.kernel.util.StringUtil;

public class SilverpeasFileDescriptor {
    private final String instanceId;
    private String directory;
    private String fileName;
    private String mimeType;
    private short flag;

    public SilverpeasFileDescriptor(String componentId) {
        this.instanceId = componentId;
    }

    public SilverpeasFileDescriptor() {
        this.instanceId = "";
    }

    public SilverpeasFileDescriptor parentDirectory(String directory) {
        this.directory = directory;
        return this;
    }

    public SilverpeasFileDescriptor fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public SilverpeasFileDescriptor mimeType(String mimeType) {
        this.mimeType = mimeType;
        return this;
    }

    public SilverpeasFileDescriptor temporaryFile() {
        this.flag = (short)2;
        return this;
    }

    public SilverpeasFileDescriptor absolutePath() {
        this.flag = 1;
        return this;
    }

    public String getComponentInstanceId() {
        return this.instanceId;
    }

    public String getParentDirectory() {
        return this.directory;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFilePath() {
        Object path = this.getFileName();
        if (StringUtil.isDefined((String)this.getParentDirectory())) {
            path = this.getParentDirectory() + File.separatorChar + (String)path;
        }
        return path;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public boolean isTemporaryFile() {
        return this.flag == 2;
    }

    public boolean isAbsolutePath() {
        return this.flag == 1;
    }
}

