/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.io.file;

import java.io.File;
import java.util.List;
import javax.inject.Inject;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.io.file.ImageCache;
import org.silverpeas.core.scheduler.Job;
import org.silverpeas.core.scheduler.JobExecutionContext;
import org.silverpeas.core.scheduler.Scheduler;
import org.silverpeas.core.scheduler.SchedulingInitializer;
import org.silverpeas.kernel.annotation.NonNull;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;

@Service
public class ResizedImageCacheCleaner
extends SchedulingInitializer {
    private static final String CRON_PROPERTY = "image.cleaner.cron";
    @Inject
    private Scheduler scheduler;
    private final Job job = new ResizedImageCacheCleanerJob();

    @NonNull
    protected String getCron() {
        SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.lookAndFeel.generalLook");
        return settings.getString(CRON_PROPERTY, "");
    }

    @NonNull
    protected Job getJob() {
        return this.job;
    }

    protected boolean isSchedulingEnabled() {
        return true;
    }

    private static class ResizedImageCacheCleanerJob
    extends Job {
        public ResizedImageCacheCleanerJob() {
            super(ResizedImageCacheCleanerJob.class.getSimpleName());
        }

        public void execute(JobExecutionContext context) {
            List<String> originalImagePaths = ImageCache.getAllImageEntries();
            for (String originalImagePath : originalImagePaths) {
                File originalImage = new File(originalImagePath);
                if (originalImage.exists()) continue;
                ImageCache.removeImages(originalImagePath);
            }
        }
    }
}

