/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.io.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import javax.inject.Inject;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.io.file.AbstractSilverpeasFileProcessor;
import org.silverpeas.core.io.file.ImageCache;
import org.silverpeas.core.io.file.SilverpeasFile;
import org.silverpeas.core.io.file.SilverpeasFileProcessor;
import org.silverpeas.core.io.media.image.ImageTool;
import org.silverpeas.core.io.media.image.ImageToolDirective;
import org.silverpeas.core.io.media.image.option.AbstractImageToolOption;
import org.silverpeas.core.io.media.image.option.DimensionOption;
import org.silverpeas.core.io.media.image.option.OrientationOption;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.core.util.file.FileRepositoryManager;
import org.silverpeas.core.util.file.FileUtil;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@Service
public class ImageResizingProcessor
extends AbstractSilverpeasFileProcessor {
    protected static final String IMAGE_CACHE_PATH = FileRepositoryManager.getAbsolutePath("cache");
    @Inject
    private ImageTool imageTool;

    @Override
    public String processBefore(String path, SilverpeasFileProcessor.ProcessingContext context) {
        String imagePath = path;
        if (context == SilverpeasFileProcessor.ProcessingContext.GETTING) {
            imagePath = this.resizeImage(path);
        }
        return imagePath;
    }

    @Override
    public SilverpeasFile processAfter(SilverpeasFile file, SilverpeasFileProcessor.ProcessingContext context) {
        if (context == SilverpeasFileProcessor.ProcessingContext.DELETION || context == SilverpeasFileProcessor.ProcessingContext.MOVING) {
            this.removeResizedImagesOf(file);
        }
        return file;
    }

    private ResizingParameters computeResizingParameters(File image) {
        ResizingParameters parameters = ResizingParameters.NO_RESIZING;
        String parent = image.getParentFile().getName();
        if (parent.contains("x")) {
            String[] size = parent.split("x");
            Integer width = null;
            Integer height = null;
            try {
                File imageSource;
                if (StringUtil.isDefined((String)size[0])) {
                    width = Integer.valueOf(size[0]);
                }
                if (size.length == 2) {
                    height = Integer.valueOf(size[1]);
                }
                if ((imageSource = new File(image.getParentFile().getParent(), image.getName())).exists() && (width != null || height != null)) {
                    String fileName = imageSource.lastModified() + "_" + imageSource.getName();
                    File imageDestination = new File(IMAGE_CACHE_PATH + parent, fileName);
                    parameters = new ResizingParameters(imageSource, imageDestination, width, height);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return parameters;
    }

    private void removeResizedImagesOf(File originaImage) {
        List<String> resizedImagePaths = ImageCache.getImages(originaImage.getAbsolutePath());
        for (String resizedImage : resizedImagePaths) {
            try {
                Files.delete(Path.of(resizedImage, new String[0]));
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).warn("The resized image {0} for the in deletion original image {1} cannot be deleted!", new Object[]{resizedImage, originaImage.getAbsolutePath()});
            }
        }
    }

    private String resizeImage(String path) {
        ResizingParameters parameters;
        if (!FileUtil.isImage(path)) {
            return path;
        }
        String imagePath = path;
        File sourceImage = new File(imagePath);
        if (!sourceImage.exists() && (parameters = this.computeResizingParameters(sourceImage)).isDefined()) {
            sourceImage = parameters.getSourceImage();
            File resizedImage = parameters.getDestinationImage();
            imagePath = resizedImage.getPath();
            if (sourceImage.exists() && (!resizedImage.exists() || sourceImage.lastModified() >= resizedImage.lastModified())) {
                ImageResizingProcessor.createImageFolder(resizedImage.getParentFile());
                DimensionOption dimension = DimensionOption.widthAndHeight(parameters.getWidth(), parameters.getHeight());
                OrientationOption auto = OrientationOption.auto();
                this.imageTool.convert(sourceImage, resizedImage, CollectionUtil.asSet((Object[])new AbstractImageToolOption[]{dimension, auto}), ImageToolDirective.GEOMETRY_SHRINK);
                ImageCache.putImage(sourceImage.getAbsolutePath(), resizedImage.getAbsolutePath());
            }
        }
        return imagePath;
    }

    private static void createImageFolder(File directory) {
        if (!directory.exists()) {
            try {
                Files.createDirectories(directory.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new SilverpeasRuntimeException((Throwable)e);
            }
        }
    }

    private static class ResizingParameters {
        private static final ResizingParameters NO_RESIZING = new ResizingParameters(null, null, -1, -1);
        private final Integer width;
        private final Integer height;
        private final File sourceImage;
        private final File destinationImage;

        public ResizingParameters(File sourceImage, File destinationImage, Integer width, Integer height) {
            this.height = height;
            this.width = width;
            this.sourceImage = sourceImage;
            this.destinationImage = destinationImage;
        }

        public Integer getWidth() {
            return this.width;
        }

        public Integer getHeight() {
            return this.height;
        }

        public File getSourceImage() {
            return this.sourceImage;
        }

        public File getDestinationImage() {
            return this.destinationImage;
        }

        public boolean isDefined() {
            return this != NO_RESIZING;
        }
    }
}

