/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.index.indexing.model;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.Date;
import java.util.Objects;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.kernel.util.StringUtil;

public class FieldDescription
implements Serializable {
    private static final long serialVersionUID = -475049855423827178L;
    private final String content;
    private final String lang;
    private final String fieldName;
    private final boolean stored;
    private final boolean basedOnDates;
    private final LocalDate startDate;
    private final LocalDate endDate;

    public FieldDescription(String fieldName, String content, String lang) {
        this.content = content;
        this.lang = I18NHelper.checkLanguage(lang);
        this.fieldName = fieldName;
        this.stored = false;
        this.basedOnDates = false;
        this.startDate = null;
        this.endDate = null;
    }

    public FieldDescription(String fieldName, String content, String lang, boolean stored) {
        this.content = content;
        this.lang = I18NHelper.checkLanguage(lang);
        this.fieldName = fieldName;
        this.stored = stored;
        this.basedOnDates = false;
        this.startDate = null;
        this.endDate = null;
    }

    public FieldDescription(String fieldName, Date date, String lang, boolean stored) {
        this.content = DateUtil.formatAsLuceneDate((LocalDate)DateUtil.toLocalDate((Date)date));
        this.lang = I18NHelper.checkLanguage(lang);
        this.fieldName = fieldName;
        this.stored = stored;
        this.basedOnDates = false;
        this.startDate = null;
        this.endDate = null;
    }

    public FieldDescription(String fieldName, Date begin, Date end, String lang) {
        this.content = "";
        this.lang = I18NHelper.checkLanguage(lang);
        this.fieldName = fieldName;
        this.stored = false;
        this.basedOnDates = true;
        this.startDate = DateUtil.toLocalDate((Date)begin);
        this.endDate = DateUtil.toLocalDate((Date)end);
    }

    public boolean isBasedOnDate() {
        return this.basedOnDates;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getContent() {
        return this.content;
    }

    public String getLang() {
        return this.lang;
    }

    public boolean isStored() {
        return this.stored;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public boolean isEmpty() {
        return StringUtil.isNotDefined((String)this.content);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldDescription that = (FieldDescription)o;
        return this.stored == that.stored && this.basedOnDates == that.basedOnDates && Objects.equals(this.content, that.content) && Objects.equals(this.lang, that.lang) && Objects.equals(this.fieldName, that.fieldName) && Objects.equals(this.startDate, that.startDate) && Objects.equals(this.endDate, that.endDate);
    }

    public int hashCode() {
        return Objects.hash(this.content, this.lang, this.fieldName, this.stored, this.basedOnDates, this.startDate, this.endDate);
    }
}

