/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.datereminder.persistence;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.silverpeas.core.datereminder.exception.DateReminderValidationException;
import org.silverpeas.core.datereminder.persistence.DateReminderDetail;
import org.silverpeas.core.persistence.EntityReference;
import org.silverpeas.core.persistence.ResourceBelonging;
import org.silverpeas.core.persistence.datasource.model.identifier.UuidIdentifier;
import org.silverpeas.core.persistence.datasource.model.jpa.SilverpeasJpaEntity;
import org.silverpeas.kernel.util.StringUtil;

@Entity
@Table(name="st_dateReminder")
@NamedQueries(value={@NamedQuery(name="getResource", query="select p from PersistentResourceDateReminder p where p.resourceType = :type and p.resourceId = :resourceId"), @NamedQuery(name="getListResourceByDeadLine", query="select p from PersistentResourceDateReminder p where p.processStatus = 0 and p.dateReminder <= :dateReminder")})
public class PersistentResourceDateReminder
extends SilverpeasJpaEntity<PersistentResourceDateReminder, UuidIdentifier>
implements ResourceBelonging {
    private static final long serialVersionUID = 5956074363457906409L;
    public static final PersistentResourceDateReminder NONEDATEREMINDER = new PersistentResourceDateReminder();
    @Column(name="resourceType", nullable=false)
    private String resourceType = "UNKNOWN";
    @Column(name="resourceId", nullable=false)
    private String resourceId;
    @Column(name="dateReminder", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateReminder;
    @Column(name="message")
    private String message;
    @Column(name="processStatus")
    private int processStatus;

    public boolean exists() {
        return this.getId() != null;
    }

    public boolean notExists() {
        return this.getId() == null;
    }

    public void validate() throws DateReminderValidationException {
        if (this.resourceType == null || "UNKNOWN".equals(this.resourceType) || !StringUtil.isDefined((String)this.resourceId)) {
            throw new DateReminderValidationException("The dateReminder isn't valid! Missing resource reference");
        }
        if (this.dateReminder == null) {
            throw new DateReminderValidationException("The dateReminder isn't valid! Missing the date");
        }
    }

    public void setResource(EntityReference<?> resource) {
        if (resource != null) {
            this.resourceType = resource.getType();
            this.resourceId = resource.getId();
        }
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public DateReminderDetail getDateReminder() {
        return new DateReminderDetail(this.dateReminder, this.message, this.processStatus, this.getCreatorId(), this.getLastUpdaterId());
    }

    private void setCreatorId(String userId) {
        super.createdBy(userId);
    }

    private void setUpdaterId(String userId) {
        super.lastUpdatedBy(userId);
    }

    public void setDateReminder(DateReminderDetail dateReminder) {
        if (dateReminder != null) {
            this.dateReminder = dateReminder.getDateReminder();
            this.message = dateReminder.getMessage();
            this.processStatus = dateReminder.getProcessStatus();
            this.setCreatorId(dateReminder.getCreatorId());
            this.setUpdaterId(dateReminder.getUpdaterId());
        }
    }

    public boolean isDefined() {
        return this.isPersisted() && this != NONEDATEREMINDER;
    }

    public String toString() {
        return "PersistentResourceDateReminder{resourceType='" + this.resourceType + "', resourceId='" + this.resourceId + "', dateReminder ='" + String.valueOf(this.dateReminder) + "', message ='" + this.message + "'}";
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }
}

