/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.rating.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.contribution.rating.model.ContributionRatingPK;
import org.silverpeas.core.contribution.rating.model.RaterRating;
import org.silverpeas.kernel.util.StringUtil;

public class ContributionRating
implements Serializable {
    private static final long serialVersionUID = 5611801738147739307L;
    private ContributionRatingPK pk;
    private float ratingAverage = 0.0f;
    private Map<String, Integer> raterRatings = new HashMap<String, Integer>();

    public ContributionRating(ContributionRatingPK pk) {
        this.pk = pk;
    }

    public String getInstanceId() {
        return this.pk.getInstanceId();
    }

    public String getContributionId() {
        return this.pk.getContributionId();
    }

    public String getContributionType() {
        return this.pk.getContributionType();
    }

    public float getRatingAverage() {
        if (this.ratingAverage == 0.0f && this.raterRatings.size() > 0) {
            float sum = 0.0f;
            for (Integer aRaterRating : this.raterRatings.values()) {
                sum += (float)aRaterRating.intValue();
            }
            this.ratingAverage = sum / (float)this.raterRatings.size();
        } else if (this.ratingAverage != 0.0f && this.raterRatings.isEmpty()) {
            this.ratingAverage = 0.0f;
        }
        return this.ratingAverage;
    }

    public void addRaterRating(String raterId, Integer ratingValue) {
        this.raterRatings.put(raterId, ratingValue);
        this.ratingAverage = 0.0f;
    }

    public RaterRating getRaterRating(UserDetail rater) {
        Integer raterRatingValue;
        Integer n = raterRatingValue = rater != null && StringUtil.isDefined((String)rater.getId()) ? this.raterRatings.get(rater.getId()) : null;
        if (raterRatingValue == null) {
            return new RaterRating(this, rater);
        }
        return new RaterRating(this, rater, raterRatingValue);
    }

    public Map<String, Integer> getRaterRatings() {
        return this.raterRatings;
    }
}

