/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.wysiwyg.service.process;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.FileDataSource;
import javax.inject.Singleton;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.contribution.attachment.model.SimpleDocumentMailAttachedFile;
import org.silverpeas.core.contribution.content.AbstractLocalhostLinkUrlDataSourceScanner;
import org.silverpeas.core.contribution.content.LinkUrlDataSource;
import org.silverpeas.core.contribution.content.LinkUrlDataSourceScanner;
import org.silverpeas.core.contribution.content.wysiwyg.service.WysiwygContentTransformer;
import org.silverpeas.core.contribution.content.wysiwyg.service.WysiwygContentTransformerProcess;
import org.silverpeas.core.contribution.content.wysiwyg.service.process.MailContentProcessException;
import org.silverpeas.core.mail.MailAddress;
import org.silverpeas.core.mail.MailContent;
import org.silverpeas.core.mail.MailSending;
import org.silverpeas.core.util.StringDataExtractor;
import org.silverpeas.core.util.file.FileUtil;
import org.silverpeas.kernel.SilverpeasException;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.util.Mutable;
import org.silverpeas.kernel.util.StringUtil;

public class MailContentProcess
implements WysiwygContentTransformerProcess<MailResult> {
    @Override
    public MailResult execute(String wysiwygContent) throws SilverpeasException {
        try {
            ArrayList<MimeBodyPart> bodyParts = new ArrayList<MimeBodyPart>();
            HashMap mailAttachmentCidCache = new HashMap();
            Mutable transformedWysiwygContent = Mutable.of((Object)wysiwygContent).filter(StringUtil::isDefined).map(MailContent::normalizeHtmlContent);
            IdentifierGenerator idCount = new IdentifierGenerator();
            LinkUrlDataSourceScanner.getAll().forEach(u -> u.scanHtml((String)transformedWysiwygContent.get()).forEach(d -> mailAttachmentCidCache.computeIfAbsent(d.getLinkUrl(), l -> {
                Mutable<String> cid = this.generateCid(idCount, (LinkUrlDataSource)d);
                cid.ifPresent(c -> {
                    try {
                        MimeBodyPart mbp = new MimeBodyPart();
                        mbp.setDataHandler(new DataHandler(d.getDataSource()));
                        mbp.setHeader("Content-ID", "<" + c + ">");
                        bodyParts.add(mbp);
                        String previousContent = (String)transformedWysiwygContent.get();
                        transformedWysiwygContent.set((Object)this.replaceLinkByCid(previousContent, (String)l, (String)c));
                    }
                    catch (MessagingException me) {
                        throw new SilverpeasRuntimeException((Throwable)me);
                    }
                });
                return Optional.ofNullable((String)cid.orElse(null));
            })));
            String finalContent = WysiwygContentTransformer.on((String)transformedWysiwygContent.get()).applyMailLinkCssDirective().transform();
            return new MailResult(finalContent, bodyParts);
        }
        catch (Exception e) {
            throw new SilverpeasException((Throwable)e);
        }
    }

    private Mutable<String> generateCid(IdentifierGenerator idCount, LinkUrlDataSource d) {
        Mutable cid = Mutable.empty();
        if (d.getDataSource() instanceof FileDataSource) {
            FileDataSource fileDataSource = (FileDataSource)d.getDataSource();
            if (fileDataSource.getFile().exists() && FileUtil.isImage(fileDataSource.getFile().getPath())) {
                cid.set((Object)idCount.newOne());
            }
        } else {
            cid.set((Object)idCount.newOne());
        }
        return cid;
    }

    private String replaceLinkByCid(String wysiwygContent, String link, String cid) {
        return wysiwygContent.replace("=\"" + link + "\"", "=\"cid:" + cid + "\"");
    }

    private static class IdentifierGenerator {
        private int count = 0;

        private IdentifierGenerator() {
        }

        String newOne() {
            return "mail-content-attachment-" + this.count++;
        }
    }

    public static class MailResult {
        private static final SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.wysiwyg.settings.wysiwygSettings");
        private final String wysiwygContent;
        private final List<MimeBodyPart> bodyParts;
        private String mimeMultipart;
        private final Set<MailContent.AttachedFile> attachments = new HashSet<MailContent.AttachedFile>();

        private MailResult(String wysiwygContent, List<MimeBodyPart> bodyParts) {
            this.wysiwygContent = wysiwygContent;
            this.bodyParts = bodyParts;
            this.mimeMultipart = settings.getString("mail.mime.multipart", "related");
        }

        public String getWysiwygContent() {
            return this.wysiwygContent;
        }

        protected List<MimeBodyPart> getBodyParts() {
            return this.bodyParts;
        }

        public MailResult withMimeMultipart(String mimeMultipart) {
            this.mimeMultipart = mimeMultipart;
            return this;
        }

        public MailResult addAttachments(Collection<SimpleDocument> attachments) {
            attachments.stream().map(SimpleDocumentMailAttachedFile::new).forEach(this::addAttachedFile);
            return this;
        }

        public MailResult addAttachedFiles(Collection<MailContent.AttachedFile> attachments) {
            attachments.forEach(this::addAttachedFile);
            return this;
        }

        public MailResult addAttachedFile(MailContent.AttachedFile attachedFile) {
            this.attachments.add(attachedFile);
            return this;
        }

        public MailSending prepareMailSendingFrom(MailAddress email) throws MailContentProcessException {
            MailSending mailSending = MailSending.from(email);
            try {
                mailSending.withContent(this.createContentMessageMail(this));
            }
            catch (MessagingException | SilverpeasException e) {
                throw new MailContentProcessException(e);
            }
            return mailSending;
        }

        private Multipart createContentMessageMail(MailResult mailResult) throws MessagingException, SilverpeasException {
            MimeMultipart multipart = new MimeMultipart(this.mimeMultipart);
            String htmlContent = mailResult.getWysiwygContent();
            if ("alternative".equals(this.mimeMultipart)) {
                multipart.addBodyPart((BodyPart)MailContent.extractTextBodyPartFromHtmlContent(htmlContent));
                mailResult.applyOn((Multipart)multipart);
                multipart.addBodyPart((BodyPart)MailContent.getHtmlBodyPartFromHtmlContent(htmlContent));
            } else {
                multipart.addBodyPart((BodyPart)MailContent.getHtmlBodyPartFromHtmlContent(htmlContent));
                mailResult.applyOn((Multipart)multipart);
                multipart.addBodyPart((BodyPart)MailContent.extractTextBodyPartFromHtmlContent(htmlContent));
            }
            for (MailContent.AttachedFile attachment : this.attachments) {
                multipart.addBodyPart((BodyPart)attachment.toBodyPart());
            }
            return multipart;
        }

        private void applyOn(Multipart multipart) throws SilverpeasException {
            try {
                for (MimeBodyPart mimeBodyPart : this.getBodyParts()) {
                    multipart.addBodyPart((BodyPart)mimeBodyPart);
                }
            }
            catch (MessagingException e) {
                throw new SilverpeasException((Throwable)e);
            }
        }
    }

    @Singleton
    public static class WysiwygCkeditorMediaLinkUrlToDataSourceScanner
    extends AbstractLocalhostLinkUrlDataSourceScanner {
        private static final Pattern CKEDITOR_LINK_PATTERNS = Pattern.compile("(?i)=\"([^\"]*/wysiwyg/jsp/ckeditor/[^\"]+)");

        @Override
        protected List<StringDataExtractor.ExtractorDirective> directives() {
            return Collections.singletonList(StringDataExtractor.RegexpPatternDirective.regexp(CKEDITOR_LINK_PATTERNS, 1));
        }
    }
}

