/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.form.displayers;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.fileupload.FileItem;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.PagesContext;
import org.silverpeas.core.contribution.content.form.Util;
import org.silverpeas.core.contribution.content.form.displayers.AbstractFieldDisplayer;
import org.silverpeas.core.contribution.content.form.field.ExplorerField;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.core.util.WebEncodeHelper;
import org.silverpeas.core.util.file.FileUploadUtil;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class ExplorerFieldDisplayer
extends AbstractFieldDisplayer<ExplorerField> {
    public String[] getManagedTypes() {
        return new String[]{"explorer"};
    }

    @Override
    public void displayScripts(PrintWriter out, FieldTemplate template, PagesContext pageContext) {
        if (!"explorer".equals(template.getTypeName())) {
            SilverLogger.getLogger((Object)this).warn("The expected type of the explorer field is invalid: " + template.getTypeName(), new Object[0]);
        }
        ExplorerFieldDisplayer.produceMandatoryCheck(out, template, pageContext);
        Util.getJavascriptChecker(template.getFieldName(), pageContext, out);
    }

    @Override
    public void display(PrintWriter out, ExplorerField field, FieldTemplate template, PagesContext pageContext) throws FormException {
        String language = pageContext.getLanguage();
        String selectImg = Util.getIcon("explorer");
        String selectLabel = Util.getString("field.explorer.browse", language);
        String deleteImg = Util.getIcon("delete");
        String deleteLabel = Util.getString("GML.delete", language);
        String path = "";
        String nodePK = "";
        Object html2 = "";
        String fieldName = template.getFieldName();
        if (field.getTypeName().equals("explorer")) {
            nodePK = field.getNodePK();
        }
        if (!field.isNull()) {
            path = field.getValue(language);
        }
        html2 = (String)html2 + "<input type=\"hidden\" id=\"" + fieldName + "\" name=\"" + fieldName + "\" value=\"" + WebEncodeHelper.javaStringToHtmlString((String)nodePK) + "\"/>";
        if (!template.isHidden()) {
            html2 = (String)html2 + "<input type=\"text\" disabled=\"disabled\" size=\"50\" id=\"" + fieldName + "_path\" name=\"" + fieldName + "$$path\" value=\"" + WebEncodeHelper.javaStringToHtmlString((String)path) + "\"/>";
        }
        if (!(template.isHidden() || template.isDisabled() || template.isReadOnly())) {
            Map<String, String> parameters = template.getParameters(pageContext.getLanguage());
            String scope = parameters.get("scope");
            html2 = (String)html2 + "&nbsp;<a href=\"#\" onclick=\"javascript:SP_openWindow('" + URLUtil.getApplicationURL() + "/explorer/jsp/explorer.jsp?elementHidden=" + fieldName + "&elementVisible=" + fieldName + "_path&scope=" + scope;
            html2 = (String)html2 + "','explorer',800,600,'scrollbars=yes');return false;\" >";
            html2 = (String)html2 + "<img src=\"" + selectImg + "\" width=\"15\" height=\"15\" border=\"0\" alt=\"" + selectLabel + "\" align=\"top\" title=\"" + selectLabel + "\"/></a>";
            html2 = (String)html2 + "&nbsp;<a href=\"#\" onclick=\"javascript:document." + pageContext.getFormName() + "." + fieldName + ".value='';document." + pageContext.getFormName() + "." + fieldName + "$$path.value='';return false;\">";
            html2 = (String)html2 + "<img src=\"" + deleteImg + "\" width=\"15\" height=\"15\" border=\"0\" alt=\"" + deleteLabel + "\" align=\"top\" title=\"" + deleteLabel + "\"/></a>";
            if (template.isMandatory() && pageContext.useMandatory()) {
                html2 = (String)html2 + Util.getMandatorySnippet();
            }
        }
        out.println((String)html2);
    }

    @Override
    public List<String> update(String newId, ExplorerField field, FieldTemplate template, PagesContext pageContext) throws FormException {
        if ("explorer".equals(field.getTypeName())) {
            if (!StringUtil.isDefined((String)newId)) {
                field.setNull();
            } else {
                field.setNodePK(newId);
            }
        } else {
            throw new FormException("Incorrect field value type. Expected {0}", "explorer");
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isDisplayedMandatory() {
        return true;
    }

    @Override
    public int getNbHtmlObjectsDisplayed(FieldTemplate template, PagesContext pageContext) {
        return 2;
    }

    @Override
    public List<String> update(List<FileItem> items, ExplorerField field, FieldTemplate template, PagesContext pageContext) throws FormException {
        String itemName = template.getFieldName();
        String value = FileUploadUtil.getParameter(items, itemName);
        if (pageContext.getUpdatePolicy() == 1 && !StringUtil.isDefined((String)value)) {
            return new ArrayList<String>();
        }
        return this.update(value, field, template, pageContext);
    }
}

