/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.form;

import java.util.ArrayList;
import java.util.List;
import org.silverpeas.core.contribution.content.form.DataRecord;
import org.silverpeas.core.contribution.content.form.Field;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.displayers.WysiwygFCKFieldDisplayer;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.kernel.logging.SilverLogger;

public class DataRecordUtil {
    private static final String VARIABLE_PREFIX = "${";
    private static final String VARIABLE_SUFFIX = "}";
    private static final String FOLDER_PREFIX = "folder.";

    private DataRecordUtil() {
        throw new IllegalAccessError("Utility class");
    }

    public static void updateFields(String[] fieldNames, DataRecord updatedRecord, DataRecord copiedRecord, String language) throws FormException {
        for (String fieldName : fieldNames) {
            DataRecordUtil.updateField(fieldName, updatedRecord, copiedRecord, language);
        }
    }

    private static void updateField(String fieldName, DataRecord updatedRecord, DataRecord copiedRecord, String language) throws FormException {
        Field updatedField = updatedRecord.getField(fieldName);
        try {
            Field copiedField = copiedRecord.getField(fieldName);
            if (copiedField != null) {
                if (updatedField.getTypeName().equals(copiedField.getTypeName())) {
                    Object value = copiedField.getObjectValue();
                    if (value instanceof String) {
                        updatedField.setObjectValue(DataRecordUtil.applySubstitution((String)value, updatedRecord, language));
                    } else {
                        updatedField.setObjectValue(copiedField.getObjectValue());
                    }
                } else {
                    updatedField.setValue(copiedField.getValue());
                }
            }
        }
        catch (FormException ignored) {
            SilverLogger.getLogger(DataRecordUtil.class).warn("Field '" + fieldName + "' is unknown", new Object[]{ignored});
        }
    }

    public static String applySubstitution(String text, DataRecord data, String lang) {
        String appliedText = DataRecordUtil.applySubstitution(text, data, lang, new ArrayList<String>());
        appliedText = DataRecordUtil.applySubstitution(appliedText, data, lang, new ArrayList<String>());
        return appliedText;
    }

    private static String applySubstitution(String text, DataRecord data, String lang, List<String> resolvedVars) {
        Object value;
        String suffix;
        if (text == null) {
            return "";
        }
        int varBegin = text.indexOf(VARIABLE_PREFIX);
        if (varBegin == -1) {
            return text;
        }
        int varEnd = text.indexOf(VARIABLE_SUFFIX, varBegin);
        if (varEnd == -1) {
            return text;
        }
        String var = text.substring(varBegin + VARIABLE_PREFIX.length(), varEnd);
        String prefix = text.substring(0, varBegin);
        String string = suffix = varEnd + 1 < text.length() ? text.substring(varEnd + 1) : null;
        if (resolvedVars.contains(var)) {
            value = VARIABLE_PREFIX + var + VARIABLE_SUFFIX;
        } else {
            resolvedVars.add(var);
            value = DataRecordUtil.getFieldValue(var, data, lang);
        }
        if (suffix != null) {
            suffix = DataRecordUtil.applySubstitution(suffix, data, lang, resolvedVars);
            return prefix + (String)value + suffix;
        }
        return prefix + (String)value;
    }

    private static String getFieldValue(String fieldName, DataRecord data, String lang) {
        Object value = "";
        try {
            Field field = DataRecordUtil.getField(fieldName, data);
            if (field != null) {
                value = field.getValue(lang);
                if ("date".equals(field.getTypeName())) {
                    value = DataRecordUtil.getOutputDate(field, lang);
                } else if (value != null && ((String)value).startsWith("xmlWysiwygField_")) {
                    String fileName = ((String)value).substring("xmlWysiwygField_".length());
                    value = WysiwygFCKFieldDisplayer.getContentFromFile(data.getResourceReference().getComponentInstanceId(), fileName);
                    value = ((String)value).replace("\r\n", "");
                }
            }
            if (value == null) {
                value = "";
            }
        }
        catch (FormException e) {
            SilverLogger.getLogger(DataRecordUtil.class).warn("Field '" + fieldName + "' is unknown. Error: " + e.getMessage(), new Object[0]);
            value = VARIABLE_PREFIX + fieldName + VARIABLE_SUFFIX;
        }
        return value;
    }

    private static Field getField(String fieldName, DataRecord data) throws FormException {
        Field field = data.getField(fieldName);
        if (field != null) {
            return field;
        }
        if (fieldName.startsWith(FOLDER_PREFIX)) {
            return data.getField(fieldName.substring(FOLDER_PREFIX.length()));
        }
        return null;
    }

    private static String getOutputDate(Field field, String lang) {
        try {
            return DateUtil.getOutputDate((String)field.getValue(), (String)lang);
        }
        catch (Exception e) {
            SilverLogger.getLogger(DataRecordUtil.class).warn("Can't parse date '" + field.getValue() + "' from field '" + field.getName() + "'", new Object[]{e});
            return field.getValue();
        }
    }
}

