/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.attachment.repository;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.qom.ChildNode;
import javax.jcr.query.qom.Comparison;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.DescendantNode;
import javax.jcr.query.qom.DynamicOperand;
import javax.jcr.query.qom.Ordering;
import javax.jcr.query.qom.QueryObjectModel;
import javax.jcr.query.qom.QueryObjectModelFactory;
import javax.jcr.query.qom.Selector;
import javax.jcr.query.qom.Source;
import javax.jcr.query.qom.StaticOperand;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import javax.jcr.version.VersionManager;
import org.apache.commons.io.FileUtils;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.WAPrimaryKey;
import org.silverpeas.core.annotation.Repository;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.core.contribution.attachment.model.DocumentType;
import org.silverpeas.core.contribution.attachment.model.HistorisedDocument;
import org.silverpeas.core.contribution.attachment.model.SimpleAttachment;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.contribution.attachment.model.SimpleDocumentPK;
import org.silverpeas.core.contribution.attachment.model.SimpleDocumentVersion;
import org.silverpeas.core.contribution.attachment.repository.DocumentConverter;
import org.silverpeas.core.contribution.attachment.util.AttachmentSettings;
import org.silverpeas.core.contribution.attachment.util.SimpleDocumentList;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.io.media.image.ImageTool;
import org.silverpeas.core.io.media.image.ImageToolDirective;
import org.silverpeas.core.io.media.image.option.OrientationOption;
import org.silverpeas.core.jcr.JCRSession;
import org.silverpeas.core.persistence.jcr.util.NodeIterable;
import org.silverpeas.core.persistence.jcr.util.PropertyIterable;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.util.file.FileRepositoryManager;
import org.silverpeas.core.util.file.FileUtil;
import org.silverpeas.kernel.cache.model.SimpleCache;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.Pair;
import org.silverpeas.kernel.util.StringUtil;

@Repository
public class DocumentRepository {
    private static final String SIMPLE_DOCUMENT_ALIAS = "SimpleDocuments";
    final DocumentConverter converter;

    public DocumentRepository() {
        this(new DocumentConverter());
    }

    protected DocumentRepository(DocumentConverter converter) {
        this.converter = converter;
    }

    private void prepareComponentAttachments(String instanceId, String folder) throws RepositoryException {
        try (JCRSession session = JCRSession.openSystemSession();){
            this.prepareComponentAttachments((Session)session, instanceId, folder);
            session.save();
        }
    }

    protected Node prepareComponentAttachments(Session session, String instanceId, String folder) throws RepositoryException {
        Node targetInstanceNode = this.converter.getFolder(session.getRootNode(), instanceId);
        return this.converter.getFolder(targetInstanceNode, folder);
    }

    public SimpleDocumentPK createDocument(Session session, SimpleDocument document) throws RepositoryException {
        if (0 >= document.getOrder()) {
            this.getMinMaxOrderIndexes(session, document.getInstanceId(), document.getForeignId(), document.getDocumentType()).ifPresent(i -> {
                Integer minOrderIndex = (Integer)i.getFirst();
                if (AttachmentSettings.listFromYoungestToOldestAdd() && minOrderIndex > 100000) {
                    document.setOrder(minOrderIndex - 1);
                } else {
                    document.setOrder((Integer)i.getSecond() + 1);
                }
            });
        }
        Node docsNode = this.prepareComponentAttachments(session, document.getInstanceId(), document.getFolder());
        Node documentNode = docsNode.addNode(document.computeNodeName(), "slv:simpleDocument");
        document.setUpdatedBy(document.getCreatedBy());
        document.setLastUpdateDate(document.getCreationDate());
        this.converter.fillNode(document, documentNode);
        if (document.isVersioned()) {
            documentNode.addMixin("{http://www.jcp.org/jcr/mix/1.0}versionable");
        }
        document.setId(documentNode.getIdentifier());
        document.setOldSilverpeasId(documentNode.getProperty("slv:oldSilverpeasId").getLong());
        return document.getPk();
    }

    public SimpleDocumentPK moveDocument(Session session, SimpleDocument document, ResourceReference destination) throws RepositoryException {
        SimpleDocument targetDoc = new SimpleDocument();
        SimpleDocumentPK pk = new SimpleDocumentPK(null, destination.getComponentInstanceId());
        pk.setOldSilverpeasId(document.getOldSilverpeasId());
        targetDoc.setPK(pk);
        targetDoc.setDocumentType(document.getDocumentType());
        targetDoc.setNodeName(document.getNodeName());
        this.prepareComponentAttachments(session, destination.getComponentInstanceId(), document.getFolder());
        session.save();
        Node originDocumentNode = session.getNodeByIdentifier(document.getPk().getId());
        if (!originDocumentNode.getPath().equals(targetDoc.getFullJcrPath())) {
            session.getWorkspace().move(originDocumentNode.getPath(), targetDoc.getFullJcrPath());
        }
        VersionManager versionManager = session.getWorkspace().getVersionManager();
        Node targetDocumentNode = session.getNode(targetDoc.getFullJcrPath());
        boolean mustCheckInVersion = true;
        if (this.converter.isVersionedMaster(targetDocumentNode)) {
            if (!targetDocumentNode.isCheckedOut()) {
                versionManager.checkout(targetDocumentNode.getPath());
            } else {
                mustCheckInVersion = false;
            }
        }
        this.converter.addStringProperty(targetDocumentNode, "slv:foreignKey", destination.getLocalId());
        this.converter.addStringProperty(targetDocumentNode, "slv:instanceId", destination.getComponentInstanceId());
        if (this.converter.isVersionedMaster(targetDocumentNode) && targetDocumentNode.isCheckedOut()) {
            session.save();
            if (mustCheckInVersion) {
                versionManager.checkin(targetDocumentNode.getPath());
            }
        }
        pk.setId(targetDocumentNode.getIdentifier());
        return pk;
    }

    public SimpleDocumentPK copyDocument(Session session, SimpleDocument document, ResourceReference destination) throws RepositoryException {
        this.prepareComponentAttachments(destination.getComponentInstanceId(), document.getFolder());
        SimpleDocumentPK pk = new SimpleDocumentPK(null, destination.getComponentInstanceId());
        SimpleDocument targetDoc = document.isVersioned() && document.getDocumentType() == DocumentType.attachment ? new HistorisedDocument() : new SimpleDocument();
        targetDoc.setNodeName(null);
        targetDoc.setPK(pk);
        targetDoc.setDocumentType(document.getDocumentType());
        targetDoc.setForeignId(destination.getLocalId());
        targetDoc.computeNodeName();
        Node originDocumentNode = session.getNodeByIdentifier(document.getPk().getId());
        session.getWorkspace().copy(originDocumentNode.getPath(), targetDoc.getFullJcrPath());
        Node copy = session.getNode(targetDoc.getFullJcrPath());
        copy.setProperty("slv:oldSilverpeasId", targetDoc.getOldSilverpeasId());
        copy.setProperty("slv:foreignKey", destination.getLocalId());
        copy.setProperty("slv:instanceId", destination.getComponentInstanceId());
        targetDoc = this.converter.fillDocument(copy, null);
        targetDoc.release();
        this.converter.fillNode(targetDoc, copy);
        return targetDoc.getPk();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleDocumentPK copyDocument(Session session, HistorisedDocument document, ResourceReference destination) throws RepositoryException {
        try {
            this.prepareComponentAttachments(destination.getComponentInstanceId(), document.getFolder());
            ArrayList<SimpleDocumentVersion> history = new ArrayList<SimpleDocumentVersion>(document.getHistory());
            Collections.reverse(history);
            history.add((SimpleDocumentVersion)((Object)document));
            SimpleDocumentPK pk = new SimpleDocumentPK(null, destination.getComponentInstanceId());
            HistorisedDocument targetDoc = new HistorisedDocument((SimpleDocument)history.remove(0));
            FirstVersionManager.computeIfAbsent(new DocumentVersion(targetDoc));
            targetDoc.setNodeName(null);
            targetDoc.setPK(pk);
            targetDoc.setDocumentType(document.getDocumentType());
            targetDoc.setForeignId(destination.getLocalId());
            targetDoc.setUpdatedBy(null);
            targetDoc.computeNodeName();
            pk = this.createDocument(session, targetDoc);
            if (I18NHelper.isI18nContentEnabled()) {
                this.addAttachmentInSupportedLanguages(session, document, targetDoc);
            }
            this.checkin(session, targetDoc, false);
            VersionManager versionManager = session.getWorkspace().getVersionManager();
            String previousVersion = targetDoc.getVersion();
            for (SimpleDocument simpleDocument : history) {
                SimpleDocument docToConsider = this.searchDocumentWithUpdatedContent(session, simpleDocument);
                HistorisedDocument targetHistorizedDoc = new HistorisedDocument(docToConsider);
                targetHistorizedDoc.setPK(pk);
                targetHistorizedDoc.setForeignId(destination.getLocalId());
                targetHistorizedDoc.setNodeName(targetDoc.getNodeName());
                targetHistorizedDoc.release();
                Node masterDocumentNode = session.getNodeByIdentifier(pk.getId());
                if (!previousVersion.equals(docToConsider.getVersion())) {
                    this.checkout(session, targetDoc, docToConsider.getUpdatedBy());
                    this.converter.fillNode(targetHistorizedDoc, masterDocumentNode);
                    this.checkin(session, targetHistorizedDoc, false);
                    previousVersion = targetHistorizedDoc.getVersion();
                    continue;
                }
                versionManager.checkout(masterDocumentNode.getPath());
                this.converter.fillNode(targetHistorizedDoc, masterDocumentNode);
                session.save();
                versionManager.checkin(masterDocumentNode.getPath());
            }
            Object object = pk;
            return object;
        }
        finally {
            FirstVersionManager.clear();
        }
    }

    private SimpleDocument searchDocumentWithUpdatedContent(Session session, SimpleDocument doc) throws RepositoryException {
        SimpleDocument updated = doc;
        if (I18NHelper.isI18nContentEnabled()) {
            HashSet<String> checkedLanguages = new HashSet<String>();
            checkedLanguages.add(doc.getLanguage());
            for (String language : I18NHelper.getAllSupportedLanguages()) {
                if (checkedLanguages.contains(language)) continue;
                SimpleDocument temp = this.findDocumentById(session, doc.getPk(), language);
                if (temp != null && !checkedLanguages.contains(temp.getLanguage()) && temp.getLastUpdateDate().after(doc.getLastUpdateDate())) {
                    updated = temp;
                }
                checkedLanguages.add(language);
            }
        }
        return updated;
    }

    private void addAttachmentInSupportedLanguages(Session session, HistorisedDocument document, SimpleDocument targetDoc) throws RepositoryException {
        HashSet<String> checkedLanguages = new HashSet<String>();
        checkedLanguages.add(targetDoc.getLanguage());
        for (String language : I18NHelper.getAllSupportedLanguages()) {
            SimpleDocumentVersion firstVersion;
            if (checkedLanguages.contains(language)) continue;
            HistorisedDocument temp = (HistorisedDocument)this.findDocumentById(session, document.getPk(), language);
            List<SimpleDocumentVersion> versions = temp.getHistory();
            if (!versions.isEmpty() && !checkedLanguages.contains((firstVersion = versions.get(versions.size() - 1)).getLanguage())) {
                this.addContent(session, targetDoc.getPk(), firstVersion.getAttachment());
            }
            checkedLanguages.add(language);
        }
    }

    public void updateDocument(Session session, SimpleDocument document, boolean updateLastModifiedData) throws RepositoryException {
        Node documentNode = session.getNodeByIdentifier(document.getPk().getId());
        if (updateLastModifiedData) {
            if (StringUtil.isDefined((String)document.getEditedBy())) {
                document.setUpdatedBy(document.getEditedBy());
            }
            document.setLastUpdateDate(new Date());
        }
        this.converter.fillNode(document, documentNode);
    }

    public void saveForbiddenDownloadForRoles(Session session, SimpleDocument document) throws RepositoryException {
        this.acceptOnMasterVersionWithoutChangingFunctionalVersion(session, document, d -> this.converter.setForbiddenDownloadForRolesOptionalNodeProperty(document, (Node)d));
    }

    public void saveDisplayableAsContent(Session session, SimpleDocument document) throws RepositoryException {
        this.acceptOnMasterVersionWithoutChangingFunctionalVersion(session, document, d -> this.converter.setDisplayableAsContentOptionalNodeProperty(document, (Node)d));
    }

    public void saveEditableSimultaneously(Session session, SimpleDocument document) throws RepositoryException {
        this.acceptOnMasterVersionWithoutChangingFunctionalVersion(session, document, d -> this.converter.setEditableSimultaneouslyOptionalNodeProperty(document, (Node)d));
    }

    public void setClone(Session session, SimpleDocument original, SimpleDocument clone) throws RepositoryException {
        this.acceptWithoutChangingFunctionalVersion(session, clone, d -> d.setProperty("slv:clone", original.getId()));
    }

    public void setOrder(Session session, SimpleDocument document) throws RepositoryException {
        this.acceptWithoutChangingFunctionalVersion(session, document, d -> d.setProperty("slv:order", (long)document.getOrder()));
    }

    private void acceptOnMasterVersionWithoutChangingFunctionalVersion(Session session, SimpleDocument document, RepositoryConsumer<Node> consumer) throws RepositoryException {
        this.acceptWithoutChangingFunctionalVersion(session, document.getVersionMaster(), consumer);
    }

    private void acceptWithoutChangingFunctionalVersion(Session session, SimpleDocument document, RepositoryConsumer<Node> consumer) throws RepositoryException {
        boolean checkedIn;
        Node documentNode = session.getNodeByIdentifier(document.getPk().getId());
        boolean bl = checkedIn = !documentNode.isCheckedOut();
        if (checkedIn) {
            session.getWorkspace().getVersionManager().checkout(documentNode.getPath());
        }
        consumer.accept(documentNode);
        if (checkedIn) {
            session.save();
            session.getWorkspace().getVersionManager().checkin(documentNode.getPath());
        }
    }

    public void deleteDocument(Session session, SimpleDocumentPK documentPk) throws RepositoryException {
        try {
            Node documentNode = session.getNodeByIdentifier(documentPk.getId());
            String documentNodeName = documentNode.getName();
            this.deleteDocumentNode(documentNode);
            this.deleteContent(documentPk.getInstanceId(), documentNodeName);
        }
        catch (ItemNotFoundException e) {
            SilverLogger.getLogger((Object)this).silent((Throwable)e);
        }
    }

    public SimpleDocumentPK changeVersionState(Session session, SimpleDocumentPK documentPk, String comment) throws RepositoryException, IOException {
        try {
            Node documentNode = session.getNodeByIdentifier(documentPk.getId());
            boolean versionedNode = documentNode.getParent() instanceof Version || this.converter.isVersionedMaster(documentNode);
            Node parent = documentNode.getParent();
            if (parent instanceof Version) {
                Version selectedVersion = (Version)parent;
                VersionManager versionManager = documentNode.getSession().getWorkspace().getVersionManager();
                versionManager.restore(selectedVersion, true);
                documentNode = session.getNodeByIdentifier(selectedVersion.getContainingHistory().getVersionableIdentifier());
            }
            if (!documentNode.isCheckedOut()) {
                this.checkoutNode(documentNode, null);
            }
            if (StringUtil.isDefined((String)comment)) {
                documentNode.setProperty("slv:comment", comment);
            }
            SimpleDocument origin = this.converter.fillDocument(documentNode, I18NHelper.DEFAULT_LANGUAGE);
            if (versionedNode) {
                File[] safeContents;
                VersionHistory history = session.getWorkspace().getVersionManager().getVersionHistory(documentNode.getPath());
                documentNode.removeMixin("{http://www.jcp.org/jcr/mix/1.0}versionable");
                documentNode.setProperty("slv:versioned", false);
                documentNode.setProperty("slv:major", 0L);
                documentNode.setProperty("slv:minor", 0L);
                session.save();
                this.removeHistory(history);
                SimpleDocument target = this.converter.fillDocument(documentNode, I18NHelper.DEFAULT_LANGUAGE);
                this.moveMultilangContent(origin, target);
                File currentDocumentDir = new File(target.getDirectoryPath(I18NHelper.DEFAULT_LANGUAGE)).getParentFile();
                Optional<File[]> files = Optional.ofNullable(currentDocumentDir.getParentFile().listFiles());
                for (File versionDirectory : safeContents = files.orElseGet(() -> {
                    SilverLogger.getLogger((Object)this).warn("During version state removing, attempting to delete {0} which does not exist whereas JCR is having a reference on it", new Object[]{currentDocumentDir.getParentFile().toString()});
                    return new File[0];
                })) {
                    if (versionDirectory.equals(currentDocumentDir)) continue;
                    FileUtils.deleteDirectory((File)versionDirectory);
                }
            } else {
                documentNode.setProperty("slv:versioned", true);
                documentNode.setProperty("slv:major", 1L);
                documentNode.setProperty("slv:minor", 0L);
                documentNode.addMixin("{http://www.jcp.org/jcr/mix/1.0}versionable");
                SimpleDocument target = this.converter.fillDocument(documentNode, I18NHelper.DEFAULT_LANGUAGE);
                VersionManager versionManager = documentNode.getSession().getWorkspace().getVersionManager();
                session.save();
                versionManager.checkin(documentNode.getPath());
                this.moveMultilangContent(origin, target);
            }
            return new SimpleDocumentPK(documentNode.getIdentifier(), (WAPrimaryKey)documentPk);
        }
        catch (ItemNotFoundException e) {
            return documentPk;
        }
    }

    private void deleteDocumentNode(Node documentNode) throws RepositoryException {
        if (null != documentNode) {
            Session session = documentNode.getSession();
            VersionHistory history = this.converter.isVersionedMaster(documentNode) ? documentNode.getSession().getWorkspace().getVersionManager().getVersionHistory(documentNode.getPath()) : null;
            documentNode.remove();
            session.save();
            if (history != null) {
                this.removeHistory(history);
            }
        }
    }

    public SimpleDocument findDocumentById(Session session, SimpleDocumentPK documentPk, String lang) throws RepositoryException {
        SimpleDocument document = null;
        try {
            Node documentNode = session.getNodeByIdentifier(documentPk.getId());
            document = this.converter.convertNode(documentNode, lang);
        }
        catch (ItemNotFoundException e) {
            SilverLogger.getLogger((Object)this).silent((Throwable)e);
        }
        return document;
    }

    public SimpleDocument findDocumentByOldSilverpeasId(Session session, String instanceId, long oldSilverpeasId, boolean versioned, String lang) throws RepositoryException {
        Comparison versionedComparison;
        Comparison oldSilverpeasIdComparison;
        DescendantNode descendantNodeConstraint;
        Selector source;
        QueryManager manager = session.getWorkspace().getQueryManager();
        QueryObjectModelFactory factory = manager.getQOMFactory();
        QueryObjectModel query = factory.createQuery((Source)(source = factory.selector("slv:simpleDocument", SIMPLE_DOCUMENT_ALIAS)), (Constraint)factory.and((Constraint)(descendantNodeConstraint = factory.descendantNode(SIMPLE_DOCUMENT_ALIAS, session.getRootNode().getPath() + instanceId)), (Constraint)factory.and((Constraint)(oldSilverpeasIdComparison = DocumentRepository.getComparison(factory, "slv:oldSilverpeasId", "jcr.operator.equal.to", session.getValueFactory().createValue(oldSilverpeasId))), (Constraint)(versionedComparison = DocumentRepository.getComparison(factory, "slv:versioned", "jcr.operator.equal.to", session.getValueFactory().createValue(versioned))))), null, null);
        QueryResult result = query.execute();
        NodeIterator iter = result.getNodes();
        if (iter.hasNext()) {
            return this.converter.convertNode(iter.nextNode(), lang);
        }
        return null;
    }

    SimpleDocument findLast(Session session, String instanceId, String foreignId, DocumentType documentType) throws RepositoryException {
        NodeIterator iter = this.selectDocumentsByForeignIdAndType(session, instanceId, foreignId, documentType);
        while (iter.hasNext()) {
            Node node = iter.nextNode();
            if (iter.hasNext()) continue;
            return this.converter.convertNode(node, I18NHelper.DEFAULT_LANGUAGE);
        }
        return null;
    }

    Optional<Pair<Integer, Integer>> getMinMaxOrderIndexes(Session session, String instanceId, String foreignId, DocumentType documentType) throws RepositoryException {
        NodeIterator iter = this.selectDocumentsByForeignIdAndType(session, instanceId, foreignId, documentType);
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        while (iter.hasNext()) {
            Node node = iter.nextNode();
            if (!node.hasProperty("slv:order")) continue;
            int currentOrder = (int)node.getProperty("slv:order").getLong();
            min = Math.min(min, currentOrder);
            max = Math.max(max, currentOrder);
        }
        return min == Integer.MAX_VALUE ? Optional.empty() : Optional.of(Pair.of((Object)min, (Object)max));
    }

    public SimpleDocumentList<SimpleDocument> listDocumentsByForeignId(Session session, String instanceId, String foreignId, String language) throws RepositoryException {
        NodeIterator iter = this.selectDocumentsByForeignIdAndType(session, instanceId, foreignId, DocumentType.attachment);
        return this.converter.convertNodeIterator(iter, language);
    }

    public SimpleDocumentList<SimpleDocument> listAllDocumentsByForeignId(Session session, String instanceId, String foreignId, String language) throws RepositoryException {
        NodeIterator iter = this.selectDocumentsByForeignId(session, instanceId, foreignId);
        return this.converter.convertNodeIterator(iter, language);
    }

    public SimpleDocumentList<SimpleDocument> listDocumentsByForeignIdAndType(Session session, String instanceId, String foreignId, DocumentType type, String language) throws RepositoryException {
        NodeIterator iter = this.selectDocumentsByForeignIdAndType(session, instanceId, foreignId, type);
        return this.converter.convertNodeIterator(iter, language);
    }

    public List<SimpleDocument> listDocumentsByComponentIdAndType(Session session, String instanceId, DocumentType type, String language) throws RepositoryException {
        NodeIterator iter = this.selectDocumentsByComponentIdAndType(session, instanceId, type);
        return this.converter.convertNodeIterator(iter, language);
    }

    public List<SimpleDocument> listAllDocumentsByComponentId(Session session, String instanceId, String language) throws RepositoryException {
        NodeIterator iter = this.selectAllDocumentsByComponentId(session, instanceId);
        return this.converter.convertNodeIterator(iter, language);
    }

    public List<SimpleDocument> listComponentDocumentsByOwner(Session session, String instanceId, String owner, String language) throws RepositoryException {
        NodeIterator iter = this.selectDocumentsByOwnerIdAndComponentId(session, instanceId, owner);
        return this.converter.convertNodeIterator(iter, language);
    }

    public List<SimpleDocument> listDocumentsLockedByUser(Session session, String usedId, String language) throws RepositoryException {
        NodeIterator iter = this.selectAllDocumentsByOwnerId(session, usedId);
        return this.converter.convertNodeIterator(iter, language);
    }

    NodeIterator selectDocumentsByForeignIdAndType(Session session, String instanceId, String foreignId, DocumentType type) throws RepositoryException {
        QueryManager manager = session.getWorkspace().getQueryManager();
        QueryObjectModelFactory factory = manager.getQOMFactory();
        Selector source = factory.selector("slv:simpleDocument", SIMPLE_DOCUMENT_ALIAS);
        ChildNode childNodeConstraint = factory.childNode(SIMPLE_DOCUMENT_ALIAS, session.getRootNode().getPath() + instanceId + "/" + type.getFolderName());
        return this.getNodeIteratorByProperty(factory, source, (Constraint)childNodeConstraint, "slv:foreignKey", session.getValueFactory().createValue(foreignId));
    }

    private static Comparison getComparison(QueryObjectModelFactory factory, String slvProperty, String jcrOperatorEqualTo, Value session) throws RepositoryException {
        return factory.comparison((DynamicOperand)factory.propertyValue(SIMPLE_DOCUMENT_ALIAS, slvProperty), jcrOperatorEqualTo, (StaticOperand)factory.literal(session));
    }

    NodeIterator selectDocumentsByForeignId(Session session, String instanceId, String foreignId) throws RepositoryException {
        QueryManager manager = session.getWorkspace().getQueryManager();
        QueryObjectModelFactory factory = manager.getQOMFactory();
        Selector source = factory.selector("slv:simpleDocument", SIMPLE_DOCUMENT_ALIAS);
        DescendantNode descendantNodeConstraint = factory.descendantNode(SIMPLE_DOCUMENT_ALIAS, session.getRootNode().getPath() + instanceId + "/");
        return this.getNodeIteratorByProperty(factory, source, (Constraint)descendantNodeConstraint, "slv:foreignKey", session.getValueFactory().createValue(foreignId));
    }

    NodeIterator selectDocumentsByComponentIdAndType(Session session, String instanceId, DocumentType type) throws RepositoryException {
        QueryManager manager = session.getWorkspace().getQueryManager();
        QueryObjectModelFactory factory = manager.getQOMFactory();
        Selector source = factory.selector("slv:simpleDocument", SIMPLE_DOCUMENT_ALIAS);
        ChildNode childNodeConstraint = factory.childNode(SIMPLE_DOCUMENT_ALIAS, session.getRootNode().getPath() + instanceId + "/" + type.getFolderName());
        Ordering order = factory.ascending((DynamicOperand)factory.propertyValue(SIMPLE_DOCUMENT_ALIAS, "slv:order"));
        QueryObjectModel query = factory.createQuery((Source)source, (Constraint)childNodeConstraint, new Ordering[]{order}, null);
        QueryResult result = query.execute();
        return result.getNodes();
    }

    NodeIterator selectAllDocumentsByComponentId(Session session, String instanceId) throws RepositoryException {
        QueryManager manager = session.getWorkspace().getQueryManager();
        QueryObjectModelFactory factory = manager.getQOMFactory();
        Selector source = factory.selector("slv:simpleDocument", SIMPLE_DOCUMENT_ALIAS);
        DescendantNode childNodeConstraint = factory.descendantNode(SIMPLE_DOCUMENT_ALIAS, session.getRootNode().getPath() + instanceId);
        Ordering order = factory.ascending((DynamicOperand)factory.propertyValue(SIMPLE_DOCUMENT_ALIAS, "slv:order"));
        QueryObjectModel query = factory.createQuery((Source)source, (Constraint)childNodeConstraint, new Ordering[]{order}, null);
        QueryResult result = query.execute();
        return result.getNodes();
    }

    public List<SimpleDocument> listExpiringDocuments(Session session, Date expiryDate, String language) throws RepositoryException {
        NodeIterator iter = this.selectExpiringDocuments(session, DateUtil.getBeginOfDay((Date)expiryDate));
        return this.converter.convertNodeIterator(iter, language);
    }

    public List<SimpleDocument> listDocumentsRequiringWarning(Session session, Date alertDate, String language) throws RepositoryException {
        NodeIterator iter = this.selectWarningDocuments(session, DateUtil.getBeginOfDay((Date)alertDate));
        return this.converter.convertNodeIterator(iter, language);
    }

    NodeIterator selectExpiringDocuments(Session session, Date expiryDate) throws RepositoryException {
        return this.getNodeIteratorByDateProperty(session, "slv:expiryDate", expiryDate);
    }

    private NodeIterator getNodeIteratorByDateProperty(Session session, String slvPropertyDate, Date date) throws RepositoryException {
        QueryManager manager = session.getWorkspace().getQueryManager();
        QueryObjectModelFactory factory = manager.getQOMFactory();
        Calendar calendarDate = Calendar.getInstance();
        calendarDate.setTime(DateUtil.getBeginOfDay((Date)date));
        Selector source = factory.selector("slv:simpleDocument", SIMPLE_DOCUMENT_ALIAS);
        return this.getNodeIteratorByProperty(factory, source, slvPropertyDate, session.getValueFactory().createValue(calendarDate));
    }

    private NodeIterator getNodeIteratorByProperty(QueryObjectModelFactory factory, Selector source, Constraint anotherConstraint, String slvProperty, Value value) throws RepositoryException {
        Comparison comparison = DocumentRepository.getComparison(factory, slvProperty, "jcr.operator.equal.to", value);
        Ordering order = factory.ascending((DynamicOperand)factory.propertyValue(SIMPLE_DOCUMENT_ALIAS, "slv:order"));
        Comparison constraint = anotherConstraint == null ? comparison : factory.and(anotherConstraint, (Constraint)comparison);
        QueryObjectModel query = factory.createQuery((Source)source, (Constraint)constraint, new Ordering[]{order}, null);
        QueryResult result = query.execute();
        return result.getNodes();
    }

    private NodeIterator getNodeIteratorByProperty(QueryObjectModelFactory factory, Selector source, String slvProperty, Value value) throws RepositoryException {
        return this.getNodeIteratorByProperty(factory, source, null, slvProperty, value);
    }

    public List<SimpleDocument> listDocumentsToUnlock(Session session, Date expiryDate, String language) throws RepositoryException {
        NodeIterator iter = this.selectDocumentsRequiringUnlocking(session, expiryDate);
        return this.converter.convertNodeIterator(iter, language);
    }

    NodeIterator selectDocumentsRequiringUnlocking(Session session, Date expiryDate) throws RepositoryException {
        QueryManager manager = session.getWorkspace().getQueryManager();
        QueryObjectModelFactory factory = manager.getQOMFactory();
        Calendar expiry = Calendar.getInstance();
        expiry.setTime(DateUtil.getBeginOfDay((Date)expiryDate));
        Selector source = factory.selector("slv:simpleDocument", SIMPLE_DOCUMENT_ALIAS);
        Comparison expiryDateComparison = DocumentRepository.getComparison(factory, "slv:expiryDate", "jcr.operator.less.than", session.getValueFactory().createValue(expiry));
        Ordering order = factory.ascending((DynamicOperand)factory.propertyValue(SIMPLE_DOCUMENT_ALIAS, "slv:order"));
        QueryObjectModel query = factory.createQuery((Source)source, (Constraint)expiryDateComparison, new Ordering[]{order}, null);
        QueryResult result = query.execute();
        return result.getNodes();
    }

    NodeIterator selectWarningDocuments(Session session, Date alertDate) throws RepositoryException {
        return this.getNodeIteratorByDateProperty(session, "slv:alertDate", alertDate);
    }

    NodeIterator selectDocumentsByOwnerIdAndComponentId(Session session, String instanceId, String owner) throws RepositoryException {
        QueryManager manager = session.getWorkspace().getQueryManager();
        QueryObjectModelFactory factory = manager.getQOMFactory();
        Selector source = factory.selector("slv:simpleDocument", SIMPLE_DOCUMENT_ALIAS);
        ChildNode childNodeConstraint = factory.childNode(SIMPLE_DOCUMENT_ALIAS, session.getRootNode().getPath() + instanceId + "/" + DocumentType.attachment.getFolderName());
        return this.getNodeIteratorByProperty(factory, source, (Constraint)childNodeConstraint, "slv:owner", session.getValueFactory().createValue(owner));
    }

    NodeIterator selectAllDocumentsByOwnerId(Session session, String owner) throws RepositoryException {
        QueryManager manager = session.getWorkspace().getQueryManager();
        QueryObjectModelFactory factory = manager.getQOMFactory();
        Selector source = factory.selector("slv:simpleDocument", SIMPLE_DOCUMENT_ALIAS);
        return this.getNodeIteratorByProperty(factory, source, "slv:owner", session.getValueFactory().createValue(owner));
    }

    public void addContent(Session session, SimpleDocumentPK documentPk, SimpleAttachment attachment) throws RepositoryException {
        Node documentNode = session.getNodeByIdentifier(documentPk.getId());
        if (this.converter.isVersionedMaster(documentNode) && !documentNode.isCheckedOut()) {
            String owner = attachment.getUpdatedBy();
            if (!StringUtil.isDefined((String)owner)) {
                owner = attachment.getCreatedBy();
            }
            this.checkoutNode(documentNode, owner);
        }
        this.converter.addAttachment(documentNode, attachment);
    }

    public InputStream getContent(Session session, SimpleDocumentPK pk, String lang) throws RepositoryException, IOException {
        Node docNode = session.getNodeByIdentifier(pk.getId());
        String language = lang;
        if (!StringUtil.isDefined((String)language)) {
            language = I18NHelper.DEFAULT_LANGUAGE;
        }
        SimpleDocument document = this.converter.fillDocument(docNode, language);
        return new BufferedInputStream(FileUtils.openInputStream((File)new File(document.getAttachmentPath())));
    }

    public boolean removeContent(Session session, SimpleDocumentPK documentPk, String language) throws RepositoryException {
        Node documentNode = session.getNodeByIdentifier(documentPk.getId());
        if (this.converter.isVersionedMaster(documentNode) && !documentNode.isCheckedOut()) {
            this.checkoutNode(documentNode, null);
        }
        this.converter.removeAttachment(documentNode, language);
        documentNode = session.getNodeByIdentifier(documentPk.getId());
        boolean existsOtherContents = documentNode.hasNodes();
        if (!existsOtherContents) {
            this.deleteDocumentNode(documentNode);
        }
        return existsOtherContents;
    }

    public boolean checkout(Session session, SimpleDocument document, String owner) throws RepositoryException {
        if (document.isVersioned()) {
            Node documentNode = session.getNodeByIdentifier(document.getId());
            if (!documentNode.isCheckedOut()) {
                this.checkoutNode(documentNode, owner);
            }
            return true;
        }
        return false;
    }

    public SimpleDocument checkin(Session session, SimpleDocument document, boolean restore) throws RepositoryException {
        return this.checkin(session, document, restore, false);
    }

    public SimpleDocument checkinFromContentDeletion(Session session, SimpleDocument document) throws RepositoryException {
        return this.checkin(session, document, false, true);
    }

    private SimpleDocument checkin(Session session, SimpleDocument document, boolean restore, boolean skipContentMetadataUpdate) throws RepositoryException {
        Node documentNode;
        try {
            documentNode = session.getNodeByIdentifier(document.getId());
        }
        catch (ItemNotFoundException ex) {
            return document;
        }
        if (document.isVersioned() && documentNode.isCheckedOut()) {
            if (restore) {
                VersionIterator iter = session.getWorkspace().getVersionManager().getVersionHistory(document.getFullJcrPath()).getAllVersions();
                Version lastVersion = null;
                while (iter.hasNext()) {
                    lastVersion = iter.nextVersion();
                }
                if (null != lastVersion) {
                    session.getWorkspace().getVersionManager().restore(lastVersion, true);
                    return this.converter.convertNode(lastVersion.getFrozenNode(), document.getLanguage());
                }
            }
            this.converter.fillNode(document, documentNode, restore || skipContentMetadataUpdate);
            return this.checkinNode(documentNode, document.getLanguage(), document.isPublic());
        }
        if (!document.isVersioned()) {
            this.converter.fillNode(document, documentNode, restore || skipContentMetadataUpdate);
            this.converter.releaseDocumentNode(documentNode, document.getLanguage());
            return this.converter.convertNode(documentNode, document.getLanguage());
        }
        document.release();
        return document;
    }

    void checkoutNode(Node node, String owner) throws RepositoryException {
        node.getSession().getWorkspace().getVersionManager().checkout(node.getPath());
        this.converter.addStringProperty(node, "slv:owner", owner);
    }

    SimpleDocument checkinNode(Node documentNode, String lang, boolean isMajor) throws RepositoryException {
        DocumentVersion firstVersion = FirstVersionManager.remove();
        if (!documentNode.hasProperty("slv:major") && firstVersion != null) {
            isMajor = firstVersion.isMajor();
            int major = firstVersion.getMajor();
            int minor = firstVersion.getMinor();
            documentNode.setProperty("slv:major", isMajor ? (long)(major - 1) : (long)major);
            documentNode.setProperty("slv:minor", isMajor ? (long)minor : (long)(minor - 1));
        }
        VersionManager versionManager = documentNode.getSession().getWorkspace().getVersionManager();
        String versionLabel = this.converter.updateVersion(documentNode, lang, isMajor);
        documentNode.getSession().save();
        Version lastVersion = versionManager.checkin(documentNode.getPath());
        lastVersion.getContainingHistory().addVersionLabel(lastVersion.getName(), versionLabel, false);
        return this.converter.convertNode(documentNode, lang);
    }

    void removeHistory(VersionHistory history) throws RepositoryException {
        Version root = history.getRootVersion();
        VersionIterator versions = history.getAllVersions();
        while (versions.hasNext()) {
            Version version = versions.nextVersion();
            if (version.isSame((Item)root)) continue;
            history.removeVersion(version.getName());
        }
    }

    public void fillNodeName(Session session, SimpleDocument document) throws RepositoryException {
        Node documentNode = session.getNodeByIdentifier(document.getId());
        if (!StringUtil.isDefined((String)document.getNodeName())) {
            document.setNodeName(documentNode.getName());
        }
    }

    public long storeContent(SimpleDocument document, InputStream in, boolean update) throws IOException {
        File file = new File(document.getAttachmentPath());
        if (update) {
            File parentFile = file.getParentFile();
            String[] children = parentFile.list();
            if (parentFile.isDirectory() && children != null && children.length > 0) {
                FileUtils.deleteQuietly((File)parentFile);
                FileUtils.forceMkdir((File)parentFile);
            }
        }
        FileUtils.copyInputStreamToFile((InputStream)in, (File)file);
        if (document.isContentImage()) {
            ImageTool.get().convert(file, null, OrientationOption.auto().modifyImageOnlyIfNecessary(), new ImageToolDirective[0]);
        }
        return file.length();
    }

    public long storeContent(SimpleDocument document, InputStream in) throws IOException {
        return this.storeContent(document, in, false);
    }

    public void duplicateContent(SimpleDocument origin, SimpleDocument document) throws IOException {
        String originDir = origin.getDirectoryPath(null);
        String targetDir = document.getDirectoryPath(null);
        targetDir = targetDir.replace('/', File.separatorChar);
        File target = new File(targetDir).getParentFile();
        File source = new File(originDir).getParentFile();
        File[] children = source.listFiles();
        if (!source.exists() || !source.isDirectory() || children == null) {
            return;
        }
        if (!target.exists()) {
            Files.createDirectories(target.toPath(), new FileAttribute[0]);
        }
        for (File langDir : children) {
            File targetLangDir = new File(target, langDir.getName());
            if (targetLangDir.exists()) continue;
            FileUtils.copyDirectory((File)langDir, (File)targetLangDir);
        }
    }

    public void deleteContent(String instanceId, String nodeName) {
        Object directory = FileRepositoryManager.getAbsolutePath(instanceId) + nodeName;
        File documentDirectory = new File((String)(directory = ((String)directory).replace('/', File.separatorChar)));
        if (documentDirectory.exists() && documentDirectory.isDirectory()) {
            FileUtils.deleteQuietly((File)documentDirectory);
        }
    }

    public void copyMultilangContent(SimpleDocument origin, SimpleDocument copy) throws IOException {
        String originDir = origin.getDirectoryPath(null);
        String targetDir = copy.getDirectoryPath(null);
        targetDir = targetDir.replace('/', File.separatorChar);
        File target = new File(targetDir).getParentFile();
        File source = new File(originDir).getParentFile();
        if (!source.exists() || !source.isDirectory() || source.listFiles() == null) {
            return;
        }
        if (target.exists()) {
            FileUtils.cleanDirectory((File)target);
        }
        FileUtils.copyDirectory((File)source, (File)target);
    }

    public void copyFullContent(SimpleDocument origin, SimpleDocument copy) throws IOException {
        String originDir = origin.getDirectoryPath(null);
        String targetDir = copy.getDirectoryPath(null);
        targetDir = targetDir.replace('/', File.separatorChar);
        File target = new File(targetDir).getParentFile().getParentFile();
        File source = new File(originDir).getParentFile().getParentFile();
        if (!source.exists() || !source.isDirectory() || source.listFiles() == null) {
            return;
        }
        if (target.exists()) {
            FileUtils.cleanDirectory((File)target);
        }
        FileUtils.copyDirectory((File)source, (File)target);
    }

    public void moveMultilangContent(SimpleDocument origin, SimpleDocument copy) throws IOException {
        String originDir = origin.getDirectoryPath(null);
        File source = new File(originDir).getParentFile();
        String targetDir = copy.getDirectoryPath(null);
        targetDir = targetDir.replace('/', File.separatorChar);
        File target = new File(targetDir).getParentFile();
        if (!source.exists() || !source.isDirectory() || source.listFiles() == null) {
            return;
        }
        if (!target.getParentFile().getName().equals(source.getParentFile().getName())) {
            source = source.getParentFile();
            target = target.getParentFile();
        }
        if (!source.equals(target)) {
            FileUtils.moveDirectory((File)source, (File)target);
            FileUtil.deleteEmptyDir(source.getParentFile());
        }
    }

    public void moveFullContent(SimpleDocument origin, SimpleDocument copy) throws IOException {
        String originDir = origin.getDirectoryPath(null);
        File source = new File(originDir).getParentFile().getParentFile();
        String targetDir = copy.getDirectoryPath(null);
        targetDir = targetDir.replace('/', File.separatorChar);
        File target = new File(targetDir).getParentFile().getParentFile();
        if (!source.exists() || !source.isDirectory() || source.listFiles() == null) {
            return;
        }
        if (!source.equals(target)) {
            FileUtils.moveDirectory((File)source, (File)target);
            FileUtil.deleteEmptyDir(source.getParentFile());
        }
    }

    public void mergeAttachment(Session session, SimpleDocument attachment, SimpleDocument clone) throws RepositoryException {
        Node originalNode = session.getNodeByIdentifier(attachment.getId());
        HashSet<String> existingAttachments = new HashSet<String>(I18NHelper.getNumberOfLanguages());
        for (Node child : new NodeIterable(originalNode.getNodes())) {
            existingAttachments.add(child.getName());
        }
        Node cloneNode = session.getNodeByIdentifier(clone.getId());
        for (Node child : new NodeIterable(cloneNode.getNodes())) {
            String childNodeName = child.getName();
            if (existingAttachments.contains(childNodeName) && originalNode.hasNode(childNodeName)) {
                this.copyNode(session, child, originalNode.getNode(childNodeName));
                existingAttachments.remove(childNodeName);
                continue;
            }
            session.move(child.getPath(), originalNode.getPath() + "/" + childNodeName);
        }
        for (String deletedNode : existingAttachments) {
            if (!originalNode.hasNode(deletedNode)) continue;
            originalNode.getNode(deletedNode).remove();
        }
        this.converter.addStringProperty(originalNode, "slv:clone", null);
    }

    private void copyNode(Session session, Node source, Node target) throws RepositoryException {
        for (Node child : new NodeIterable(target.getNodes())) {
            if (child.getDefinition().isProtected()) continue;
            child.remove();
        }
        for (Node child : new NodeIterable(source.getNodes())) {
            session.move(child.getPath(), target.getPath() + "/" + child.getName());
        }
        for (Property property : new PropertyIterable(target.getProperties())) {
            if (property.getDefinition().isProtected()) continue;
            property.remove();
        }
        for (Property property : new PropertyIterable(source.getProperties())) {
            if (property.getDefinition().isProtected()) continue;
            target.setProperty(property.getName(), property.getValue());
        }
    }

    @FunctionalInterface
    private static interface RepositoryConsumer<T> {
        public void accept(T var1) throws RepositoryException;
    }

    public static class FirstVersionManager {
        private static final String CACHE_KEY = DocumentVersion.class.getSimpleName() + "@theFirst";

        private FirstVersionManager() {
            throw new IllegalAccessError("Utility class");
        }

        public static DocumentVersion computeIfAbsent(DocumentVersion version) {
            return (DocumentVersion)FirstVersionManager.getThreadCache().computeIfAbsent((Object)CACHE_KEY, DocumentVersion.class, () -> version);
        }

        public static void set(DocumentVersion version) {
            FirstVersionManager.getThreadCache().put((Object)CACHE_KEY, (Object)version);
        }

        public static void clear() {
            FirstVersionManager.remove();
        }

        static DocumentVersion remove() {
            return (DocumentVersion)FirstVersionManager.getThreadCache().remove((Object)CACHE_KEY, DocumentVersion.class);
        }

        private static SimpleCache getThreadCache() {
            return CacheAccessorProvider.getThreadCacheAccessor().getCache();
        }
    }

    public static class DocumentVersion {
        private final int major;
        private final int minor;

        public DocumentVersion(int major, int minor) {
            this.major = major;
            this.minor = minor;
        }

        public DocumentVersion(SimpleDocument document) {
            this(document.getMajorVersion(), document.getMinorVersion());
        }

        boolean isMajor() {
            return this.minor == 0;
        }

        int getMajor() {
            return this.major;
        }

        int getMinor() {
            return this.minor;
        }
    }
}

