/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.attachment.repository;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import javax.jcr.version.VersionManager;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.contribution.attachment.model.DocumentType;
import org.silverpeas.core.contribution.attachment.model.HistorisedDocument;
import org.silverpeas.core.contribution.attachment.model.HistorisedDocumentVersion;
import org.silverpeas.core.contribution.attachment.model.SimpleAttachment;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.contribution.attachment.model.SimpleDocumentPK;
import org.silverpeas.core.contribution.attachment.model.SimpleDocumentVersion;
import org.silverpeas.core.contribution.attachment.repository.HistoryDocumentSorter;
import org.silverpeas.core.contribution.attachment.repository.SimpleAttachmentConverter;
import org.silverpeas.core.contribution.attachment.util.AttachmentSettings;
import org.silverpeas.core.contribution.attachment.util.SimpleDocumentList;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.persistence.jcr.AbstractJcrConverter;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.kernel.util.StringUtil;

class DocumentConverter
extends AbstractJcrConverter {
    private final SimpleAttachmentConverter attachmentConverter = new SimpleAttachmentConverter();

    DocumentConverter() {
    }

    HistorisedDocument buildHistorizedDocument(Node rootVersionNode, String lang) throws RepositoryException {
        VersionManager versionManager = rootVersionNode.getSession().getWorkspace().getVersionManager();
        HistorisedDocument historisedDocument = new HistorisedDocument(this.fillDocument(rootVersionNode, lang));
        try {
            String path = rootVersionNode.getPath();
            Version baseVersion = versionManager.getBaseVersion(path);
            String baseVersionId = baseVersion == null ? "" : baseVersion.getIdentifier();
            VersionHistory history = versionManager.getVersionHistory(path);
            VersionIterator versionsIterator = history.getAllLinearVersions();
            int capacity = versionsIterator.getSize() == -1L ? 10 : (int)versionsIterator.getSize();
            ArrayList<SimpleDocumentVersion> documentHistory = new ArrayList<SimpleDocumentVersion>(capacity);
            int versionIndex = 0;
            SimpleDocumentVersion previousVersion = null;
            if (versionsIterator.hasNext()) {
                versionsIterator.nextVersion();
            }
            while (versionsIterator.hasNext()) {
                Version version = versionsIterator.nextVersion();
                if (!baseVersionId.isEmpty() && baseVersionId.equals(version.getIdentifier())) continue;
                SimpleDocumentVersion versionDocument = new SimpleDocumentVersion(this.fillDocument(version.getFrozenNode(), lang), historisedDocument);
                versionDocument.setNodeName(rootVersionNode.getName());
                versionDocument.setVersionIndex(versionIndex++);
                versionDocument.setPreviousVersion(previousVersion);
                documentHistory.add(versionDocument);
                previousVersion = versionDocument;
            }
            HistoryDocumentSorter.sortHistory(documentHistory);
            historisedDocument.setHistory(documentHistory);
            historisedDocument.setVersionIndex(versionIndex);
        }
        catch (PathNotFoundException | UnsupportedRepositoryOperationException ex) {
            this.performBrokenHistory(historisedDocument);
        }
        return historisedDocument;
    }

    protected void performBrokenHistory(HistorisedDocument historisedDocument) {
        historisedDocument.setHistory(new ArrayList<SimpleDocumentVersion>(0));
    }

    public SimpleDocument convertNode(Node node, String lang) throws RepositoryException {
        if (this.isVersionedMaster(node)) {
            return this.buildHistorizedDocument(node, lang);
        }
        Node parentNode = node.getParent();
        if (parentNode instanceof Version) {
            Node masterNode = this.getMasterNodeForVersion((Version)parentNode);
            HistorisedDocument document = this.buildHistorizedDocument(masterNode, lang);
            SimpleDocumentVersion version = document.getVersionIdentifiedBy(node.getIdentifier());
            if (version != null) {
                return new HistorisedDocumentVersion(version);
            }
            throw new PathNotFoundException("Version identified by " + parentNode.getIdentifier() + " has not been found.");
        }
        return this.fillDocument(node, lang);
    }

    public Node getMasterNodeForVersion(Version version) throws RepositoryException {
        String uuid = version.getContainingHistory().getVersionableIdentifier();
        return version.getSession().getNodeByIdentifier(uuid);
    }

    public SimpleDocumentList<SimpleDocument> convertNodeIterator(NodeIterator iter, String language) throws RepositoryException {
        SimpleDocumentList<SimpleDocument> result = new SimpleDocumentList((int)iter.getSize()).setQueryLanguage(language);
        while (iter.hasNext()) {
            result.add(this.convertNode(iter.nextNode(), language));
        }
        return result;
    }

    SimpleDocument fillDocument(Node node, String lang) throws RepositoryException {
        Object nodeName;
        boolean isFrozenNode;
        SimpleAttachment file;
        SimpleDocumentPK pk = new SimpleDocumentPK(node.getIdentifier(), this.getStringProperty(node, "slv:instanceId"));
        long oldSilverpeasId = this.getLongProperty(node, "slv:oldSilverpeasId");
        pk.setOldSilverpeasId(oldSilverpeasId);
        String language = lang;
        if (language == null) {
            language = I18NHelper.DEFAULT_LANGUAGE;
        }
        if ((file = this.getAttachment(node, language)) == null) {
            Iterator<String> iter = I18NHelper.getLanguages().iterator();
            while (iter.hasNext() && file == null) {
                file = this.getAttachment(node, iter.next());
            }
        }
        boolean isVersioned = (isFrozenNode = "jcr:frozenNode".equals(nodeName = node.getName())) ? this.getBooleanProperty(node, "slv:versioned", false).booleanValue() : this.isVersionedMaster(node);
        SimpleDocument doc = new SimpleDocument(pk, this.getStringProperty(node, "slv:foreignKey"), this.getIntProperty(node, "slv:order"), isVersioned, this.getStringProperty(node, "slv:owner"), file);
        doc.setReservation(this.getDateProperty(node, "slv:reservationDate"));
        doc.setAlert(this.getDateProperty(node, "slv:alertDate"));
        doc.setExpiry(this.getDateProperty(node, "slv:expiryDate"));
        doc.setComment(this.getStringProperty(node, "slv:comment"));
        doc.setRepositoryPath(node.getPath());
        doc.setCloneId(this.getStringProperty(node, "slv:clone"));
        doc.setMajorVersion(this.getIntProperty(node, "slv:major"));
        doc.setMinorVersion(this.getIntProperty(node, "slv:minor"));
        doc.setStatus(this.getStringProperty(node, "slv:status"));
        doc.setDocumentType(DocumentType.fromFolderName(node.getParent().getName()));
        if (isFrozenNode) {
            nodeName = doc.computeNodeName();
            doc.setNodeName((String)nodeName);
            if (!node.getSession().nodeExists(doc.getFullJcrPath())) {
                nodeName = "version_" + doc.getOldSilverpeasId();
            }
        }
        doc.setNodeName((String)nodeName);
        doc.setPublicDocument(!doc.isVersioned() || doc.getMinorVersion() == 0);
        String forbiddenDownloadForRoles = this.getStringProperty(node, "slv:forbiddenDownloadForRoles");
        if (StringUtil.isDefined((String)forbiddenDownloadForRoles)) {
            doc.addRolesForWhichDownloadIsForbidden(SilverpeasRole.listFrom((String)forbiddenDownloadForRoles));
        }
        Optional.ofNullable(this.getBooleanProperty(node, "slv:displayableAsContent", null)).ifPresent(doc::setDisplayableAsContent);
        Optional.ofNullable(this.getBooleanProperty(node, "slv:editableSimultaneously", null)).ifPresent(doc::setEditableSimultaneously);
        return doc;
    }

    protected SimpleAttachment getAttachment(Node node, String language) throws RepositoryException {
        String attachmentNodeName = "file_" + language;
        if (node.hasNode(attachmentNodeName)) {
            return this.attachmentConverter.convertNode(node.getNode(attachmentNodeName));
        }
        return null;
    }

    public void fillNode(SimpleDocument document, Node documentNode) throws RepositoryException {
        this.fillNode(document, documentNode, false);
    }

    public void fillNode(SimpleDocument document, Node documentNode, boolean skipAttachmentContent) throws RepositoryException {
        this.setDocumentNodeProperties(document, documentNode);
        if (!skipAttachmentContent) {
            Node attachmentNode = this.getAttachmentNode(document.getAttachment().getNodeName(), documentNode);
            this.attachmentConverter.fillNode(document.getAttachment(), attachmentNode);
        }
    }

    private void setDocumentNodeProperties(SimpleDocument document, Node documentNode) throws RepositoryException {
        this.addStringProperty(documentNode, "slv:foreignKey", document.getForeignId());
        documentNode.setProperty("slv:versioned", document.isVersioned());
        documentNode.setProperty("slv:order", (long)document.getOrder());
        documentNode.setProperty("slv:oldSilverpeasId", document.getOldSilverpeasId());
        this.addStringProperty(documentNode, "slv:instanceId", document.getInstanceId());
        this.addStringProperty(documentNode, "slv:owner", document.getEditedBy());
        this.addStringProperty(documentNode, "slv:comment", document.getComment());
        this.addStringProperty(documentNode, "slv:status", document.getStatus());
        this.addDateProperty(documentNode, "slv:alertDate", document.getAlert());
        this.addDateProperty(documentNode, "slv:expiryDate", document.getExpiry());
        this.addDateProperty(documentNode, "slv:reservationDate", document.getReservation());
        this.addStringProperty(documentNode, "slv:clone", document.getCloneId());
        this.setForbiddenDownloadForRolesOptionalNodeProperty(document, documentNode);
        this.setDisplayableAsContentOptionalNodeProperty(document, documentNode);
    }

    void setForbiddenDownloadForRolesOptionalNodeProperty(SimpleDocument document, Node documentNode) throws RepositoryException {
        if (CollectionUtil.isNotEmpty(document.getForbiddenDownloadForRoles())) {
            documentNode.addMixin("slv:downloadable");
            this.addStringProperty(documentNode, "slv:forbiddenDownloadForRoles", SilverpeasRole.asString(document.getForbiddenDownloadForRoles()));
        } else if (documentNode.hasProperty("slv:forbiddenDownloadForRoles")) {
            documentNode.removeMixin("slv:downloadable");
        }
    }

    void setDisplayableAsContentOptionalNodeProperty(SimpleDocument document, Node documentNode) throws RepositoryException {
        if (document.isDisplayableAsContent() != AttachmentSettings.defaultValueOfDisplayableAsContentBehavior()) {
            documentNode.addMixin("slv:viewable");
            documentNode.setProperty("slv:displayableAsContent", document.isDisplayableAsContent());
        } else if (documentNode.hasProperty("slv:displayableAsContent")) {
            documentNode.removeMixin("slv:viewable");
        }
    }

    void setEditableSimultaneouslyOptionalNodeProperty(SimpleDocument document, Node documentNode) throws RepositoryException {
        Optional<Boolean> editableSimultaneously = document.editableSimultaneously();
        if (editableSimultaneously.isPresent()) {
            boolean enabled = editableSimultaneously.get();
            if (enabled != AttachmentSettings.defaultValueOfEditableSimultaneously()) {
                documentNode.addMixin("slv:editable");
                documentNode.setProperty("slv:editableSimultaneously", enabled);
            } else if (documentNode.hasProperty("slv:editableSimultaneously")) {
                documentNode.removeMixin("slv:editable");
            }
        }
    }

    private Node getAttachmentNode(String attachmentNodeName, Node documentNode) throws RepositoryException {
        Node attachmentNode = documentNode.hasNode(attachmentNodeName) ? documentNode.getNode(attachmentNodeName) : documentNode.addNode(attachmentNodeName, "slv:simpleAttachment");
        return attachmentNode;
    }

    public void addAttachment(Node documentNode, SimpleAttachment attachment) throws RepositoryException {
        Node attachmentNode = this.getAttachmentNode(attachment.getNodeName(), documentNode);
        this.attachmentConverter.fillNode(attachment, attachmentNode);
    }

    public void removeAttachment(Node documentNode, String language) throws RepositoryException {
        String lang = language;
        if (lang == null) {
            lang = I18NHelper.DEFAULT_LANGUAGE;
        }
        if (documentNode.hasNode("file_" + lang)) {
            Node attachmentNode = documentNode.getNode("file_" + lang);
            attachmentNode.remove();
        }
    }

    public boolean isVersionedMaster(Node node) throws RepositoryException {
        return this.getBooleanProperty(node, "slv:versioned", false) != false && !node.hasProperty("{http://www.jcp.org/jcr/1.0}frozenPrimaryType") && DocumentConverter.isMixinApplied(node, "{http://www.jcp.org/jcr/mix/1.0}versionable");
    }

    public String updateVersion(Node node, String lang, boolean isPublic) throws RepositoryException {
        int majorVersion = this.getIntProperty(node, "slv:major");
        int minorVersion = this.getIntProperty(node, "slv:minor");
        if (this.isVersionedMaster(node) && node.isCheckedOut()) {
            this.releaseDocumentNode(node, lang);
            if (isPublic) {
                minorVersion = 0;
                node.setProperty("slv:major", (long)(++majorVersion));
                node.setProperty("slv:minor", 0L);
            } else {
                node.setProperty("slv:minor", (long)(++minorVersion));
                if (!node.hasProperty("slv:major")) {
                    node.setProperty("slv:major", 0L);
                }
            }
        }
        return "Version " + majorVersion + "." + minorVersion;
    }

    public void releaseDocumentNode(Node documentNode, String lang) throws RepositoryException {
        String attachmentNodeName;
        String language = lang;
        if (!StringUtil.isDefined((String)language)) {
            language = I18NHelper.DEFAULT_LANGUAGE;
        }
        if (documentNode.hasNode(attachmentNodeName = "file_" + language)) {
            Node attachmentNode = this.getAttachmentNode(attachmentNodeName, documentNode);
            String currentLastModifiedBy = this.getStringProperty(attachmentNode, "{http://www.jcp.org/jcr/1.0}lastModifiedBy");
            String ownerId = this.getStringProperty(documentNode, "slv:owner");
            String lastModifiedBy = StringUtil.defaultStringIfNotDefined((String)ownerId, (String)currentLastModifiedBy);
            this.addStringProperty(attachmentNode, "{http://www.jcp.org/jcr/1.0}lastModifiedBy", lastModifiedBy);
        }
        this.addDateProperty(documentNode, "slv:expiryDate", null);
        this.addDateProperty(documentNode, "slv:alertDate", null);
        this.addDateProperty(documentNode, "slv:reservationDate", null);
        this.addStringProperty(documentNode, "slv:owner", null);
    }
}

