/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.attachment.model;

import java.io.File;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import javax.ws.rs.core.UriBuilder;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.WAPrimaryKey;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.attachment.AttachmentService;
import org.silverpeas.core.contribution.attachment.WebdavServiceProvider;
import org.silverpeas.core.contribution.attachment.model.DocumentType;
import org.silverpeas.core.contribution.attachment.model.SimpleAttachment;
import org.silverpeas.core.contribution.attachment.model.SimpleDocumentPK;
import org.silverpeas.core.contribution.attachment.util.AttachmentSettings;
import org.silverpeas.core.contribution.attachment.webdav.WebdavWbeFile;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.contribution.model.LocalizedAttachment;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.i18n.LocalizedResource;
import org.silverpeas.core.i18n.ResourceTranslation;
import org.silverpeas.core.persistence.jcr.JcrDataConverter;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.security.Securable;
import org.silverpeas.core.security.authorization.AccessControlContext;
import org.silverpeas.core.security.authorization.AccessControlOperation;
import org.silverpeas.core.security.authorization.SimpleDocumentAccessControl;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.util.URLEncoder;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.core.util.file.FileRepositoryManager;
import org.silverpeas.core.util.file.FileServerUtils;
import org.silverpeas.core.util.file.FileUtil;
import org.silverpeas.core.wbe.WbeFile;
import org.silverpeas.core.wbe.WbeHostManager;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.util.StringUtil;

public class SimpleDocument
implements LocalizedAttachment,
LocalizedResource,
ResourceTranslation,
Serializable,
Securable {
    private static final long serialVersionUID = 8778738762037114180L;
    public static final String WEBDAV_FOLDER = "webdav";
    public static final String ATTACHMENT_PREFIX = "attach_";
    public static final String VERSION_PREFIX = "version_";
    public static final String FILE_PREFIX = "file_";
    public static final String DOCUMENT_PREFIX = "simpledoc_";
    private static final int CAPACITY = 500;
    private String repositoryPath;
    private SimpleDocument versionMaster = this;
    private int versionIndex = 0;
    private SimpleDocumentPK pk;
    private String foreignId;
    private int order;
    private boolean versioned;
    private String webdavContentEditionLanguage;
    private long webdavContentEditionSize = -1L;
    private String editedBy;
    private Date reservation;
    private Date alert;
    private Date expiry;
    private String status;
    private String cloneId;
    private int minorVersion = 0;
    private int majorVersion = 0;
    private boolean publicDocument = true;
    private String nodeName;
    private String comment;
    private DocumentType documentType = DocumentType.attachment;
    private Set<SilverpeasRole> forbiddenDownloadForRoles = null;
    private SimpleAttachment attachment;
    private Boolean displayableAsContent;
    private Boolean editableSimultaneously;

    public static boolean isASimpleDocument(ContributionIdentifier id) {
        return DocumentType.decode(id.getType()) != null;
    }

    public SimpleDocument(SimpleDocumentPK pk, String foreignId, int order, boolean versioned, SimpleAttachment attachment) {
        this(pk, foreignId, order, versioned, null, attachment);
    }

    public SimpleDocument(SimpleDocumentPK pk, String foreignId, int order, boolean versioned, String editedBy, SimpleAttachment attachment) {
        this.pk = pk;
        this.foreignId = foreignId;
        this.order = order;
        this.versioned = versioned;
        this.editedBy = editedBy;
        this.attachment = attachment;
    }

    public SimpleDocument() {
    }

    public SimpleDocument(SimpleDocument simpleDocument) {
        this.repositoryPath = simpleDocument.getRepositoryPath();
        this.versionMaster = simpleDocument.getVersionMaster();
        this.versionIndex = simpleDocument.getVersionIndex();
        this.pk = simpleDocument.getPk().copy();
        this.foreignId = simpleDocument.getForeignId();
        this.order = simpleDocument.getOrder();
        this.versioned = simpleDocument.isVersioned();
        this.editedBy = simpleDocument.getEditedBy();
        this.reservation = simpleDocument.getReservation();
        this.alert = simpleDocument.getAlert();
        this.expiry = simpleDocument.getExpiry();
        this.status = simpleDocument.getStatus();
        this.cloneId = simpleDocument.getCloneId();
        this.minorVersion = simpleDocument.getMinorVersion();
        this.majorVersion = simpleDocument.getMajorVersion();
        this.publicDocument = simpleDocument.isPublic();
        this.nodeName = simpleDocument.getNodeName();
        this.comment = simpleDocument.getComment();
        this.documentType = simpleDocument.getDocumentType();
        this.forbiddenDownloadForRoles = simpleDocument.forbiddenDownloadForRoles != null ? EnumSet.copyOf(simpleDocument.forbiddenDownloadForRoles) : null;
        this.attachment = new SimpleAttachment(simpleDocument.getAttachment());
        this.displayableAsContent = simpleDocument.displayableAsContent;
        this.editableSimultaneously = simpleDocument.editableSimultaneously;
    }

    public ContributionIdentifier getIdentifier() {
        return ContributionIdentifier.from((ResourceReference)new ResourceReference((WAPrimaryKey)this.getPk()), (String)this.getDocumentType().getName());
    }

    public User getCreator() {
        return User.getById((String)this.getCreatedBy());
    }

    public User getLastUpdater() {
        if (StringUtil.isDefined((String)this.getUpdatedBy())) {
            return User.getById((String)this.getUpdatedBy());
        }
        return null;
    }

    public void setDocumentType(DocumentType documentType) {
        this.documentType = documentType;
    }

    public DocumentType getDocumentType() {
        return this.documentType;
    }

    public String getCloneId() {
        return this.cloneId;
    }

    public void setCloneId(String cloneId) {
        this.cloneId = cloneId;
    }

    public String getFilename() {
        return this.getAttachment().getFilename();
    }

    public void setFilename(String filename) {
        this.getAttachment().setFilename(filename);
    }

    public String getLanguage() {
        return this.getAttachment().getLanguage();
    }

    public void setLanguage(String language) {
        this.getAttachment().setLanguage(language);
    }

    public String getTitle() {
        return this.getAttachment().getTitle();
    }

    public String getName() {
        return this.getTitle();
    }

    public void setTitle(String title) {
        this.getAttachment().setTitle(title);
    }

    public String getDescription() {
        return this.getAttachment().getDescription();
    }

    public void setDescription(String description) {
        this.getAttachment().setDescription(description);
    }

    public long getSize() {
        return this.getAttachment().getSize();
    }

    public void setSize(long size) {
        this.getAttachment().setSize(size);
    }

    public String getContentType() {
        return this.getAttachment().getContentType();
    }

    public void setContentType(String contentType) {
        this.getAttachment().setContentType(contentType);
    }

    public String getCreatedBy() {
        return this.getAttachment().getCreatedBy();
    }

    public Date getCreationDate() {
        return this.getAttachment().getCreationDate();
    }

    public void setCreationDate(Date created) {
        this.getAttachment().setCreationDate(created);
    }

    public String getUpdatedBy() {
        return this.getAttachment().getUpdatedBy();
    }

    public void setUpdatedBy(String updatedBy) {
        this.getAttachment().setUpdatedBy(updatedBy);
    }

    public Date getLastUpdateDate() {
        return this.getAttachment().getLastUpdateDate();
    }

    public void setLastUpdateDate(Date updated) {
        this.getAttachment().setLastUpdateDate(updated);
    }

    public Date getReservation() {
        if (this.reservation == null) {
            return null;
        }
        return new Date(this.reservation.getTime());
    }

    public final void setReservation(Date reservationDate) {
        this.reservation = reservationDate == null ? null : new Date(reservationDate.getTime());
    }

    public Date getAlert() {
        if (this.alert == null) {
            return null;
        }
        return new Date(this.alert.getTime());
    }

    public void setAlert(Date alert) {
        this.alert = alert == null ? null : DateUtil.getBeginOfDay((Date)alert);
    }

    public Date getExpiry() {
        if (this.expiry == null) {
            return null;
        }
        return new Date(this.expiry.getTime());
    }

    public void setExpiry(Date expiry) {
        this.expiry = expiry == null ? null : DateUtil.getBeginOfDay((Date)expiry);
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(int minorVersion) {
        this.minorVersion = minorVersion;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public void setMajorVersion(int majorVersion) {
        this.majorVersion = majorVersion;
    }

    public String getVersion() {
        return this.getMajorVersion() + "." + this.getMinorVersion();
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    protected void resetWebdavContentEditionContext() {
        this.webdavContentEditionLanguage = null;
        this.webdavContentEditionSize = -1L;
    }

    public String getWebdavContentEditionLanguage() {
        if (this.webdavContentEditionLanguage == null) {
            if (this.isOpenOfficeCompatible() && this.isEdited()) {
                this.webdavContentEditionLanguage = WebdavServiceProvider.getWebdavService().getContentEditionLanguage(this.getVersionMaster());
            }
            if (this.webdavContentEditionLanguage == null) {
                this.webdavContentEditionLanguage = "";
            }
        }
        return this.webdavContentEditionLanguage;
    }

    public long getWebdavContentEditionSize() {
        if (this.webdavContentEditionSize < 0L) {
            if (this.isOpenOfficeCompatible() && this.isEdited()) {
                this.webdavContentEditionSize = WebdavServiceProvider.getWebdavService().getContentEditionSize(this.getVersionMaster());
            }
            if (this.webdavContentEditionSize < 0L) {
                this.webdavContentEditionSize = 0L;
            }
        }
        return this.webdavContentEditionSize;
    }

    public String getEditedBy() {
        return this.editedBy;
    }

    public void edit(String currentEditor) {
        this.resetWebdavContentEditionContext();
        this.editedBy = currentEditor;
        this.setReservation(new Date());
        String day = OrganizationController.get().getComponentParameterValue(this.getInstanceId(), "nbDayForReservation");
        if (StringUtil.isInteger((String)day)) {
            int result;
            int nbDay = Integer.parseInt(day);
            Calendar calendar = Calendar.getInstance();
            DateUtil.addDaysExceptWeekEnds((Calendar)calendar, (int)nbDay);
            this.setExpiry(calendar.getTime());
            int maxDelay = 100;
            int minResult = 2;
            int delayReservedFile = AttachmentSettings.getDelayInPercentAfterWhichReservedFileAlertMustBeSent();
            if (delayReservedFile >= 0 && delayReservedFile <= 100 && (result = nbDay * delayReservedFile / 100) > 2) {
                calendar = Calendar.getInstance();
                DateUtil.addDaysExceptWeekEnds((Calendar)calendar, (int)result);
                this.setAlert(calendar.getTime());
            }
        }
    }

    public void release() {
        this.resetWebdavContentEditionContext();
        this.editedBy = null;
        this.setReservation(null);
        this.setExpiry(null);
        this.setAlert(null);
    }

    public String getXmlFormId() {
        return this.getAttachment().getXmlFormId();
    }

    public void setXmlFormId(String xmlFormId) {
        this.getAttachment().setXmlFormId(xmlFormId);
    }

    public String getId() {
        if (this.getPk() != null) {
            return this.getPk().getId();
        }
        return null;
    }

    public void setId(String id) {
        if (this.getPk() != null) {
            this.getPk().setId(id);
        } else {
            this.setPK(new SimpleDocumentPK(id));
        }
    }

    public void setPK(SimpleDocumentPK pk) {
        this.pk = pk;
    }

    public String getInstanceId() {
        return this.getPk().getInstanceId();
    }

    public long getOldSilverpeasId() {
        return this.getPk().getOldSilverpeasId();
    }

    public void setOldSilverpeasId(long oldSilverpeasId) {
        this.getPk().setOldSilverpeasId(oldSilverpeasId);
    }

    public String getForeignId() {
        return this.foreignId;
    }

    public void setForeignId(String foreignId) {
        this.foreignId = foreignId;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public boolean isVersioned() {
        return this.versioned;
    }

    public SimpleAttachment getAttachment() {
        return this.attachment;
    }

    public SimpleDocumentPK getPk() {
        return this.pk;
    }

    public void setAttachment(SimpleAttachment attachment) {
        this.attachment = attachment;
    }

    public boolean isPublic() {
        return this.publicDocument;
    }

    public void setPublicDocument(boolean publicDocument) {
        this.publicDocument = publicDocument;
    }

    public void unlock() {
        this.resetWebdavContentEditionContext();
        this.editedBy = null;
        this.setExpiry(null);
        this.setAlert(null);
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public String computeNodeName() {
        if (!StringUtil.isDefined((String)this.getNodeName())) {
            if (this.getOldSilverpeasId() <= 0L) {
                this.setOldSilverpeasId(DBUtil.getNextId((String)"sb_simple_document", (String)"id"));
            }
            this.setNodeName(DOCUMENT_PREFIX + this.getOldSilverpeasId());
            return this.getNodeName();
        }
        return this.getNodeName();
    }

    public String getFullJcrContentPath() {
        return this.getFullJcrPath() + "/" + this.getAttachment().getNodeName();
    }

    public String getFullJcrPath() {
        return "/" + this.getInstanceId() + "/" + this.getFolder() + "/" + this.getNodeName();
    }

    public String getDisplayIcon() {
        return FileRepositoryManager.getFileIcon(FileRepositoryManager.getFileExtension(this.getFilename()));
    }

    public boolean isOpenOfficeCompatible() {
        return FileUtil.isOpenOfficeCompatible(this.getFilename());
    }

    public boolean isReadOnly() {
        User requester = User.getCurrentRequester();
        boolean readOnly = requester != null ? this.isEdited() && !this.isEditedBy(requester) || !this.isEdited() && !this.canBeModifiedBy(requester) : this.isEdited();
        return readOnly;
    }

    public boolean isEdited() {
        return StringUtil.isDefined((String)this.getEditedBy());
    }

    public boolean isEditedBy(User user) {
        return user.getId().equals(this.getEditedBy());
    }

    public String getAttachmentPath() {
        String lang = this.getLanguage();
        if (!StringUtil.isDefined((String)lang)) {
            lang = I18NHelper.DEFAULT_LANGUAGE;
        }
        return this.getDirectoryPath(lang) + this.getFilename();
    }

    public String getDirectoryPath(String language) {
        String directory = FileRepositoryManager.getAbsolutePath(this.getInstanceId());
        directory = directory.replace('/', File.separatorChar);
        String versionDir = this.getMajorVersion() + "_" + this.getMinorVersion();
        String lang = language;
        if (!StringUtil.isDefined((String)lang)) {
            lang = I18NHelper.DEFAULT_LANGUAGE;
        }
        return directory + this.getNodeName() + File.separatorChar + versionDir + File.separatorChar + lang + File.separatorChar;
    }

    public String toString() {
        return "SimpleDocument{" + this.getNodeName() + " pk=" + String.valueOf((Object)this.getPk()) + ", foreignId=" + this.getForeignId() + ", order=" + this.getOrder() + ", versioned=" + this.isVersioned() + ", editedBy=" + this.getEditedBy() + ", reservation=" + String.valueOf(this.getReservation()) + ", alert=" + String.valueOf(this.getAlert()) + ", expiry=" + String.valueOf(this.getExpiry()) + ", status=" + this.getStatus() + ", cloneId=" + this.getCloneId() + ", attachment=" + String.valueOf(this.getAttachment()) + ", minorVersion=" + this.getMinorVersion() + ", majorVersion=" + this.getMajorVersion() + ", comment=" + this.getComment() + "}";
    }

    public int hashCode() {
        int hash = 3;
        hash = 31 * hash + (this.getPk() != null ? this.getPk().hashCode() : 0);
        hash = 31 * hash + this.getMinorVersion();
        hash = 31 * hash + this.getMajorVersion();
        hash = 31 * hash + this.getVersionIndex();
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SimpleDocument)) {
            return false;
        }
        SimpleDocument other = (SimpleDocument)obj;
        if (!(this.getPk() == other.getPk() || this.getPk() != null && this.getPk().equals((Object)other.getPk()))) {
            return false;
        }
        if (this.getMinorVersion() != other.getMinorVersion()) {
            return false;
        }
        if (this.getMajorVersion() != other.getMajorVersion()) {
            return false;
        }
        return this.getVersionIndex() == other.getVersionIndex();
    }

    public String getAttachmentURL() {
        Date date;
        Date date2 = date = this.getLastUpdateDate() != null ? this.getLastUpdateDate() : this.getCreationDate();
        if (date == null) {
            date = Date.from(Instant.now());
        }
        return UriBuilder.fromPath((String)FileServerUtils.getAttachmentURL(this.getPk().getInstanceId(), this.getFilename(), this.getPk().getId(), this.getLanguage())).queryParam("t_", new Object[]{date.getTime()}).build(new Object[0]).toString();
    }

    public String getUniversalURL() {
        return URLUtil.getSimpleURL(4, this.getId()) + "?ContentLanguage=" + this.getLanguage();
    }

    public String getOnlineURL() {
        Object onlineUrl = FileServerUtils.getOnlineURL(this.getPk().getComponentName(), this.getFilename(), "", this.getContentType(), "");
        String extension = FileRepositoryManager.getFileExtension(this.getFilename());
        if ("exe".equalsIgnoreCase(extension) || "pdf".equalsIgnoreCase(extension)) {
            onlineUrl = (String)onlineUrl + "&logicalName=" + URLEncoder.encodePathParamValue(this.getFilename());
        }
        return onlineUrl;
    }

    public String getWebdavUrl() {
        StringBuilder url = new StringBuilder(500);
        String webAppContext = URLUtil.getApplicationURL();
        url.append(webAppContext);
        if (!webAppContext.endsWith("/")) {
            url.append('/');
        }
        url.append(ResourceLocator.getGeneralSettingBundle().getString("webdav.repository")).append('/').append(ResourceLocator.getGeneralSettingBundle().getString("webdav.workspace")).append('/').append(this.getWebdavJcrPath());
        return url.toString();
    }

    public String getWebdavJcrPath() {
        StringBuilder jcrPath = new StringBuilder(500);
        jcrPath.append(WEBDAV_FOLDER).append('/').append(DocumentType.attachment.getFolderName()).append('/').append(this.getVersionMaster().getInstanceId()).append('/');
        if (this.getVersionMaster().getId() != null) {
            jcrPath.append(this.getVersionMaster().getId()).append('/');
        }
        if (this.getLanguage() != null) {
            jcrPath.append(this.getVersionMaster().getLanguage()).append('/');
        }
        jcrPath.append(JcrDataConverter.escapeIllegalJcrChars(this.getVersionMaster().getFilename()));
        return jcrPath.toString();
    }

    public SimpleDocument getVersionMaster() {
        return this.versionMaster;
    }

    public void setVersionMaster(SimpleDocument versionMaster) {
        this.versionMaster = versionMaster;
    }

    public boolean isVersionMaster() {
        return this == this.getVersionMaster();
    }

    public String getRepositoryPath() {
        return this.repositoryPath;
    }

    public void setRepositoryPath(String repositoryPath) {
        this.repositoryPath = repositoryPath;
    }

    public int getVersionIndex() {
        return this.versionIndex;
    }

    public void setVersionIndex(int versionIndex) {
        this.versionIndex = versionIndex;
    }

    public SimpleDocument getLastPublicVersion() {
        return this;
    }

    public String getFolder() {
        return this.getDocumentType().getFolderName();
    }

    public boolean isSharingAllowedForRolesFrom(User user) {
        if (user == null || StringUtil.isNotDefined((String)user.getId()) || !user.isValidState()) {
            return false;
        }
        return SimpleDocumentAccessControl.get().isUserAuthorized(user.getId(), this.getVersionMaster(), AccessControlContext.init().onOperationsOf(new AccessControlOperation[]{AccessControlOperation.SHARING}));
    }

    public boolean canBeAccessedBy(User user) {
        return SimpleDocumentAccessControl.get().isUserAuthorized(user.getId(), this);
    }

    public boolean canBeModifiedBy(User user) {
        return SimpleDocumentAccessControl.get().isUserAuthorized(user.getId(), this, AccessControlContext.init().onOperationsOf(new AccessControlOperation[]{AccessControlOperation.MODIFICATION}));
    }

    public boolean isDownloadAllowedForRolesFrom(User user) {
        if (user == null || StringUtil.isNotDefined((String)user.getId()) || !user.isValidState()) {
            return false;
        }
        if (CollectionUtil.isEmpty(this.getVersionMaster().forbiddenDownloadForRoles)) {
            return true;
        }
        return SimpleDocumentAccessControl.get().isUserAuthorized(user.getId(), this.getVersionMaster(), AccessControlContext.init().onOperationsOf(new AccessControlOperation[]{AccessControlOperation.DOWNLOAD}));
    }

    public boolean isDownloadAllowedForRoles(Set<SilverpeasRole> roles) {
        SilverpeasRole highestRole = SilverpeasRole.getHighestFrom(roles);
        if (highestRole == null) {
            return false;
        }
        SilverpeasRole highestForbiddenRole = SilverpeasRole.getHighestFrom(this.getVersionMaster().forbiddenDownloadForRoles);
        if (highestForbiddenRole == null) {
            return true;
        }
        return highestRole.isGreaterThan(highestForbiddenRole);
    }

    public boolean isDownloadAllowedForReaders() {
        return this.isDownloadAllowedForRoles(SilverpeasRole.READER_ROLES);
    }

    public boolean addRolesForWhichDownloadIsForbidden(SilverpeasRole ... forbiddenRoles) {
        return this.addRolesForWhichDownloadIsForbidden(Arrays.asList(forbiddenRoles));
    }

    public boolean addRolesForWhichDownloadIsForbidden(Collection<SilverpeasRole> forbiddenRoles) {
        if (CollectionUtil.isNotEmpty(forbiddenRoles)) {
            if (this.getVersionMaster().forbiddenDownloadForRoles == null) {
                this.getVersionMaster().forbiddenDownloadForRoles = EnumSet.noneOf(SilverpeasRole.class);
            }
            return this.getVersionMaster().forbiddenDownloadForRoles.addAll(forbiddenRoles);
        }
        return false;
    }

    public void addRolesForWhichDownloadIsAllowed(SilverpeasRole ... allowedRoles) {
        this.addRolesForWhichDownloadIsAllowed(Arrays.asList(allowedRoles));
    }

    public boolean addRolesForWhichDownloadIsAllowed(Collection<SilverpeasRole> allowedRoles) {
        return CollectionUtil.isNotEmpty(allowedRoles) && CollectionUtil.isNotEmpty(this.getVersionMaster().forbiddenDownloadForRoles) && this.getVersionMaster().forbiddenDownloadForRoles.removeAll(allowedRoles);
    }

    public Set<SilverpeasRole> getForbiddenDownloadForRoles() {
        return this.getVersionMaster().forbiddenDownloadForRoles != null ? Collections.unmodifiableSet(this.getVersionMaster().forbiddenDownloadForRoles) : null;
    }

    public boolean isContentImage() {
        return FileUtil.isImage(this.getAttachmentPath());
    }

    public boolean isContentSpinfire() {
        return FileUtil.isSpinfireDocument(this.getAttachmentPath());
    }

    public boolean isContentArchive() {
        return FileUtil.isArchive(this.getAttachmentPath());
    }

    public boolean isContentMail() {
        return FileUtil.isMail(this.getAttachmentPath());
    }

    public boolean isContentPdf() {
        return FileUtil.isPdf(this.getAttachmentPath());
    }

    public boolean isDisplayableAsContent() {
        return this.getVersionMaster().displayableAsContent != null ? this.getVersionMaster().displayableAsContent : AttachmentSettings.defaultValueOfDisplayableAsContentBehavior();
    }

    public void setDisplayableAsContent(boolean displayableAsContent) {
        this.displayableAsContent = displayableAsContent;
    }

    public SimpleDocument getTranslation(String language) {
        if (language.equals(this.getLanguage())) {
            return this;
        }
        SimpleDocument translation = AttachmentService.get().searchDocumentById(this.getPk(), language);
        return translation == null ? this : translation;
    }

    public Optional<Boolean> editableSimultaneously() {
        if (this.getVersionMaster().isOpenOfficeCompatible() && WbeHostManager.get().isHandled((WbeFile)new WebdavWbeFile(this.getVersionMaster()))) {
            return Optional.of(this.getVersionMaster().editableSimultaneously != null ? this.getVersionMaster().editableSimultaneously : AttachmentSettings.defaultValueOfEditableSimultaneously());
        }
        return Optional.empty();
    }

    public void setEditableSimultaneously(boolean editableSimultaneously) {
        this.getVersionMaster().editableSimultaneously = editableSimultaneously;
    }
}

