/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.attachment.model;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.i18n.I18n;

public class SimpleAttachment
implements Serializable {
    private static final long serialVersionUID = -6153003608158238503L;
    private String filename;
    private String language = I18NHelper.DEFAULT_LANGUAGE;
    private String title;
    private String description;
    private long size;
    private String contentType;
    private String createdBy;
    private Date created;
    private String updatedBy;
    private Date updated;
    private String xmlFormId;

    public static Builder builder(String language) {
        return new Builder(language);
    }

    public static Builder builder() {
        return new Builder(I18n.get().getDefaultLanguage());
    }

    private SimpleAttachment() {
    }

    public SimpleAttachment(SimpleAttachment attachment) {
        this.filename = attachment.filename;
        this.language = attachment.language;
        this.title = attachment.title;
        this.description = attachment.description;
        this.size = attachment.size;
        this.contentType = attachment.contentType;
        this.createdBy = attachment.createdBy;
        this.created = attachment.created;
        this.updatedBy = attachment.updatedBy;
        this.updated = attachment.updated;
        this.xmlFormId = attachment.xmlFormId;
    }

    public String getNodeName() {
        return "file_" + this.getLanguage();
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = I18NHelper.checkLanguage(language);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Date getCreationDate() {
        if (this.created == null) {
            return null;
        }
        return new Date(this.created.getTime());
    }

    public final void setCreationDate(Date creationDate) {
        this.created = creationDate == null ? null : new Date(creationDate.getTime());
    }

    public String getUpdatedBy() {
        return this.updatedBy;
    }

    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public Date getLastUpdateDate() {
        if (this.updated == null) {
            return null;
        }
        return new Date(this.updated.getTime());
    }

    public final void setLastUpdateDate(Date updateDate) {
        this.updated = updateDate == null ? null : new Date(updateDate.getTime());
    }

    public String getXmlFormId() {
        return this.xmlFormId;
    }

    public void setXmlFormId(String xmlFormId) {
        this.xmlFormId = xmlFormId;
    }

    public int hashCode() {
        int hash = 7;
        hash = 61 * hash + (this.filename != null ? this.filename.hashCode() : 0);
        hash = 61 * hash + (this.language != null ? this.language.hashCode() : 0);
        hash = 61 * hash + (this.title != null ? this.title.hashCode() : 0);
        hash = 61 * hash + (this.description != null ? this.description.hashCode() : 0);
        hash = 61 * hash + (int)(this.size ^ this.size >>> 32);
        hash = 61 * hash + (this.contentType != null ? this.contentType.hashCode() : 0);
        hash = 61 * hash + (this.createdBy != null ? this.createdBy.hashCode() : 0);
        hash = 61 * hash + (this.created != null ? this.created.hashCode() : 0);
        hash = 61 * hash + (this.updatedBy != null ? this.updatedBy.hashCode() : 0);
        hash = 61 * hash + (this.updated != null ? this.updated.hashCode() : 0);
        hash = 61 * hash + (this.xmlFormId != null ? this.xmlFormId.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleAttachment other = (SimpleAttachment)obj;
        if (!Objects.equals(this.filename, other.filename)) {
            return false;
        }
        if (!Objects.equals(this.language, other.language)) {
            return false;
        }
        if (!Objects.equals(this.title, other.title)) {
            return false;
        }
        if (!Objects.equals(this.description, other.description)) {
            return false;
        }
        if (this.size != other.size) {
            return false;
        }
        if (!Objects.equals(this.contentType, other.contentType)) {
            return false;
        }
        if (!Objects.equals(this.createdBy, other.createdBy)) {
            return false;
        }
        if (!Objects.equals(this.created, other.created)) {
            return false;
        }
        if (!Objects.equals(this.updatedBy, other.updatedBy)) {
            return false;
        }
        if (!Objects.equals(this.updated, other.updated)) {
            return false;
        }
        return Objects.equals(this.xmlFormId, other.xmlFormId);
    }

    public String toString() {
        return "SimpleAttachment{filename=" + this.filename + ", language=" + this.language + ", title=" + this.title + ", description=" + this.description + ", size=" + this.size + ", contentType=" + this.contentType + ", createdBy=" + this.createdBy + ", created=" + String.valueOf(this.created) + ", updatedBy=" + this.updatedBy + ", updated=" + String.valueOf(this.updated) + ", xmlFormId=" + this.xmlFormId + "}";
    }

    public static class Builder {
        private final SimpleAttachment attachment = new SimpleAttachment();

        private Builder(String language) {
            this.attachment.setLanguage(language);
        }

        public Builder setFilename(String filename) {
            this.attachment.setFilename(filename);
            return this;
        }

        public Builder setTitle(String title) {
            this.attachment.setTitle(title);
            return this;
        }

        public Builder setDescription(String description) {
            this.attachment.setDescription(description);
            return this;
        }

        public Builder setSize(long size) {
            this.attachment.setSize(size);
            return this;
        }

        public Builder setContentType(String contentType) {
            this.attachment.setContentType(contentType);
            return this;
        }

        public Builder setCreationData(String creator, Date creationDate) {
            this.attachment.setCreatedBy(creator);
            this.attachment.setCreationDate(creationDate);
            return this;
        }

        public Builder setFormId(String formId) {
            this.attachment.setXmlFormId(formId);
            return this;
        }

        public SimpleAttachment build() {
            return this.attachment;
        }
    }
}

