/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.attachment;

import java.io.File;
import java.text.ParseException;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.attachment.ActifyDocumentProcessor;
import org.silverpeas.core.contribution.attachment.AttachmentService;
import org.silverpeas.core.contribution.attachment.AttachmentServiceProvider;
import org.silverpeas.core.contribution.attachment.model.DocumentType;
import org.silverpeas.core.contribution.attachment.model.SimpleAttachment;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.contribution.attachment.model.SimpleDocumentPK;
import org.silverpeas.core.contribution.attachment.model.UnlockContext;
import org.silverpeas.core.contribution.attachment.model.UnlockOption;
import org.silverpeas.core.contribution.attachment.util.SimpleDocumentList;
import org.silverpeas.core.initialization.Initialization;
import org.silverpeas.core.scheduler.Job;
import org.silverpeas.core.scheduler.JobExecutionContext;
import org.silverpeas.core.scheduler.Scheduler;
import org.silverpeas.core.scheduler.SchedulerEvent;
import org.silverpeas.core.scheduler.SchedulerEventListener;
import org.silverpeas.core.scheduler.SchedulerException;
import org.silverpeas.core.scheduler.SchedulerProvider;
import org.silverpeas.core.scheduler.trigger.JobTrigger;
import org.silverpeas.core.util.file.FileUtil;
import org.silverpeas.kernel.logging.SilverLogger;

@Service
public class ActifyDocumentProcessScheduler
implements SchedulerEventListener,
Initialization {
    public void init() {
        if (ActifyDocumentProcessor.isActifySupportEnabled()) {
            try {
                String cronScheduleProcess = ActifyDocumentProcessor.getCRONForActifyImport();
                String cronSchedulePurge = ActifyDocumentProcessor.getCRONForActifyPurge();
                Scheduler scheduler = SchedulerProvider.getVolatileScheduler();
                Job actifyDocumentImporter = this.getActifyDocumentImporter();
                Job actifyDocumentCleaner = this.getActifyDocumentCleaner();
                scheduler.unscheduleJob(actifyDocumentImporter.getName());
                scheduler.unscheduleJob(actifyDocumentCleaner.getName());
                JobTrigger processTrigger = JobTrigger.triggerAt((String)cronScheduleProcess);
                scheduler.scheduleJob(actifyDocumentImporter, processTrigger, (SchedulerEventListener)this);
                JobTrigger purgeTrigger = JobTrigger.triggerAt((String)cronSchedulePurge);
                scheduler.scheduleJob(actifyDocumentCleaner, purgeTrigger, (SchedulerEventListener)this);
            }
            catch (ParseException | SchedulerException e) {
                SilverLogger.getLogger((Object)this).error(e.getMessage(), e);
            }
        }
    }

    public void triggerFired(SchedulerEvent anEvent) {
        SilverLogger.getLogger((Object)this).debug("Starting of the job ''{0}''", new Object[]{anEvent.getJobExecutionContext().getJobName()});
    }

    public void jobSucceeded(SchedulerEvent anEvent) {
        SilverLogger.getLogger((Object)this).debug("The job ''{0}'' has succeeded", new Object[]{anEvent.getJobExecutionContext().getJobName()});
    }

    public void jobFailed(SchedulerEvent anEvent) {
        Object errorMsg = "";
        if (anEvent.isExceptionThrown()) {
            errorMsg = ": " + anEvent.getJobThrowable().getMessage();
        }
        SilverLogger.getLogger((Object)this).error("The job ''{0}'' has failed {1}", new Object[]{anEvent.getJobExecutionContext().getJobName(), errorMsg});
    }

    protected Job getActifyDocumentImporter() {
        return new ActifyDocumentImportJob("ImportActify");
    }

    protected Job getActifyDocumentCleaner() {
        return new Job("PurgeActify"){

            public void execute(JobExecutionContext context) {
                SilverLogger.getLogger((Object)((Object)this)).debug("Purge of the source directory used by Actify...", new Object[0]);
                int delayBeforePurge = ActifyDocumentProcessor.getDelayBeforePurge();
                long now = new Date().getTime();
                File folderToAnalyse = new File(ActifyDocumentProcessor.getActifySourcePath());
                File[] elementsList = folderToAnalyse.listFiles();
                if (elementsList != null) {
                    for (File element : elementsList) {
                        long lastModified = element.lastModified();
                        if (!element.isDirectory() || lastModified + (long)delayBeforePurge * 1000L * 60L > now) continue;
                        FileUtils.deleteQuietly((File)new File(element.getAbsolutePath()));
                    }
                }
            }
        };
    }

    public static class ActifyDocumentImportJob
    extends Job {
        public ActifyDocumentImportJob(String name) {
            super(name);
        }

        public void execute(JobExecutionContext context) {
            SilverLogger.getLogger((Object)((Object)this)).debug("Importation of the 3D documents generated by Actify...", new Object[0]);
            long now = new Date().getTime();
            String resultActifyPath = ActifyDocumentProcessor.getActifyResultPath();
            int delayBeforeProcess = ActifyDocumentProcessor.getDelayBeforeImport();
            File folderToAnalyse = new File(resultActifyPath);
            File[] elementsList = folderToAnalyse.listFiles();
            if (elementsList != null) {
                for (File element : elementsList) {
                    long lastModified = element.lastModified();
                    String dirName = element.getName();
                    String resultActifyFullPath = resultActifyPath + File.separator + dirName;
                    if (!this.isManagedBySilverpeas(element) || lastModified + (long)delayBeforeProcess * 1000L * 60L > now) continue;
                    int separatorIdx = dirName.lastIndexOf(95);
                    boolean isVersioned = dirName.startsWith("v_");
                    String componentId = dirName.substring(2, separatorIdx);
                    String publicationId = dirName.substring(separatorIdx + 1);
                    String detailPathToAnalyse = element.getAbsolutePath();
                    folderToAnalyse = new File(detailPathToAnalyse);
                    File[] filesList = folderToAnalyse.listFiles();
                    if (filesList != null) {
                        this.importActifyDocuments(publicationId, componentId, isVersioned, filesList);
                    }
                    FileUtils.deleteQuietly((File)new File(resultActifyFullPath));
                }
            }
        }

        private boolean isManagedBySilverpeas(File directory) {
            String directoryName = directory.getName();
            return directory.isDirectory() && (directoryName.startsWith("a_") || directoryName.startsWith("v_"));
        }

        private boolean documentExists(SimpleDocument document) {
            return document != null;
        }

        private SimpleDocument getSourceDocument(String filename, ResourceReference publication) {
            SimpleDocument source = null;
            SimpleDocumentList<SimpleDocument> documents = AttachmentServiceProvider.getAttachmentService().listDocumentsByForeignKey(publication, null);
            for (SimpleDocument aDocument : documents) {
                String destFile = FilenameUtils.getBaseName((String)filename);
                String srcFile = FilenameUtils.getBaseName((String)aDocument.getFilename());
                if (!ActifyDocumentProcessor.isCADDocumentSupported(aDocument.getFilename()) || !srcFile.equals(destFile)) continue;
                source = aDocument;
                break;
            }
            return source;
        }

        private void importActifyDocuments(String publicationId, String componentId, boolean isVersioned, File[] filesList) {
            AttachmentService attachmentService = AttachmentServiceProvider.getAttachmentService();
            for (File file : filesList) {
                String fileName = file.getName();
                String mimeType = FileUtil.getMimeType(fileName);
                SimpleDocument document = null;
                if (isVersioned && this.documentExists(document = attachmentService.findExistingDocument(new SimpleDocumentPK(null, componentId), fileName, new ResourceReference(publicationId), null))) {
                    attachmentService.updateAttachment(document, file, false, false);
                    UnlockContext unlockContext = new UnlockContext(document.getId(), "", null, "");
                    unlockContext.addOption(UnlockOption.UPLOAD);
                    if (!document.isPublic()) {
                        unlockContext.addOption(UnlockOption.PRIVATE_VERSION);
                    }
                    attachmentService.unlock(unlockContext);
                }
                if (this.documentExists(document)) continue;
                String userId = "0";
                DocumentType documentType = DocumentType.attachment;
                SimpleDocument documentSource = this.getSourceDocument(fileName, new ResourceReference(publicationId, componentId));
                if (documentSource != null) {
                    userId = documentSource.getCreatedBy();
                    documentType = documentSource.getDocumentType();
                }
                SimpleAttachment attachment = SimpleAttachment.builder().setFilename(fileName).setSize(file.length()).setContentType(mimeType).setCreationData(userId, new Date()).build();
                document = new SimpleDocument(new SimpleDocumentPK(null, componentId), publicationId, 0, isVersioned, attachment);
                document.setDocumentType(documentType);
                attachmentService.createAttachment(document, file, false);
            }
        }
    }
}

