/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution;

import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.temporal.Temporal;
import java.util.Optional;
import org.silverpeas.core.contribution.ContributionVisibility;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.date.Period;
import org.silverpeas.core.util.MemoizedSupplier;

public class DefaultContributionVisibility
implements ContributionVisibility {
    private static final long serialVersionUID = -8090436142075127600L;
    private final Contribution contribution;
    private final Period specificPeriod;
    private transient MemoizedSupplier<Period> period;

    protected DefaultContributionVisibility(Contribution contribution, Period specificPeriod) {
        this.contribution = contribution;
        this.specificPeriod = specificPeriod;
    }

    @Override
    public Optional<Period> getSpecificPeriod() {
        return this.specificPeriod.startsAtMinDate() && this.specificPeriod.endsAtMaxDate() ? Optional.empty() : Optional.of(this.specificPeriod);
    }

    @Override
    public Period getPeriod() {
        if (this.period == null) {
            this.period = new MemoizedSupplier(() -> {
                OffsetDateTime lastModification = Optional.ofNullable(this.contribution.getLastUpdateDate()).map(d -> OffsetDateTime.ofInstant(d.toInstant(), ZoneId.systemDefault())).orElse(null);
                return this.getSpecificPeriod().map(s -> {
                    if (lastModification == null || s.startsAfter((Temporal)lastModification) || s.endsBefore((Temporal)lastModification)) {
                        return s;
                    }
                    return Period.between((Temporal)lastModification, (Temporal)s.getEndDate());
                }).orElseGet(() -> Period.betweenNullable((OffsetDateTime)lastModification, null));
            });
        }
        return (Period)this.period.get();
    }
}

