/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.cmis.model;

import java.util.Set;
import java.util.function.Supplier;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.silverpeas.core.ResourceIdentifier;
import org.silverpeas.core.cmis.model.CmisFile;
import org.silverpeas.core.cmis.model.Fileable;
import org.silverpeas.core.cmis.model.TypeId;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.kernel.util.StringUtil;

public class DocumentFile
extends CmisFile
implements Fileable {
    public static final TypeId CMIS_TYPE = TypeId.SILVERPEAS_DOCUMENT;
    private final ContributionIdentifier id;
    private long size;
    private String mimeType;
    private String title;
    private String lastComment = "";
    private boolean readOnly = false;

    public DocumentFile(ContributionIdentifier id, String fileName, String language) {
        super((ResourceIdentifier)id, fileName, language);
        this.id = id;
    }

    @Override
    public String getSymbol() {
        return "";
    }

    @Override
    public String getName() {
        return super.getName();
    }

    public String getTitle() {
        return this.title;
    }

    public String getApplicationId() {
        return this.id.getComponentInstanceId();
    }

    @Override
    public BaseTypeId getBaseTypeId() {
        return BaseTypeId.CMIS_DOCUMENT;
    }

    @Override
    public TypeId getTypeId() {
        return CMIS_TYPE;
    }

    public String getLastComment() {
        return this.lastComment;
    }

    public long getSize() {
        return this.size;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public DocumentFile setSize(long size) {
        this.size = size;
        return this;
    }

    public DocumentFile setMimeType(String mimeType) {
        this.mimeType = mimeType;
        return this;
    }

    public DocumentFile setTitle(String title) {
        this.title = title;
        return this;
    }

    public DocumentFile setLastComment(String comment) {
        if (StringUtil.isDefined((String)comment)) {
            this.lastComment = comment;
        }
        return this;
    }

    public DocumentFile setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Override
    protected Supplier<Set<Action>> getAllowableActionsSupplier() {
        return () -> this.completeWithDocumentActions(this.completeWithFileActions(this.theCommonActions()));
    }

    private Set<Action> completeWithDocumentActions(Set<Action> actions) {
        actions.add(Action.CAN_GET_ALL_VERSIONS);
        actions.add(Action.CAN_GET_CONTENT_STREAM);
        if (!this.isReadOnly()) {
            actions.add(Action.CAN_SET_CONTENT_STREAM);
        }
        return actions;
    }
}

