/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.chart;

import java.util.ArrayList;
import java.util.List;
import org.silverpeas.core.chart.AbstractChartItem;
import org.silverpeas.core.util.JSONCodec;

public abstract class AbstractAxisChartItem<XAXIS_DATA_TYPE, YAXIS_DATA_TYPE, ITEM_TYPE extends AbstractAxisChartItem<XAXIS_DATA_TYPE, YAXIS_DATA_TYPE, ITEM_TYPE>>
extends AbstractChartItem<ITEM_TYPE> {
    private final XAXIS_DATA_TYPE x;
    private List<YAXIS_DATA_TYPE> yValues = new ArrayList<YAXIS_DATA_TYPE>();

    protected AbstractAxisChartItem(XAXIS_DATA_TYPE x) {
        this.x = x;
    }

    public XAXIS_DATA_TYPE getX() {
        return this.x;
    }

    public List<YAXIS_DATA_TYPE> getYValues() {
        return this.yValues;
    }

    public ITEM_TYPE add(YAXIS_DATA_TYPE y) {
        this.getYValues().add(y);
        return (ITEM_TYPE)this;
    }

    @Override
    protected void completeJsonData(JSONCodec.JSONObject itemAsJson) {
        itemAsJson.putJSONObject("x", jsonObject -> {
            this.performXValue((JSONCodec.JSONObject)jsonObject, this.getX());
            return jsonObject;
        });
        itemAsJson.putJSONArray("y", datasetsAsJson -> {
            for (YAXIS_DATA_TYPE yValue : this.getYValues()) {
                this.performYValue((JSONCodec.JSONArray)datasetsAsJson, yValue);
            }
            return datasetsAsJson;
        });
    }

    protected abstract void performXValue(JSONCodec.JSONObject var1, XAXIS_DATA_TYPE var2);

    protected abstract void performYValue(JSONCodec.JSONArray var1, YAXIS_DATA_TYPE var2);
}

