/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.calendar.notification;

import org.silverpeas.core.admin.component.model.PersonalComponent;
import org.silverpeas.core.admin.component.model.PersonalComponentInstance;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.calendar.Calendar;
import org.silverpeas.core.notification.system.CDIResourceEventListener;
import org.silverpeas.core.persistence.Transaction;
import org.silverpeas.core.personalization.UserPreferences;
import org.silverpeas.core.personalization.notification.UserPreferenceEvent;

@Bean
public class UserPreferenceEventListener
extends CDIResourceEventListener<UserPreferenceEvent> {
    public void onUpdate(UserPreferenceEvent event) {
        UserPreferences previous = (UserPreferences)event.getTransition().getBefore();
        UserPreferences current = (UserPreferences)event.getTransition().getAfter();
        if (!previous.getZoneId().equals(current.getZoneId())) {
            Transaction.performInOne(() -> {
                Calendar.getByComponentInstanceId((String)PersonalComponentInstance.from(current.getUser(), PersonalComponent.getByName("userCalendar").orElse(null)).getId()).forEach(calendar -> {
                    calendar.setZoneId(current.getZoneId());
                    calendar.save();
                });
                return null;
            });
        }
    }
}

