/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.calendar.ical4j;

import java.text.ParseException;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateList;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import net.fortuna.ical4j.model.TimeZoneRegistryFactory;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.calendar.CalendarComponent;
import org.silverpeas.core.date.TemporalConverter;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.annotation.Technical;

@Technical
@Bean
@Singleton
public class ICal4JDateCodec {
    private static final String ICAL_LOCAL_PATTERN = "yyyyMMdd'T'HHmmss";
    private static final String ICAL_UTC_PATTERN = "yyyyMMdd'T'HHmmss'Z'";
    private static final String ICAL_DATE_PATTERN = "yyyyMMdd";

    public boolean isEventDateToBeEncodedIntoUtc(boolean eventRecurrent, CalendarComponent component) {
        return component.getPeriod().isInDays() || !eventRecurrent;
    }

    public Date encode(boolean eventRecurrent, CalendarComponent component, Temporal aTemporal) {
        Temporal temporal = this.isEventDateToBeEncodedIntoUtc(eventRecurrent, component) ? aTemporal : OffsetDateTime.from(aTemporal).atZoneSameInstant(component.getCalendar().getZoneId());
        return this.encode(temporal);
    }

    public Date encode(Temporal aTemporal) {
        return (Date)TemporalConverter.applyByType((Temporal)aTemporal, (TemporalConverter.Conversion[])new TemporalConverter.Conversion[]{this.localDateConversion(), this.offsetDateTimeConversion(), this.zonedDateTimeConversion()});
    }

    public DateList encode(Collection<? extends Temporal> temporals) {
        return temporals.stream().map(this::encode).sorted().collect(Collectors.toCollection(() -> {
            DateList list = new DateList();
            list.setUtc(true);
            return list;
        }));
    }

    public DateTime encode(OffsetDateTime dateTime) {
        try {
            return new DateTime(DateTimeFormatter.ofPattern(ICAL_UTC_PATTERN).format(dateTime.withOffsetSameInstant(ZoneOffset.UTC)));
        }
        catch (ParseException e) {
            throw new SilverpeasRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public DateTime encode(ZonedDateTime dateTime) {
        try {
            return new DateTime(DateTimeFormatter.ofPattern(ICAL_LOCAL_PATTERN).format(dateTime), this.getTimeZone(dateTime));
        }
        catch (ParseException e) {
            throw new SilverpeasRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public Date encode(LocalDate date) {
        try {
            return new Date(DateTimeFormatter.ofPattern(ICAL_DATE_PATTERN).format(date));
        }
        catch (ParseException e) {
            throw new SilverpeasRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public TemporalConverter.Conversion<OffsetDateTime, Date> offsetDateTimeConversion() {
        return TemporalConverter.Conversion.of(OffsetDateTime.class, this::encode);
    }

    public TemporalConverter.Conversion<ZonedDateTime, Date> zonedDateTimeConversion() {
        return TemporalConverter.Conversion.of(ZonedDateTime.class, this::encode);
    }

    public TemporalConverter.Conversion<LocalDate, Date> localDateConversion() {
        return TemporalConverter.Conversion.of(LocalDate.class, this::encode);
    }

    private TimeZone getTimeZone(ZonedDateTime date) {
        return this.getTimeZone(date.getZone());
    }

    public TimeZone getTimeZone(ZoneId zoneId) {
        TimeZoneRegistry registry = TimeZoneRegistryFactory.getInstance().createRegistry();
        return registry.getTimeZone(zoneId.getId());
    }

    public final Temporal decode(Date aDate) {
        if (aDate instanceof DateTime) {
            return OffsetDateTime.ofInstant(aDate.toInstant(), ZoneOffset.UTC);
        }
        return LocalDate.ofInstant(aDate.toInstant(), ZoneOffset.UTC);
    }
}

