/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.user;

import java.util.HashMap;
import java.util.Random;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.silverpeas.core.SilverpeasExceptionMessages;
import org.silverpeas.core.admin.domain.model.Domain;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.service.Administration;
import org.silverpeas.core.admin.user.UserRegistrationService;
import org.silverpeas.core.admin.user.constant.UserAccessLevel;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.admin.user.model.UserFull;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.notification.NotificationException;
import org.silverpeas.core.notification.user.client.NotificationMetaData;
import org.silverpeas.core.notification.user.client.NotificationSender;
import org.silverpeas.core.notification.user.client.UserRecipient;
import org.silverpeas.core.template.SilverpeasTemplate;
import org.silverpeas.core.template.SilverpeasTemplates;
import org.silverpeas.core.ui.DisplayI18NHelper;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@Service
@Singleton
public class UserRegistrationServiceLegacy
implements UserRegistrationService {
    @Inject
    private Administration admin;
    private LocalizationBundle multilang = null;
    private final Random random = new Random();

    @PostConstruct
    void init() {
        this.multilang = ResourceLocator.getLocalizationBundle((String)"org.silverpeas.authentication.multilang.authentication", (String)DisplayI18NHelper.getDefaultLanguage());
    }

    @Override
    public String registerUser(String firstName, String lastName, String email, String domainId) throws AdminException {
        return this.registerUser(firstName, lastName, email, domainId, UserAccessLevel.USER);
    }

    @Override
    public String registerUser(String firstName, String lastName, String email, String domainId, UserAccessLevel accessLevel) throws AdminException {
        String login = this.generateLogin(this.admin, domainId, email);
        if (login == null) {
            throw new AdminException(SilverpeasExceptionMessages.undefined((String)"user login"), new String[0]);
        }
        String password = this.generatePassword();
        UserDetail user = new UserDetail();
        user.setId("-1");
        user.setFirstName(firstName);
        user.setLastName(lastName);
        user.setEmailAddress(email);
        user.setLogin(login);
        user.setDomainId(domainId);
        user.setAccessLevel(accessLevel);
        String userId = this.admin.addUser(user);
        if (!StringUtil.isDefined((String)userId)) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnAdding((String)"user", (Object)(firstName + " " + lastName)), new String[0]);
        }
        UserFull uf = this.admin.getUserFull(userId);
        if (uf != null) {
            uf.setPasswordValid(true);
            uf.setPassword(password);
            userId = this.admin.updateUserFull(uf);
            if (!StringUtil.isDefined((String)userId)) {
                throw new AdminException(SilverpeasExceptionMessages.failureOnAdding((String)"user", (Object)(firstName + " " + lastName)), new String[0]);
            }
            this.sendCredentialsToUser(uf, password, URLUtil.getCurrentServerURL());
        }
        return userId;
    }

    @Override
    public UserDetail findUser(String userId) throws AdminException {
        return this.admin.getUserDetail(userId);
    }

    private String generatePassword() {
        byte[] password = new byte[8];
        for (int i = 0; i < 8; ++i) {
            password[i] = (byte)(65 + this.random.nextInt(26));
        }
        return new String(password);
    }

    private String generateLogin(Administration admin, String domainId, String email) {
        try {
            String userId = admin.getUserIdByLoginAndDomain(email, domainId);
            if (userId == null) {
                return email;
            }
        }
        catch (AdminException e) {
            return email;
        }
        return null;
    }

    private void sendCredentialsToUser(UserFull user, String password, String silverpeasServerURL) {
        try {
            HashMap<String, SilverpeasTemplate> templates = new HashMap<String, SilverpeasTemplate>();
            String subject = this.multilang.getString("registration.credentials.mail.subject");
            NotificationMetaData notifMetaData = new NotificationMetaData(0, subject, templates, "credentialsMail");
            SettingBundle generalLook = ResourceLocator.getSettingBundle((String)"org.silverpeas.lookAndFeel.generalLook");
            String loginPage = generalLook.getString("loginPage", "defaultLogin.jsp");
            StringBuilder url = new StringBuilder();
            if (!loginPage.startsWith("http")) {
                url.append(silverpeasServerURL);
                if (!URLUtil.getApplicationURL().startsWith("/")) {
                    url.append("/");
                }
                url.append(URLUtil.getApplicationURL());
                if (!loginPage.startsWith("/")) {
                    url.append("/");
                }
            }
            url.append(loginPage).append("?DomainId=").append(user.getDomainId());
            Domain svpDomain = this.admin.getDomain(user.getDomainId());
            SilverpeasTemplate template = this.getNewTemplate();
            template.setAttribute("fullName", (Object)user.getDisplayedName());
            template.setAttribute("login", (Object)user.getLogin());
            template.setAttribute("password", (Object)password);
            if (this.admin.getAllDomains().length > 1) {
                template.setAttribute("domain", (Object)svpDomain);
            }
            template.setAttribute("url", (Object)url.toString());
            templates.put(DisplayI18NHelper.getDefaultLanguage(), template);
            notifMetaData.addLanguage(DisplayI18NHelper.getDefaultLanguage(), subject, "");
            notifMetaData.setSender("-1");
            notifMetaData.addUserRecipients(new UserRecipient[]{new UserRecipient(user.getId())});
            this.notifyUser(notifMetaData);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error("cannot send notification for userId={0}", (Object[])new String[]{user.getId()}, (Throwable)e);
        }
    }

    private SilverpeasTemplate getNewTemplate() {
        return SilverpeasTemplates.createSilverpeasTemplateOnCore((String)"socialNetwork");
    }

    private void notifyUser(NotificationMetaData notifMetaData) throws AdminException {
        try {
            NotificationSender notifSender = new NotificationSender(null);
            notifSender.notifyUser(notifMetaData);
        }
        catch (NotificationException e) {
            throw new AdminException("Fail to notify users", e);
        }
    }

    @Override
    public void migrateUserToDomain(UserDetail userDetail, String targetDomainId) throws AdminException {
        this.admin.migrateUser(userDetail, targetDomainId);
    }

    @Override
    public void updateUser(UserDetail userDetail) throws AdminException {
        this.admin.updateUser(userDetail);
    }
}

