/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.service;

import java.lang.annotation.Annotation;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.transaction.Transactional;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.silverpeas.core.SilverpeasExceptionMessages;
import org.silverpeas.core.admin.component.dao.ComponentDAO;
import org.silverpeas.core.admin.component.model.ComponentI18N;
import org.silverpeas.core.admin.component.model.ComponentInst;
import org.silverpeas.core.admin.component.model.ComponentInstLight;
import org.silverpeas.core.admin.component.model.LocalizedParameter;
import org.silverpeas.core.admin.component.model.Parameter;
import org.silverpeas.core.admin.component.model.SilverpeasSharedComponentInstance;
import org.silverpeas.core.admin.component.model.WAComponent;
import org.silverpeas.core.admin.component.notification.ComponentInstanceEventNotifier;
import org.silverpeas.core.admin.persistence.ComponentInstanceI18NRow;
import org.silverpeas.core.admin.persistence.ComponentInstanceRow;
import org.silverpeas.core.admin.persistence.OrganizationSchema;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.user.ProfileInstManager;
import org.silverpeas.core.admin.user.model.ProfileInst;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.i18n.AbstractI18NBean;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.notification.system.ResourceEvent;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.util.ArrayUtil;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.Pair;
import org.silverpeas.kernel.util.StringUtil;

@Service
@Singleton
@Transactional(value=Transactional.TxType.MANDATORY)
public class ComponentInstManager {
    public static final String COMPONENT = "component";
    @Inject
    private ProfileInstManager profileInstManager;
    @Inject
    private ComponentInstanceEventNotifier notifier;
    @Inject
    private OrganizationSchema organizationSchema;

    public static ComponentInstManager get() {
        return (ComponentInstManager)ServiceProvider.getService(ComponentInstManager.class, (Annotation[])new Annotation[0]);
    }

    protected ComponentInstManager() {
    }

    public ComponentInst copy(ComponentInst componentInstToCopy) {
        ComponentInst componentInst = new ComponentInst();
        componentInst.setLocalId(componentInstToCopy.getLocalId());
        componentInst.setName(componentInstToCopy.getName());
        componentInst.setLabel(componentInstToCopy.getLabel());
        componentInst.setDescription(componentInstToCopy.getDescription());
        componentInst.setDomainFatherId(componentInstToCopy.getDomainFatherId());
        componentInst.setOrderNum(componentInstToCopy.getOrderNum());
        componentInst.setCreationDate(componentInstToCopy.getCreationDate());
        componentInst.setLastUpdateDate(componentInstToCopy.getLastUpdateDate());
        componentInst.setRemovalDate(componentInstToCopy.getRemovalDate());
        componentInst.setStatus(componentInstToCopy.getStatus());
        componentInst.setCreatorUserId(componentInstToCopy.getCreatorUserId());
        componentInst.setUpdaterUserId(componentInstToCopy.getUpdaterUserId());
        componentInst.setRemoverUserId(componentInstToCopy.getRemoverUserId());
        for (ProfileInst profile : componentInstToCopy.getAllProfilesInst()) {
            componentInst.addProfileInst(profile);
        }
        List<Parameter> parameters = componentInstToCopy.getParameters();
        componentInst.setParameters(parameters);
        componentInst.setLanguage(componentInstToCopy.getLanguage());
        for (ComponentI18N translation : componentInstToCopy.getTranslations().values()) {
            componentInst.addTranslation(translation);
        }
        componentInst.setPublic(componentInstToCopy.isPublic());
        componentInst.setHidden(componentInstToCopy.isHidden());
        componentInst.setInheritanceBlocked(componentInstToCopy.isInheritanceBlocked());
        return componentInst;
    }

    public void createComponentInst(ComponentInst componentInst, int spaceLocalId) throws AdminException {
        try {
            ComponentInstanceRow newInstance = this.makeComponentInstanceRow(componentInst);
            newInstance.spaceId = spaceLocalId;
            this.organizationSchema.instance().createComponentInstance(newInstance);
            componentInst.setLocalId(newInstance.id);
            Map translations = componentInst.getTranslations();
            for (Map.Entry i18n : translations.entrySet()) {
                if (i18n.getKey().equals(newInstance.lang)) continue;
                ComponentI18N translation = (ComponentI18N)i18n.getValue();
                ComponentInstanceI18NRow row = new ComponentInstanceI18NRow(newInstance.id, i18n.getKey(), translation.getName(), translation.getDescription());
                this.organizationSchema.instanceI18N().createTranslation(row);
            }
            List<Parameter> parameters = componentInst.getParameters();
            if (!parameters.isEmpty()) {
                WAComponent waComponent = ComponentInstManager.getWaComponentFrom(componentInst);
                for (Parameter parameter : parameters) {
                    this.organizationSchema.instanceData().createInstanceData(componentInst.getLocalId(), new LocalizedParameter(waComponent, parameter, I18NHelper.DEFAULT_LANGUAGE));
                }
            }
            for (ProfileInst profile : componentInst.getProfiles()) {
                this.profileInstManager.createProfileInst(profile, componentInst.getLocalId());
            }
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnAdding((String)COMPONENT, (Object)componentInst.getName()), e);
        }
    }

    public void sendComponentToBasket(ComponentInst componentInst, String userId) throws AdminException {
        boolean nameOK = false;
        int retry = 0;
        String deletedComponentName = null;
        while (!nameOK) {
            boolean spaceAlreadyExists;
            String componentName = componentInst.getLabel() + " (Restaur\u00e9)";
            if (retry > 0) {
                componentName = componentName + " " + retry;
            }
            try {
                spaceAlreadyExists = this.organizationSchema.instance().isComponentIntoBasket(this.idAsInt(componentInst.getDomainFatherId()), componentName);
            }
            catch (SQLException e) {
                throw new AdminException(e.getMessage(), e);
            }
            nameOK = !spaceAlreadyExists;
            deletedComponentName = componentName;
            ++retry;
        }
        try {
            this.organizationSchema.instance().sendComponentToBasket(componentInst.getLocalId(), deletedComponentName, userId);
            this.notifier.notifyEventOn(ResourceEvent.Type.REMOVING, new ComponentInst[]{componentInst});
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnMoving((String)COMPONENT, (Object)componentInst.getLocalId(), (String)"bin", (Object)""), e);
        }
    }

    public void restoreComponentFromBasket(int localComponentId) throws AdminException {
        try {
            this.organizationSchema.instance().restoreComponentFromBasket(localComponentId);
            ComponentInst compInstance = this.getComponentInst(localComponentId);
            this.notifier.notifyEventOn(ResourceEvent.Type.RECOVERY, new ComponentInst[]{compInstance});
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnRestoring((String)COMPONENT, (Object)localComponentId), e);
        }
    }

    public ComponentInst getComponentInst(int componentId) throws AdminException {
        ComponentInst componentInst = new ComponentInst();
        componentInst.removeAllProfilesInst();
        try {
            ComponentInstanceRow instance = this.organizationSchema.instance().getComponentInstance(componentId);
            if (instance != null) {
                componentInst.setLocalId(instance.id);
                componentInst.setName(instance.componentName);
                componentInst.setLabel(instance.name);
                componentInst.setDescription(instance.description);
                componentInst.setDomainFatherId(ComponentInstManager.idAsString(instance.spaceId));
                componentInst.setOrderNum(instance.orderNum);
                if (instance.createTime != null) {
                    componentInst.setCreationDate(new Date(Long.parseLong(instance.createTime)));
                }
                if (instance.updateTime != null) {
                    componentInst.setLastUpdateDate(new Date(Long.parseLong(instance.updateTime)));
                }
                if (instance.removeTime != null) {
                    componentInst.setRemovalDate(new Date(Long.parseLong(instance.removeTime)));
                }
                componentInst.setCreatorUserId(ComponentInstManager.idAsString(instance.createdBy));
                componentInst.setUpdaterUserId(ComponentInstManager.idAsString(instance.updatedBy));
                componentInst.setRemoverUserId(ComponentInstManager.idAsString(instance.removedBy));
                componentInst.setStatus(instance.status);
                List<Parameter> parameters = this.organizationSchema.instanceData().getAllParametersInComponent(componentId);
                componentInst.setParameters(parameters);
                String[] asProfileIds = this.organizationSchema.userRole().getAllUserRoleIdsOfInstance(componentInst.getLocalId());
                for (int nI = 0; asProfileIds != null && nI < asProfileIds.length; ++nI) {
                    ProfileInst profileInst = this.profileInstManager.getProfileInst(asProfileIds[nI], false);
                    if (profileInst == null) continue;
                    componentInst.addProfileInst(profileInst);
                }
                componentInst.setLanguage(instance.lang);
                this.loadTranslations(componentInst, instance);
                componentInst.setPublic(instance.publicAccess == 1);
                componentInst.setHidden(instance.hidden == 1);
                componentInst.setInheritanceBlocked(instance.inheritanceBlocked == 1);
            } else {
                SilverLogger.getLogger((Object)this).error("Component instance " + componentId + " not found!", new Object[0]);
            }
        }
        catch (SQLException e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnUpdate((String)COMPONENT, (Object)componentId), e);
        }
        return componentInst;
    }

    public List<ComponentInstLight> getRemovedComponents() throws AdminException {
        try {
            ComponentInstanceRow[] componentRows = this.organizationSchema.instance().getRemovedComponents();
            return this.componentInstanceRows2ComponentInstLights(componentRows);
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"removed components", (Object)""), e);
        }
    }

    public ComponentInstLight getComponentInstLight(int compLocalId) throws AdminException {
        ComponentInstLight compoLight = null;
        try {
            ComponentInstanceRow compo = this.organizationSchema.instance().getComponentInstance(compLocalId);
            if (compo != null) {
                compoLight = new ComponentInstLight(compo);
                compoLight.setLocalId(compLocalId);
                compoLight.setDomainFatherId("WA" + compoLight.getDomainFatherId());
                this.loadTranslations(compoLight, compo);
            }
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)COMPONENT, (Object)compLocalId), e);
        }
        return compoLight;
    }

    public void deleteComponentInst(ComponentInst componentInst) throws AdminException {
        try {
            this.organizationSchema.instanceI18N().removeTranslations(componentInst.getLocalId());
            this.organizationSchema.instance().removeComponentInstance(componentInst.getLocalId());
            this.notifier.notifyEventOn(ResourceEvent.Type.DELETION, new ComponentInst[]{componentInst});
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnDeleting((String)COMPONENT, (Object)componentInst.getLocalId()), e);
        }
    }

    public void updateComponentOrder(int compLocalId, int orderNum) throws AdminException {
        try {
            this.organizationSchema.instance().updateComponentOrder(compLocalId, orderNum);
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnUpdate((String)"order of component", (Object)compLocalId), e);
        }
    }

    public void updateComponentInst(ComponentInst compoInstOld, ComponentInst compoInstNew) throws AdminException {
        try {
            List<Parameter> parameters = compoInstNew.getParameters();
            if (!parameters.isEmpty()) {
                WAComponent waComponent = ComponentInstManager.getWaComponentFrom(compoInstOld);
                for (Parameter parameter : parameters) {
                    this.organizationSchema.instanceData().updateInstanceData(compoInstNew.getLocalId(), new LocalizedParameter(waComponent, parameter, I18NHelper.DEFAULT_LANGUAGE));
                }
            }
            ComponentInstanceRow changedInstance = this.makeComponentInstanceRow(compoInstNew);
            changedInstance.id = compoInstNew.getLocalId();
            ComponentInstanceRow old = this.organizationSchema.instance().getComponentInstance(changedInstance.id);
            if (compoInstNew.isRemoveTranslation()) {
                this.removeTranslation(compoInstNew, changedInstance, old);
            } else {
                this.updateTranslation(compoInstNew, changedInstance, old);
                this.organizationSchema.instance().updateComponentInstance(changedInstance);
                this.notifier.notifyEventOn(ResourceEvent.Type.UPDATE, new ComponentInst[]{compoInstOld, compoInstNew});
            }
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnUpdate((String)COMPONENT, (Object)compoInstNew.getLocalId()), e);
        }
    }

    private static WAComponent getWaComponentFrom(ComponentInst compoInstOld) {
        return WAComponent.getByInstanceId(compoInstOld.getId()).orElseThrow(() -> new IllegalArgumentException(compoInstOld.getId() + " does not correspond to a registered component"));
    }

    private void updateTranslation(ComponentInst compoInstNew, ComponentInstanceRow changedInstance, ComponentInstanceRow old) throws SQLException {
        if (changedInstance.lang != null) {
            old.lang = I18NHelper.checkLanguage(old.lang);
            if (!old.lang.equalsIgnoreCase(changedInstance.lang)) {
                ComponentInstanceI18NRow row = new ComponentInstanceI18NRow(changedInstance);
                String translationId = compoInstNew.getTranslationId();
                if (translationId != null && !"-1".equals(translationId)) {
                    row.id = Integer.parseInt(compoInstNew.getTranslationId());
                    this.organizationSchema.instanceI18N().updateTranslation(row);
                } else {
                    this.organizationSchema.instanceI18N().createTranslation(row);
                }
                changedInstance.lang = old.lang;
                changedInstance.name = old.name;
                changedInstance.description = old.description;
            }
        }
    }

    private void removeTranslation(ComponentInst compoInstNew, ComponentInstanceRow changedInstance, ComponentInstanceRow old) throws SQLException {
        if (old.lang.equalsIgnoreCase(compoInstNew.getLanguage())) {
            List<ComponentInstanceI18NRow> translations = this.organizationSchema.instanceI18N().getTranslations(changedInstance.id);
            if (translations != null && !translations.isEmpty()) {
                ComponentInstanceI18NRow translation = translations.get(0);
                changedInstance.lang = translation.lang;
                changedInstance.name = translation.name;
                changedInstance.description = translation.description;
                this.organizationSchema.instance().updateComponentInstance(changedInstance);
                this.organizationSchema.instanceI18N().removeTranslation(translation.id);
            }
        } else {
            this.organizationSchema.instanceI18N().removeTranslation(Integer.parseInt(compoInstNew.getTranslationId()));
        }
    }

    public void moveComponentInst(int spaceLocalId, int componentLocalId) throws AdminException {
        try {
            this.organizationSchema.instance().moveComponentInstance(spaceLocalId, componentLocalId);
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnMoving((String)COMPONENT, (Object)componentLocalId, (String)"space", (Object)spaceLocalId), e);
        }
    }

    public String[] getAllCompoIdsByComponentName(String sComponentName) throws AdminException {
        try {
            ComponentInstanceRow cir = new ComponentInstanceRow();
            cir.name = null;
            cir.description = null;
            cir.orderNum = -1;
            cir.componentName = sComponentName;
            ComponentInstanceRow[] cirs = this.organizationSchema.instance().getAllMatchingComponentInstances(cir);
            if (cirs == null) {
                return ArrayUtil.emptyStringArray();
            }
            String[] compoIds = new String[cirs.length];
            for (int nI = 0; nI < cirs.length; ++nI) {
                compoIds[nI] = ComponentInstManager.idAsString(cirs[nI].id);
            }
            return compoIds;
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"instances of component", (Object)sComponentName), e);
        }
    }

    public List<String> getAllActiveComponentIds() throws AdminException {
        try {
            return ComponentDAO.getAllActiveComponentIds();
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"all components", (Object)"of platform!!!"), e);
        }
    }

    public List<ComponentInstLight> getComponentsInSpace(int spaceId) throws AdminException {
        Connection con = null;
        try {
            con = DBUtil.openConnection();
            List<ComponentInstLight> componentsInSpace = ComponentDAO.getComponentsInSpace(con, spaceId);
            this.setTranslations(con, componentsInSpace);
            List<ComponentInstLight> list = componentsInSpace;
            return list;
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"component instances in space", (Object)spaceId), e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    private void loadTranslations(SilverpeasSharedComponentInstance instance, ComponentInstanceRow compo) throws SQLException {
        ComponentI18N translation = new ComponentI18N(compo.lang, compo.name, compo.description);
        AbstractI18NBean i18nInstance = (AbstractI18NBean)instance;
        i18nInstance.addTranslation(translation);
        List<ComponentInstanceI18NRow> translations = this.organizationSchema.instanceI18N().getTranslations(compo.id);
        for (int i = 0; translations != null && i < translations.size(); ++i) {
            ComponentInstanceI18NRow row = translations.get(i);
            i18nInstance.addTranslation(new ComponentI18N(row));
        }
    }

    private <T extends SilverpeasSharedComponentInstance> void setTranslations(Connection con, Collection<T> instances) throws AdminException {
        if (!instances.isEmpty()) {
            long startTime = System.currentTimeMillis();
            HashMap instancesByLocalIds = new HashMap(instances.size());
            Map<Integer, AbstractI18NBean> i18nInstancesByLocalIds = instances.stream().map(i -> {
                int localId = i instanceof ComponentInstLight ? ((ComponentInstLight)i).getLocalId() : ((ComponentInst)i).getLocalId();
                instancesByLocalIds.put(localId, i);
                return Pair.of((Object)localId, (Object)((AbstractI18NBean)i));
            }).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
            try {
                Map<Integer, List<ComponentInstanceI18NRow>> allTranslations = this.organizationSchema.instanceI18N().getIndexedTranslations(con, i18nInstancesByLocalIds.keySet());
                i18nInstancesByLocalIds.forEach((localId, i18nInstance) -> {
                    SilverpeasSharedComponentInstance instance = (SilverpeasSharedComponentInstance)instancesByLocalIds.get(localId);
                    ComponentI18N translation = new ComponentI18N(i18nInstance.getLanguage(), instance.getLabel(), instance.getDescription());
                    i18nInstance.addTranslation(translation);
                    allTranslations.getOrDefault(localId, Collections.emptyList()).forEach(r -> i18nInstance.addTranslation(new ComponentI18N((ComponentInstanceI18NRow)r)));
                });
            }
            catch (SQLException e) {
                throw new AdminException(e);
            }
            finally {
                long endTime = System.currentTimeMillis();
                SilverLogger.getLogger((Object)this).debug(() -> MessageFormat.format(" search translations in {0} for {1} component instances", DurationFormatUtils.formatDurationHMS((long)(endTime - startTime)), instances.size()));
            }
        }
    }

    public List<String> getAllowedComponentIds(int userId, List<String> groupIds) throws AdminException {
        return this.getAllowedComponentIds(userId, groupIds, null);
    }

    public List<String> getAllowedComponentIds(int userId, List<String> groupIds, Integer spaceLocalId) throws AdminException {
        return this.getAllowedComponentIds(userId, groupIds, spaceLocalId, null);
    }

    public List<String> getAllowedComponentIds(int userId, List<String> groupIds, Integer spaceLocalId, String componentName) throws AdminException {
        Connection con = null;
        try {
            con = DBUtil.openConnection();
            if (spaceLocalId != null) {
                List<String> list = ComponentDAO.getAvailableComponentIdsInSpace(con, groupIds, userId, spaceLocalId, componentName);
                return list;
            }
            List<String> list = ComponentDAO.getAllAvailableComponentIds(con, groupIds, userId, componentName);
            return list;
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)("component instances of component " + componentName), (Object)(" accessible to user " + userId)), e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    public List<Parameter> getParameters(int compLocalId) throws AdminException {
        try {
            return this.organizationSchema.instanceData().getAllParametersInComponent(compLocalId);
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"parameters of component", (Object)compLocalId), e);
        }
    }

    public String getParameterValueByComponentAndParamName(Integer componentId, String paramName, boolean ignoreCase) throws AdminException {
        try {
            return this.organizationSchema.instanceData().getParameterValueByComponentAndParamName(componentId, paramName, ignoreCase);
        }
        catch (Exception e) {
            throw new AdminException(MessageFormat.format("Can''t get parameter value of parameter {0} on instance {1}", String.valueOf(componentId), paramName), e);
        }
    }

    public Map<Integer, Map<String, String>> getParameterValuesByComponentIdThenByParamName(Collection<Integer> componentIds, Collection<String> paramNames) throws AdminException {
        try {
            return this.organizationSchema.instanceData().getParameterValuesByComponentAndByParamName(componentIds, paramNames);
        }
        catch (Exception e) {
            throw new AdminException("Can't get parameter values...", e);
        }
    }

    public List<Integer> getComponentIds(Parameter parameter) throws AdminException {
        try {
            return this.organizationSchema.instanceData().getComponentIdsWithParameterValue(parameter);
        }
        catch (Exception e) {
            throw new AdminException("Can't get components with parameter '" + parameter.getName() + "' = '" + parameter.getValue() + "'", e);
        }
    }

    private ComponentInstanceRow makeComponentInstanceRow(ComponentInst componentInst) {
        ComponentInstanceRow instance = new ComponentInstanceRow();
        instance.id = componentInst.getLocalId();
        instance.componentName = componentInst.getName();
        instance.name = componentInst.getLabel();
        instance.description = componentInst.getDescription();
        instance.orderNum = componentInst.getOrderNum();
        instance.lang = componentInst.getLanguage();
        instance.createdBy = this.idAsInt(componentInst.getCreatorUserId());
        instance.updatedBy = this.idAsInt(componentInst.getUpdaterUserId());
        instance.publicAccess = componentInst.isPublic() ? 1 : 0;
        instance.hidden = componentInst.isHidden() ? 1 : 0;
        instance.inheritanceBlocked = componentInst.isInheritanceBlocked() ? 1 : 0;
        return instance;
    }

    private List<ComponentInstLight> componentInstanceRows2ComponentInstLights(ComponentInstanceRow[] rows) {
        ArrayList<ComponentInstLight> components = new ArrayList<ComponentInstLight>();
        for (int s = 0; rows != null && s < rows.length; ++s) {
            ComponentInstLight componentLight = new ComponentInstLight(rows[s]);
            componentLight.setDomainFatherId("WA" + componentLight.getDomainFatherId());
            components.add(componentLight);
        }
        return components;
    }

    private int idAsInt(String id) {
        return StringUtil.asInt((String)id, (int)-1);
    }

    private static String idAsString(int id) {
        return Integer.toString(id);
    }
}

