/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.persistence;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.silverpeas.core.SilverpeasExceptionMessages;
import org.silverpeas.core.admin.domain.synchro.SynchroDomainReport;
import org.silverpeas.core.admin.persistence.OrganizationSchema;
import org.silverpeas.core.admin.persistence.SpaceRow;
import org.silverpeas.core.admin.persistence.SpaceUserRoleRow;
import org.silverpeas.core.admin.persistence.Table;
import org.silverpeas.core.annotation.Repository;

@Repository
public class SpaceUserRoleTable
extends Table<SpaceUserRoleRow> {
    public static final String REQUEST_MSG = ", requ\u00eate : ";
    private static final String SPACEUSERROLE_COLUMNS = "id,spaceId,name,RoleName,description,isInherited";
    public static final String SELECT = "select ";
    private static final String SELECT_SPACEUSERROLE_BY_ID = "select id,spaceId,name,RoleName,description,isInherited from ST_SpaceUserRole where id = ?";
    private static final String SELECT_SPACEUSERROLE_BY_ROLENAME = "select id,spaceId,name,RoleName,description,isInherited from ST_SpaceUserRole where spaceId = ? and isInherited = ? and rolename = ?";
    private static final String SELECT_ALL_SPACEUSERROLES = "select id,spaceId,name,RoleName,description,isInherited from ST_SpaceUserRole";
    private static final String SELECT_ALL_SPACE_USERROLES = "select id,spaceId,name,RoleName,description,isInherited from ST_SpaceUserRole where spaceId = ?";
    private static final String SELECT_ALL_SPACE_USERROLE_IDS = "select id from ST_SpaceUserRole where spaceId = ?";
    private static final String SELECT_USER_SPACEUSERROLES = "select id,spaceId,name,RoleName,description,isInherited from ST_SpaceUserRole, ST_SpaceUserRole_User_Rel where id = spaceUserRoleId and   userId = ?";
    private static final String SELECT_GROUP_SPACEUSERROLES = "select id,spaceId,name,RoleName,description,isInherited from ST_SpaceUserRole, ST_SpaceUserRole_Group_Rel where id = spaceUserRoleId and   groupId = ?";
    private static final String INSERT_SPACEUSERROLE = "insert into ST_SpaceUserRole(id,spaceId,name,RoleName,description,isInherited) values (?, ?, ?, ?, ?, ?)";
    private static final String UPDATE_SPACEUSERROLE = "update ST_SpaceUserRole set name = ?, description = ? where id = ?";
    private static final String DELETE_SPACEUSERROLE = "delete from ST_SpaceUserRole where id = ?";
    private static final String SELECT_COUNT_SPACEUSERROLE_USER_REL = "select count(*) from ST_SpaceUserRole_User_Rel where userId = ? and spaceUserRoleId = ?";
    private static final String INSERT_A_SPACEUSERROLE_USER_REL = "insert into ST_SpaceUserRole_User_Rel(spaceUserRoleId, userId) values(?,?)";
    private static final String DELETE_SPACEUSERROLE_USER_REL = "delete from ST_SpaceUserRole_User_Rel where spaceUserRoleId = ? and userId = ?";
    private static final String DELETE_ALL_USERS_FROM_SPACEUSERROLE = "delete from ST_SpaceUserRole_User_Rel where spaceUserRoleId = ? ";
    private static final String SELECT_COUNT_SPACEUSERROLE_GROUP_REL = "select count(*) from ST_SpaceUserRole_Group_Rel where groupId = ? and spaceUserRoleId = ?";
    private static final String INSERT_A_SPACEUSERROLE_GROUP_REL = "insert into ST_SpaceUserRole_Group_Rel(spaceUserRoleId, groupId) values(?,?)";
    private static final String DELETE_SPACEUSERROLE_GROUP_REL = "delete from ST_SpaceUserRole_Group_Rel where spaceUserRoleId = ? and groupId = ?";
    private static final String DELETE_ALL_GROUPS_FROM_SPACEUSERROLE = "delete from ST_SpaceUserRole_Group_Rel where spaceUserRoleId = ?";

    SpaceUserRoleTable() {
        super("ST_SpaceUserRole");
    }

    public SpaceUserRoleRow getSpaceUserRole(int id) throws SQLException {
        return (SpaceUserRoleRow)this.getUniqueRow(SELECT_SPACEUSERROLE_BY_ID, id);
    }

    public SpaceUserRoleRow getSpaceUserRole(int spaceId, String roleName, int inherited) throws SQLException {
        ArrayList<Object> params = new ArrayList<Object>(3);
        params.add(spaceId);
        params.add(inherited);
        params.add(roleName);
        List spaceUserRoles = this.getRows(SELECT_SPACEUSERROLE_BY_ROLENAME, params);
        if (spaceUserRoles.isEmpty()) {
            return null;
        }
        if (spaceUserRoles.size() == 1) {
            return (SpaceUserRoleRow)spaceUserRoles.get(0);
        }
        throw new SQLException(SilverpeasExceptionMessages.failureOnGetting((String)("user role " + roleName), (Object)("for space " + spaceId)));
    }

    public SpaceUserRoleRow[] getAllSpaceUserRoles() throws SQLException {
        List rows = this.getRows(SELECT_ALL_SPACEUSERROLES);
        return rows.toArray(new SpaceUserRoleRow[0]);
    }

    public SpaceUserRoleRow[] getAllSpaceUserRolesOfSpace(int spaceId) throws SQLException {
        List rows = this.getRows(SELECT_ALL_SPACE_USERROLES, spaceId);
        return rows.toArray(new SpaceUserRoleRow[0]);
    }

    public String[] getAllSpaceUserRoleIdsOfSpace(int spaceId) throws SQLException {
        List<String> ids = this.getIds(SELECT_ALL_SPACE_USERROLE_IDS, spaceId);
        return ids.toArray(new String[0]);
    }

    public SpaceUserRoleRow[] getDirectSpaceUserRolesOfUser(int userId) throws SQLException {
        List rows = this.getRows(SELECT_USER_SPACEUSERROLES, userId);
        return rows.toArray(new SpaceUserRoleRow[0]);
    }

    public SpaceUserRoleRow[] getDirectSpaceUserRolesOfGroup(int groupId) throws SQLException {
        List rows = this.getRows(SELECT_GROUP_SPACEUSERROLES, groupId);
        return rows.toArray(new SpaceUserRoleRow[0]);
    }

    public SpaceUserRoleRow[] getAllMatchingSpaceUserRoles(SpaceUserRoleRow sampleSpaceUserRole) throws SQLException {
        String[] columns = new String[]{"name", "description"};
        String[] values = new String[]{sampleSpaceUserRole.getName(), sampleSpaceUserRole.getDescription()};
        List rows = this.getMatchingRows(SPACEUSERROLE_COLUMNS, columns, values);
        return rows.toArray(new SpaceUserRoleRow[0]);
    }

    public void createSpaceUserRole(SpaceUserRoleRow spaceUserRole) throws SQLException {
        SpaceRow space = OrganizationSchema.get().space().getSpace(spaceUserRole.getSpaceId());
        if (space == null) {
            throw new SQLException(SilverpeasExceptionMessages.unknown((String)"space", (Object)String.valueOf(spaceUserRole.getSpaceId())));
        }
        this.insertRow(INSERT_SPACEUSERROLE, spaceUserRole);
    }

    protected void prepareInsert(String insertQuery, PreparedStatement insert, SpaceUserRoleRow row) throws SQLException {
        if (!row.isIdDefined()) {
            row.setId(this.getNextId());
        }
        insert.setInt(1, row.getId());
        insert.setInt(2, row.getSpaceId());
        insert.setString(3, this.truncate(row.getName(), 100));
        insert.setString(4, this.truncate(row.getRoleName(), 100));
        insert.setString(5, this.truncate(row.getDescription(), 500));
        insert.setInt(6, row.getInheritance());
    }

    public void updateSpaceUserRole(SpaceUserRoleRow spaceUserRole) throws SQLException {
        this.updateRow(UPDATE_SPACEUSERROLE, spaceUserRole);
    }

    protected void prepareUpdate(String updateQuery, PreparedStatement update, SpaceUserRoleRow row) throws SQLException {
        update.setString(1, this.truncate(row.getName(), 100));
        update.setString(2, this.truncate(row.getDescription(), 500));
        update.setInt(3, row.getId());
    }

    public void removeSpaceUserRole(int id) throws SQLException {
        SpaceUserRoleRow spaceUserRole = this.getSpaceUserRole(id);
        if (spaceUserRole == null) {
            return;
        }
        this.removeAllUsersFromSpaceUserRole(id);
        this.removeAllGroupsFromSpaceUserRole(id);
        this.updateRelation(DELETE_SPACEUSERROLE, id);
    }

    public boolean isUserDirectlyInRole(int userId, int spaceUserRoleId) throws SQLException {
        int[] ids = new int[]{userId, spaceUserRoleId};
        Integer result = this.getInteger(SELECT_COUNT_SPACEUSERROLE_USER_REL, ids);
        return result != null && result >= 1;
    }

    public void addUserInSpaceUserRole(int userId, int spaceUserRoleId) throws SQLException {
        if (this.isUserDirectlyInRole(userId, spaceUserRoleId)) {
            return;
        }
        this.checkUserExistence(userId);
        SpaceUserRoleRow spaceUserRole = this.getSpaceUserRole(spaceUserRoleId);
        if (spaceUserRole == null) {
            throw new SQLException(SilverpeasExceptionMessages.unknown((String)"space role", (Object)String.valueOf(spaceUserRoleId)));
        }
        int[] params = new int[]{spaceUserRoleId, userId};
        this.updateRelation(INSERT_A_SPACEUSERROLE_USER_REL, params);
    }

    public void removeUserFromSpaceUserRole(int userId, int spaceUserRoleId) throws SQLException {
        if (!this.isUserDirectlyInRole(userId, spaceUserRoleId)) {
            throw new SQLException("user " + userId + " isn't in role " + spaceUserRoleId);
        }
        int[] params = new int[]{spaceUserRoleId, userId};
        SynchroDomainReport.debug("SpaceUserRoleTable.removeUserFromSpaceUserRole()", "Retrait de l'utilisateur d'ID " + userId + " de role d'espace d'ID " + spaceUserRoleId + ", requ\u00eate : delete from ST_SpaceUserRole_User_Rel where spaceUserRoleId = ? and userId = ?");
        this.updateRelation(DELETE_SPACEUSERROLE_USER_REL, params);
    }

    public void removeAllUsersFromSpaceUserRole(int spaceUserRoleId) throws SQLException {
        SynchroDomainReport.debug("SpaceUserRoleTable.removeAllUsersFromSpaceUserRole()", "Retrait des utilisateurs du role d'espace d'ID " + spaceUserRoleId + ", requ\u00eate : delete from ST_SpaceUserRole_User_Rel where spaceUserRoleId = ? and userId = ?");
        this.updateRelation(DELETE_ALL_USERS_FROM_SPACEUSERROLE, spaceUserRoleId);
    }

    public boolean isGroupDirectlyInRole(int groupId, int spaceUserRoleId) throws SQLException {
        int[] ids = new int[]{groupId, spaceUserRoleId};
        Integer result = this.getInteger(SELECT_COUNT_SPACEUSERROLE_GROUP_REL, ids);
        return result != null && result >= 1;
    }

    public void addGroupInSpaceUserRole(int groupId, int spaceUserRoleId) throws SQLException {
        if (this.isGroupDirectlyInRole(groupId, spaceUserRoleId)) {
            return;
        }
        this.checkGroupExistence(groupId);
        SpaceUserRoleRow spaceUserRole = this.getSpaceUserRole(spaceUserRoleId);
        if (spaceUserRole == null) {
            throw new SQLException(SilverpeasExceptionMessages.unknown((String)"space role", (Object)String.valueOf(spaceUserRoleId)));
        }
        int[] params = new int[]{spaceUserRoleId, groupId};
        this.updateRelation(INSERT_A_SPACEUSERROLE_GROUP_REL, params);
    }

    public void removeGroupFromSpaceUserRole(int groupId, int spaceUserRoleId) throws SQLException {
        if (!this.isGroupDirectlyInRole(groupId, spaceUserRoleId)) {
            throw new SQLException("group " + groupId + " isn't in role " + spaceUserRoleId);
        }
        int[] params = new int[]{spaceUserRoleId, groupId};
        SynchroDomainReport.debug("SpaceUserRoleTable.removeGroupFromSpaceUserRole()", "Retrait du groupe d'ID " + groupId + " de l'espace d'ID " + spaceUserRoleId + ", requ\u00eate : delete from ST_SpaceUserRole_Group_Rel where spaceUserRoleId = ? and groupId = ?");
        this.updateRelation(DELETE_SPACEUSERROLE_GROUP_REL, params);
    }

    public void removeAllGroupsFromSpaceUserRole(int spaceUserRoleId) throws SQLException {
        SynchroDomainReport.debug("SpaceUserRoleTable.removeAllGroupsFromSpaceUserRole()", "Retrait des groupes du r\u00f4le de l'espace d'ID " + spaceUserRoleId + ", requ\u00eate : delete from ST_SpaceUserRole_Group_Rel where spaceUserRoleId = ? and groupId = ?");
        this.updateRelation(DELETE_ALL_GROUPS_FROM_SPACEUSERROLE, spaceUserRoleId);
    }

    protected SpaceUserRoleRow fetchRow(ResultSet rs) throws SQLException {
        return SpaceUserRoleRow.fetch(rs);
    }
}

