/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.persistence;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.silverpeas.core.SilverpeasExceptionMessages;
import org.silverpeas.core.admin.persistence.ComponentInstanceRow;
import org.silverpeas.core.admin.persistence.ComponentInstanceTable;
import org.silverpeas.core.admin.persistence.OrganizationSchema;
import org.silverpeas.core.admin.persistence.SpaceRow;
import org.silverpeas.core.admin.persistence.Table;
import org.silverpeas.core.admin.space.UserFavoriteSpaceService;
import org.silverpeas.core.admin.space.UserFavoriteSpaceServiceProvider;
import org.silverpeas.core.admin.space.model.UserFavoriteSpaceVO;
import org.silverpeas.core.annotation.Repository;
import org.silverpeas.core.persistence.jdbc.DBUtil;

@Repository
public class SpaceTable
extends Table<SpaceRow> {
    private static final String SPACE_COLUMNS = "id,domainFatherId,name,description,createdBy,firstPageType,firstPageExtraParam,orderNum,createTime,updateTime,removeTime,spaceStatus,updatedBy,removedBy,lang,isInheritanceBlocked,look,displaySpaceFirst,isPersonal";
    public static final String SELECT = "select ";
    private static final String SELECT_SPACE_BY_ID = "select id,domainFatherId,name,description,createdBy,firstPageType,firstPageExtraParam,orderNum,createTime,updateTime,removeTime,spaceStatus,updatedBy,removedBy,lang,isInheritanceBlocked,look,displaySpaceFirst,isPersonal from ST_Space where id = ?";
    private static final String SELECT_PERSONALSPACE = "select id,domainFatherId,name,description,createdBy,firstPageType,firstPageExtraParam,orderNum,createTime,updateTime,removeTime,spaceStatus,updatedBy,removedBy,lang,isInheritanceBlocked,look,displaySpaceFirst,isPersonal from ST_Space where isPersonal = ? and createdBy = ? ";
    private static final String SELECT_ALL_SPACES = "select id,domainFatherId,name,description,createdBy,firstPageType,firstPageExtraParam,orderNum,createTime,updateTime,removeTime,spaceStatus,updatedBy,removedBy,lang,isInheritanceBlocked,look,displaySpaceFirst,isPersonal from ST_Space order by orderNum";
    private static final String SELECT_ALL_SPACE_IDS = "select id from ST_Space order by orderNum";
    private static final String SELECT_ALL_ROOT_SPACE_IDS = "SELECT id FROM st_space WHERE domainFatherId IS NULL AND spaceStatus IS NULL AND isPersonal IS NULL ORDER BY orderNum";
    private static final String SELECT_REMOVED_SPACES = "select id,domainFatherId,name,description,createdBy,firstPageType,firstPageExtraParam,orderNum,createTime,updateTime,removeTime,spaceStatus,updatedBy,removedBy,lang,isInheritanceBlocked,look,displaySpaceFirst,isPersonal from ST_Space where spaceStatus = 'R' order by removeTime desc";
    private static final String SELECT_SUBSPACE_IDS = "select id from ST_Space where domainFatherId = ? and spaceStatus is null order by orderNum";
    private static final String SELECT_SUBSPACES = "select id,domainFatherId,name,description,createdBy,firstPageType,firstPageExtraParam,orderNum,createTime,updateTime,removeTime,spaceStatus,updatedBy,removedBy,lang,isInheritanceBlocked,look,displaySpaceFirst,isPersonal from ST_Space where domainFatherId = ? and spaceStatus is null order by orderNum";
    private static final String INSERT_SPACE = "insert into ST_Space(id,domainFatherId,name,description,createdBy,firstPageType,firstPageExtraParam,orderNum,createTime,updateTime,removeTime,spaceStatus,updatedBy,removedBy,lang,isInheritanceBlocked,look,displaySpaceFirst,isPersonal) values  (? ,? ,? ,? ,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String UPDATE_SPACE_ORDER = "update ST_Space set orderNum = ? where id = ?";
    private static final String UPDATE_SPACE = "update ST_Space set domainFatherId = ?, name = ?, description = ?, createdBy = ?, firstPageType = ?, firstPageExtraParam = ?, orderNum = ?, updateTime = ?, updatedBy = ?, spaceStatus = ?, lang = ?, isInheritanceBlocked = ?, look = ?, displaySpaceFirst = ?, isPersonal = ?  where id = ?";
    private static final String MOVE_SPACE = "update ST_SPACE set domainFatherId = ? where id = ?";
    private static final String DELETE_SPACE = "delete from ST_Space where id = ?";
    private static final String SEND_SPACE_IN_BASKET = "update ST_Space set name = ?, removedBy = ?, removeTime = ?, spaceStatus = ? where id = ?";
    private static final String IS_SPACE_INTO_BASKET = "select * from ST_Space where name = ? and domainFatherId = ? and spaceStatus = ? ";
    private static final String REMOVE_SPACE_FROM_BASKET = "update ST_Space set removedBy = ?, removeTime = ?, spaceStatus = ? where id = ?";
    private static final String SELECT_SPACEUSERROLE_SPACE = "select " + SpaceTable.aliasColumns("i", "id,domainFatherId,name,description,createdBy,firstPageType,firstPageExtraParam,orderNum,createTime,updateTime,removeTime,spaceStatus,updatedBy,removedBy,lang,isInheritanceBlocked,look,displaySpaceFirst,isPersonal") + " from ST_Space i, ST_SpaceUserRole us where i.id = us.spaceId and   us.id = ?";

    SpaceTable() {
        super("ST_Space");
    }

    protected SpaceRow fetchSpace(ResultSet rs) throws SQLException {
        SpaceRow s = new SpaceRow();
        s.id = rs.getInt(1);
        s.domainFatherId = rs.getInt(2);
        s.name = rs.getString(3);
        s.description = rs.getString(4);
        s.createdBy = rs.getInt(5);
        if (rs.wasNull()) {
            s.createdBy = -1;
        }
        s.firstPageType = rs.getInt(6);
        s.firstPageExtraParam = rs.getString(7);
        s.orderNum = rs.getInt(8);
        if (rs.wasNull()) {
            s.orderNum = -1;
        }
        s.createTime = rs.getString(9);
        s.updateTime = rs.getString(10);
        s.removeTime = rs.getString(11);
        s.status = rs.getString(12);
        s.updatedBy = rs.getInt(13);
        if (rs.wasNull()) {
            s.updatedBy = -1;
        }
        s.removedBy = rs.getInt(14);
        if (rs.wasNull()) {
            s.removedBy = -1;
        }
        s.lang = rs.getString(15);
        s.inheritanceBlocked = rs.getInt(16);
        s.look = rs.getString(17);
        s.displaySpaceFirst = rs.getInt(18);
        if (rs.wasNull()) {
            s.displaySpaceFirst = 1;
        }
        s.isPersonalSpace = rs.getInt(19);
        if (rs.wasNull()) {
            s.isPersonalSpace = 0;
        }
        return s;
    }

    public SpaceRow getSpace(int id) throws SQLException {
        return (SpaceRow)this.getUniqueRow(SELECT_SPACE_BY_ID, id);
    }

    public SpaceRow getPersonalSpace(String userId) throws SQLException {
        ArrayList<Integer> params = new ArrayList<Integer>(2);
        params.add(1);
        params.add(Integer.valueOf(userId));
        List rows = this.getRows(SELECT_PERSONALSPACE, params);
        if (rows != null && !rows.isEmpty()) {
            return (SpaceRow)rows.get(0);
        }
        return null;
    }

    public boolean isSpaceInstExist(int id) throws SQLException {
        return this.getSpace(id) != null;
    }

    public SpaceRow[] getAllSpaces() throws SQLException {
        List rows = this.getRows(SELECT_ALL_SPACES);
        return rows.toArray(new SpaceRow[rows.size()]);
    }

    public String[] getAllSpaceIds() throws SQLException {
        List<String> ids = this.getIds(SELECT_ALL_SPACE_IDS);
        return ids.toArray(new String[ids.size()]);
    }

    public String[] getAllRootSpaceIds() throws SQLException {
        List<String> ids = this.getIds(SELECT_ALL_ROOT_SPACE_IDS);
        return ids.toArray(new String[ids.size()]);
    }

    public SpaceRow[] getRemovedSpaces() throws SQLException {
        List rows = this.getRows(SELECT_REMOVED_SPACES);
        return rows.toArray(new SpaceRow[rows.size()]);
    }

    public String[] getDirectSubSpaceIds(int superSpaceId) throws SQLException {
        List<String> ids = this.getIds(SELECT_SUBSPACE_IDS, superSpaceId);
        return ids.toArray(new String[ids.size()]);
    }

    public List<SpaceRow> getDirectSubSpaces(int superSpaceId) throws SQLException {
        return this.getRows(SELECT_SUBSPACES, superSpaceId);
    }

    public void createSpace(SpaceRow space) throws SQLException {
        SpaceRow superSpace;
        if (space.domainFatherId != -1 && (superSpace = this.getSpace(space.domainFatherId)) == null) {
            throw new SQLException(SilverpeasExceptionMessages.unknown((String)"parent space", (Object)String.valueOf(space.domainFatherId)));
        }
        this.insertRow(INSERT_SPACE, space);
    }

    protected void prepareInsert(String insertQuery, PreparedStatement insert, SpaceRow row) throws SQLException {
        if (row.id == -1) {
            row.id = this.getNextId();
        }
        insert.setInt(1, row.id);
        if (row.domainFatherId == -1) {
            insert.setNull(2, 4);
        } else {
            insert.setInt(2, row.domainFatherId);
        }
        insert.setString(3, this.truncate(row.name, 100));
        insert.setString(4, this.truncate(row.description, 500));
        if (row.createdBy == -1) {
            insert.setNull(5, 4);
        } else {
            insert.setInt(5, row.createdBy);
        }
        insert.setInt(6, row.firstPageType);
        insert.setString(7, row.firstPageExtraParam);
        insert.setInt(8, row.orderNum);
        insert.setString(9, String.valueOf(new Date().getTime()));
        insert.setString(10, null);
        insert.setString(11, null);
        insert.setString(12, row.status);
        insert.setNull(13, 4);
        insert.setNull(14, 4);
        insert.setString(15, row.lang);
        insert.setInt(16, row.inheritanceBlocked);
        insert.setString(17, row.look);
        insert.setInt(18, row.displaySpaceFirst);
        if (row.isPersonalSpace == 1) {
            insert.setInt(19, row.isPersonalSpace);
        } else {
            insert.setNull(19, 5);
        }
    }

    public void updateSpaceOrder(int spaceId, int orderNum) throws SQLException {
        int[] values = new int[]{orderNum, spaceId};
        this.updateRelation(UPDATE_SPACE_ORDER, values);
    }

    public void updateSpace(SpaceRow space) throws SQLException {
        this.updateRow(UPDATE_SPACE, space);
    }

    protected void prepareUpdate(String updateQuery, PreparedStatement update, SpaceRow row) throws SQLException {
        if (row.domainFatherId == 0) {
            update.setNull(1, 4);
        } else {
            update.setInt(1, row.domainFatherId);
        }
        update.setString(2, this.truncate(row.name, 100));
        update.setString(3, this.truncate(row.description, 500));
        if (row.createdBy == -1) {
            update.setNull(4, 4);
        } else {
            update.setInt(4, row.createdBy);
        }
        update.setInt(5, row.firstPageType);
        update.setString(6, row.firstPageExtraParam);
        update.setInt(7, row.orderNum);
        update.setString(8, String.valueOf(new Date().getTime()));
        if (row.updatedBy == -1) {
            update.setNull(9, 4);
        } else {
            update.setInt(9, row.updatedBy);
        }
        update.setString(10, row.status);
        update.setString(11, row.lang);
        update.setInt(12, row.inheritanceBlocked);
        update.setString(13, row.look);
        update.setInt(14, row.displaySpaceFirst);
        if (row.isPersonalSpace == 1) {
            update.setInt(15, row.isPersonalSpace);
        } else {
            update.setNull(15, 5);
        }
        update.setInt(16, row.id);
    }

    public void moveSpace(int spaceId, int fatherId) throws SQLException {
        int[] params = new int[]{fatherId, spaceId};
        this.updateRelation(MOVE_SPACE, params);
    }

    public void removeSpace(int id) throws SQLException {
        ComponentInstanceRow[] instances;
        SpaceRow space = this.getSpace(id);
        if (space == null) {
            return;
        }
        ComponentInstanceTable instanceTable = OrganizationSchema.get().instance();
        for (ComponentInstanceRow instance : instances = instanceTable.getAllComponentInstancesInSpace(id)) {
            instanceTable.removeComponentInstance(instance.id);
        }
        UserFavoriteSpaceService ufsDAO = UserFavoriteSpaceServiceProvider.getUserFavoriteSpaceService();
        if (!ufsDAO.removeUserFavoriteSpace(new UserFavoriteSpaceVO(-1, id))) {
            throw new SQLException(SilverpeasExceptionMessages.failureOnDeleting((String)"space", (Object)String.valueOf(id)));
        }
        this.updateRelation(DELETE_SPACE, id);
    }

    public void sendSpaceToBasket(int id, String newName, String userId) throws SQLException {
        try (Connection connection = DBUtil.openConnection();
             PreparedStatement statement = connection.prepareStatement(SEND_SPACE_IN_BASKET);){
            statement.setString(1, newName);
            statement.setInt(2, Integer.parseInt(userId));
            statement.setString(3, Long.toString(new Date().getTime()));
            statement.setString(4, "R");
            statement.setInt(5, id);
            statement.executeUpdate();
        }
    }

    /*
     * Exception decompiling
     */
    public boolean isSpaceIntoBasket(int fatherId, String name) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void removeSpaceFromBasket(int id) throws SQLException {
        try (Connection connection = DBUtil.openConnection();
             PreparedStatement statement = connection.prepareStatement(REMOVE_SPACE_FROM_BASKET);){
            statement.setNull(1, 4);
            statement.setNull(2, 12);
            statement.setNull(3, 12);
            statement.setInt(4, id);
            statement.executeUpdate();
        }
    }

    public SpaceRow getSpaceOfSpaceUserRole(int spaceUserRoleId) throws SQLException {
        return (SpaceRow)this.getUniqueRow(SELECT_SPACEUSERROLE_SPACE, spaceUserRoleId);
    }

    protected SpaceRow fetchRow(ResultSet rs) throws SQLException {
        return this.fetchSpace(rs);
    }
}

