/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.domain.synchro;

import org.silverpeas.core.admin.domain.synchro.SynchroGroupManager;
import org.silverpeas.core.scheduler.Scheduler;
import org.silverpeas.core.scheduler.SchedulerEvent;
import org.silverpeas.core.scheduler.SchedulerEventListener;
import org.silverpeas.core.scheduler.SchedulerProvider;
import org.silverpeas.core.scheduler.trigger.JobTrigger;
import org.silverpeas.kernel.logging.SilverLogger;

public class SynchroGroupScheduler
implements SchedulerEventListener {
    public static final String ADMIN_SYNCHRO_GROUP_JOB_NAME = "AdminSynchroGroupJob";

    public void initialize(String cron) {
        try {
            Scheduler scheduler = SchedulerProvider.getVolatileScheduler();
            scheduler.unscheduleJob(ADMIN_SYNCHRO_GROUP_JOB_NAME);
            JobTrigger trigger = JobTrigger.triggerAt((String)cron);
            scheduler.scheduleJob(ADMIN_SYNCHRO_GROUP_JOB_NAME, trigger, (SchedulerEventListener)this);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
        }
    }

    public void triggerFired(SchedulerEvent anEvent) {
        SynchroGroupManager.get().synchronize();
    }

    public void jobSucceeded(SchedulerEvent anEvent) {
    }

    public void jobFailed(SchedulerEvent anEvent) {
        String jobName = anEvent.getJobExecutionContext().getJobName();
        SilverLogger.getLogger((Object)this).error("The domain synchronization job {0} failed!", new Object[]{jobName});
    }
}

