/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.domain.driver.scimdriver;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.silverpeas.core.admin.domain.AbstractDomainDriver;
import org.silverpeas.core.admin.domain.DomainServiceProvider;
import org.silverpeas.core.admin.domain.quota.UserDomainQuotaKey;
import org.silverpeas.core.admin.quota.exception.QuotaException;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.user.UserManager;
import org.silverpeas.core.admin.user.model.GroupDetail;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.admin.user.model.UserFull;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQuery;
import org.silverpeas.core.util.ArrayUtil;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.bundle.SettingBundle;

public class SCIMDriver
extends AbstractDomainDriver {
    private final UserManager userManager = (UserManager)ServiceProvider.getService(UserManager.class, (Annotation[])new Annotation[0]);
    public static final String GROUP = "group";

    protected SCIMDriver() {
    }

    @Override
    public String[] getGroupMemberGroupIds(String groupId) {
        return ArrayUtil.emptyStringArray();
    }

    @Override
    public void initFromProperties(SettingBundle rs) {
    }

    @Override
    public long getDriverActions() {
        return 215047L;
    }

    @Override
    public UserDetail importUser(String userLogin) {
        return null;
    }

    @Override
    public void removeUser(String userId) {
    }

    @Override
    public UserDetail synchroUser(String userId) {
        return null;
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public String createUser(UserDetail ud) throws AdminException {
        try {
            DomainServiceProvider.getUserDomainQuotaService().verify(UserDomainQuotaKey.from(ud));
        }
        catch (QuotaException qe) {
            throw new AdminException(qe.getMessage(), (Throwable)((Object)qe));
        }
        return ud.getSpecificId();
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public void resetPassword(UserDetail user, String password) {
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public void resetEncryptedPassword(UserDetail user, String encryptedPassword) {
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public void deleteUser(String userId) {
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public void updateUserFull(UserFull uf) {
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public void updateUserDetail(UserDetail ud) {
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public UserDetail getUser(String specificId) throws AdminException {
        return (UserDetail)JdbcSqlQuery.unique(this.listUsers(Collections.singleton(specificId)));
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public List<UserDetail> listUsers(Collection<String> specificIds) throws AdminException {
        List<UserDetail> users = this.userManager.getUsersBySpecificIdsAndDomainId(specificIds, String.valueOf(this.getDomainId()));
        if (users.size() != specificIds.size()) {
            throw new AdminException("not enough or too many users referenced to same identifier", new String[0]);
        }
        return users;
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public UserFull getUserFull(String id) throws AdminException {
        return (UserFull)JdbcSqlQuery.unique(this.listUserFulls(Collections.singleton(id)));
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public List<UserFull> listUserFulls(Collection<String> specificIds) throws AdminException {
        return this.listUsers(specificIds).stream().map(u -> new UserFull(null, (UserDetail)u)).collect(Collectors.toList());
    }

    @Override
    public String[] getUserMemberGroupIds(String specificId) {
        return new String[0];
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public UserDetail[] getAllUsers() throws AdminException {
        return this.userManager.getAllUsersInDomain(String.valueOf(this.getDomainId()), false);
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public UserDetail[] getUsersBySpecificProperty(String propertyName, String propertyValue) {
        return new UserDetail[0];
    }

    @Override
    public UserDetail[] getUsersByQuery(Map<String, String> query) {
        return new UserDetail[0];
    }

    @Override
    public GroupDetail importGroup(String groupName) {
        return null;
    }

    @Override
    public void removeGroup(String groupId) {
    }

    @Override
    public GroupDetail synchroGroup(String groupId) {
        return null;
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public String createGroup(GroupDetail group) {
        return null;
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public void deleteGroup(String groupId) {
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public void updateGroup(GroupDetail group) {
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public GroupDetail getGroup(String specificId) {
        return null;
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public GroupDetail getGroupByName(String groupName) {
        return null;
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public GroupDetail[] getGroups(String groupId) {
        return new GroupDetail[0];
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public GroupDetail[] getAllGroups() {
        return new GroupDetail[0];
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public GroupDetail[] getAllRootGroups() {
        return new GroupDetail[0];
    }

    @Transactional(value=Transactional.TxType.MANDATORY)
    public void addUserInGroup(String userId, String groupId) {
    }

    @Transactional(value=Transactional.TxType.MANDATORY)
    public void removeUserFromGroup(String userId, String groupId) {
    }

    @Override
    public List<String> getUserAttributes() {
        return Collections.emptyList();
    }
}

