/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.domain.driver.ldapdriver;

import com.novell.ldap.LDAPConstraints;
import com.novell.ldap.LDAPSearchConstraints;
import java.util.Collection;
import java.util.stream.Collectors;
import org.silverpeas.core.admin.domain.driver.DriverSettings;
import org.silverpeas.core.admin.domain.driver.ldapdriver.AbstractLDAPGroup;
import org.silverpeas.core.admin.domain.driver.ldapdriver.LDAPUser;
import org.silverpeas.core.admin.domain.driver.ldapdriver.LDAPUtility;
import org.silverpeas.core.admin.domain.driver.ldapdriver.LdapConfiguration;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.util.ArrayUtil;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.util.StringUtil;

public class LDAPSettings
implements DriverSettings {
    private final LdapConfiguration configuration = new LdapConfiguration();
    private int ldapProtocolVer = 3;
    private boolean ldapOpAttributesUsed = false;
    private String ldapUserBaseDN = null;
    private boolean ldapSearchRecurs = false;
    private LDAPConstraints ldapDefaultConstraints = null;
    private LDAPSearchConstraints ldapDefaultSearchConstraints = null;
    private int ldapMaxMsClientTimeLimit = 0;
    private int ldapMaxSecServerTimeLimit = 0;
    private int ldapMaxNbEntryReturned = 5000;
    private int ldapMaxNbReferrals = 0;
    private int ldapBatchSize = 1;
    private boolean sortControlSupported = true;
    private boolean synchroAutomatic = false;
    private boolean synchroRecursToGroups = true;
    private boolean synchroThreaded = false;
    private boolean synchroCacheEnabled = true;
    private boolean synchroImportUsers = true;
    private String usersClassName = null;
    private String usersFilter = null;
    private String usersType = null;
    private String usersIdField = null;
    private String usersLoginField = null;
    private String usersFirstNameField = null;
    private String usersLastNameField = null;
    private String usersEmailField = null;
    private String usersAccountControl = null;
    private String usersDisabledAccountFlag = null;
    private String groupsType = null;
    private String groupsClassName = null;
    private boolean groupsInheritProfiles = false;
    private String groupsFilter = null;
    private int groupsNamingDepth = 0;
    private String groupsIdField = null;
    private boolean groupsIncludeEmptyGroups = true;
    private String groupsSpecificGroupsBaseDN = null;
    private String groupsMemberField = null;
    private String groupsNameField = null;
    private String groupsDescriptionField = null;

    @Override
    public void initFromProperties(SettingBundle rs) {
        String ldap = rs.getString("database.LDAPImpl", null);
        this.configuration.setEncryptedCredentials(rs.getBoolean("database.encryptedCredentials", false));
        this.configuration.setLdapHost(rs.getString("database.LDAPHost", null));
        this.configuration.setLdapPort(rs.getInteger("database.LDAPPort", this.configuration.getLdapPort()));
        this.ldapProtocolVer = rs.getInteger("database.LDAPProtocolVer", 3);
        this.ldapOpAttributesUsed = rs.getBoolean("database.LDAPOpAttributesUsed", this.ldapOpAttributesUsed);
        this.ldapProtocolVer = 3;
        this.configuration.setUsername(rs.getString("database.LDAPAccessLoginDN", null));
        this.configuration.setPassword(rs.getString("database.LDAPAccessPasswd", ""));
        this.ldapUserBaseDN = rs.getString("database.LDAPUserBaseDN", null);
        this.ldapMaxMsClientTimeLimit = rs.getInteger("database.LDAPMaxMsClientTimeLimit", this.ldapMaxMsClientTimeLimit);
        this.ldapMaxSecServerTimeLimit = rs.getInteger("database.LDAPMaxSecServerTimeLimit", this.ldapMaxSecServerTimeLimit);
        this.ldapMaxNbEntryReturned = rs.getInteger("database.LDAPMaxNbEntryReturned", this.ldapMaxNbEntryReturned);
        this.ldapMaxNbReferrals = rs.getInteger("database.LDAPMaxNbReferrals", this.ldapMaxNbReferrals);
        this.ldapBatchSize = rs.getInteger("database.LDAPBatchSize", this.ldapBatchSize);
        this.ldapSearchRecurs = rs.getBoolean("database.LDAPSearchRecurs", this.ldapSearchRecurs);
        this.configuration.setSecure(rs.getBoolean("database.LDAPSecured", false));
        if (this.configuration.isSecure()) {
            this.configuration.setLdapPort(rs.getInteger("database.LDAPPortSecured", 636));
        }
        this.sortControlSupported = rs.getBoolean("database.SortControlSupported", !"openldap".equalsIgnoreCase(ldap));
        this.ldapDefaultSearchConstraints = this.getSearchConstraints(true);
        this.ldapDefaultConstraints = this.getConstraints(true);
        this.synchroAutomatic = rs.getBoolean("synchro.Automatic", this.synchroAutomatic);
        this.synchroRecursToGroups = rs.getBoolean("synchro.RecursToGroups", this.synchroRecursToGroups);
        this.synchroThreaded = rs.getBoolean("synchro.Threaded", this.synchroThreaded);
        this.synchroCacheEnabled = rs.getBoolean("synchro.CacheEnabled", this.synchroCacheEnabled);
        this.synchroImportUsers = rs.getBoolean("synchro.importUsers", true);
        this.usersType = rs.getString("users.Type", null);
        this.usersClassName = rs.getString("users.ClassName", null);
        this.usersFilter = rs.getString("users.Filter", null);
        this.usersIdField = rs.getString("users.IdField", null);
        this.usersLoginField = rs.getString("users.LoginField", null);
        this.usersFirstNameField = rs.getString("users.FirstNameField", null);
        this.usersLastNameField = rs.getString("users.LastNameField", null);
        this.usersEmailField = rs.getString("users.EmailField", "");
        this.usersAccountControl = rs.getString("users.accountControl", "");
        this.usersDisabledAccountFlag = rs.getString("users.accountControl.disabledFlags", "");
        this.groupsType = rs.getString("groups.Type", null);
        this.groupsClassName = rs.getString("groups.ClassName", null);
        this.groupsInheritProfiles = rs.getBoolean("groups.InheritProfiles", this.groupsInheritProfiles);
        this.groupsFilter = rs.getString("groups.Filter", null);
        this.groupsNamingDepth = rs.getInteger("groups.NamingDepth", this.groupsNamingDepth);
        this.groupsIdField = rs.getString("groups.IdField", null);
        this.groupsIncludeEmptyGroups = rs.getBoolean("groups.IncludeEmptyGroups", this.groupsIncludeEmptyGroups);
        this.groupsSpecificGroupsBaseDN = rs.getString("groups.SpecificGroupsBaseDN", "");
        this.groupsMemberField = rs.getString("groups.MemberField", "");
        this.groupsNameField = rs.getString("groups.NameField", "");
        this.groupsDescriptionField = rs.getString("groups.DescriptionField", "");
    }

    public boolean isSynchroAutomatic() {
        return this.synchroAutomatic;
    }

    public boolean isSynchroRecursToGroups() {
        return this.synchroRecursToGroups;
    }

    public boolean isSynchroThreaded() {
        return this.synchroThreaded;
    }

    public boolean isSynchroCacheEnabled() {
        return this.synchroCacheEnabled;
    }

    public boolean mustImportUsers() {
        return this.synchroImportUsers;
    }

    public String getLDAPHost() {
        return this.configuration.getLdapHost();
    }

    public int getLDAPPort() {
        return this.configuration.getLdapPort();
    }

    public int getLDAPProtocolVer() {
        return this.ldapProtocolVer;
    }

    public boolean isLDAPOpAttributesUsed() {
        return this.ldapOpAttributesUsed;
    }

    public String getLDAPAccessLoginDN() {
        return this.configuration.getUsername();
    }

    public byte[] getLDAPAccessPasswd() {
        return this.configuration.getPassword();
    }

    public String getLDAPUserBaseDN() {
        return this.ldapUserBaseDN;
    }

    public boolean isLDAPSecured() {
        return this.configuration.isSecure();
    }

    public int getScope() {
        if (this.ldapSearchRecurs) {
            return 2;
        }
        return 1;
    }

    public LDAPSearchConstraints getSearchConstraints(boolean allocateNew) {
        if (allocateNew) {
            boolean doReferrals = this.ldapMaxNbReferrals != 0;
            return new LDAPSearchConstraints(this.ldapMaxMsClientTimeLimit, this.ldapMaxSecServerTimeLimit, 0, this.ldapMaxNbEntryReturned, doReferrals, this.ldapBatchSize, null, this.ldapMaxNbReferrals);
        }
        return this.ldapDefaultSearchConstraints;
    }

    public LDAPConstraints getConstraints(boolean allocateNew) {
        if (allocateNew) {
            boolean doReferrals = this.ldapMaxNbReferrals != 0;
            return new LDAPConstraints(this.ldapMaxMsClientTimeLimit, doReferrals, null, this.ldapMaxNbReferrals);
        }
        return this.ldapDefaultConstraints;
    }

    public LDAPUser newLDAPUser() throws AdminException {
        try {
            if (this.usersType != null) {
                return (LDAPUser)Class.forName(this.usersType).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return new LDAPUser();
        }
        catch (Exception e) {
            throw new AdminException(e.getMessage(), e);
        }
    }

    public String getUsersFullFilter() {
        if (StringUtil.isDefined((String)this.usersFilter)) {
            return "(&(objectClass=" + this.usersClassName + ")" + this.usersFilter + ")";
        }
        return "(objectClass=" + this.usersClassName + ")";
    }

    public String getUsersIdField() {
        return this.usersIdField;
    }

    public String getUsersLoginField() {
        return this.usersLoginField;
    }

    public String getUsersFirstNameField() {
        return this.usersFirstNameField;
    }

    public String getUsersLastNameField() {
        return this.usersLastNameField;
    }

    public String getUsersEmailField() {
        return this.usersEmailField;
    }

    public String getUsersAccountControl() {
        return this.usersAccountControl;
    }

    public String getUsersDisabledAccountFlag() {
        return this.usersDisabledAccountFlag;
    }

    public String getUsersIdFilter(String value) {
        if (LDAPUtility.isAGuid(this.getUsersIdField()) && value != null) {
            String singleSlashValue = this.parseValue(value);
            return "(&" + this.getUsersFullFilter() + "(" + this.getUsersIdField() + "=" + singleSlashValue + "))";
        }
        return "(&" + this.getUsersFullFilter() + "(" + this.getUsersIdField() + "=" + LDAPUtility.normalizeFilterValue(value) + "))";
    }

    private String parseValue(String value) {
        char[] vca;
        StringBuilder singleSlashValue = new StringBuilder(value.length());
        boolean bIsFirst = true;
        for (char aVca : vca = value.toCharArray()) {
            if (aVca == '\\') {
                if (bIsFirst) {
                    singleSlashValue.append(aVca);
                }
                bIsFirst = !bIsFirst;
                continue;
            }
            bIsFirst = true;
            singleSlashValue.append(aVca);
        }
        return singleSlashValue.toString();
    }

    public String getUsersManualFilter(Collection<String> values) {
        if (values.size() == 1) {
            return this.getUsersManualFilter(values.iterator().next());
        }
        return values.stream().map(this::getUsersManualFilter).collect(Collectors.joining("", "(|", ")"));
    }

    public String getUsersManualFilter(String value) {
        return "(&" + this.getUsersFullFilter() + "(" + LDAPUtility.normalizeFilterValue(value) + "))";
    }

    public String getUsersIdFilter(Collection<String> values) {
        if (values.size() == 1) {
            return this.getUsersIdFilter(values.iterator().next());
        }
        return values.stream().map(this::getUsersIdFilter).collect(Collectors.joining("", "(|", ")"));
    }

    public String getUsersLoginFilter(String value) {
        return "(&" + this.getUsersFullFilter() + "(" + this.getUsersLoginField() + "=" + value + "))";
    }

    public AbstractLDAPGroup newLDAPGroup() throws AdminException {
        try {
            return (AbstractLDAPGroup)Class.forName(this.groupsType).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new AdminException(e.getMessage(), e);
        }
    }

    public boolean isGroupsInheritProfiles() {
        return this.groupsInheritProfiles;
    }

    public String getGroupsFullFilter() {
        if (this.groupsFilter != null && !this.groupsFilter.isEmpty()) {
            return "(&(objectClass=" + this.groupsClassName + ")" + this.groupsFilter + ")";
        }
        return "(objectClass=" + this.groupsClassName + ")";
    }

    public String getGroupsMemberField() {
        return this.groupsMemberField;
    }

    public String getGroupsSpecificGroupsBaseDN() {
        if (!StringUtil.isDefined((String)this.groupsSpecificGroupsBaseDN)) {
            return this.ldapUserBaseDN;
        }
        if (this.groupsSpecificGroupsBaseDN.equalsIgnoreCase("root")) {
            return "";
        }
        return this.groupsSpecificGroupsBaseDN;
    }

    public String getGroupsIdField() {
        return this.groupsIdField;
    }

    public boolean getGroupsIncludeEmptyGroups() {
        return this.groupsIncludeEmptyGroups;
    }

    public String getGroupsNameField() {
        return this.groupsNameField;
    }

    public String getGroupsDescriptionField() {
        return this.groupsDescriptionField;
    }

    public String getGroupsIdFilter(String value) {
        if (LDAPUtility.isAGuid(this.getGroupsIdField()) && value != null) {
            String singleSlashValue = this.parseValue(value);
            return "(&" + this.getGroupsFullFilter() + "(" + this.getGroupsIdField() + "=" + singleSlashValue + "))";
        }
        return "(&" + this.getGroupsFullFilter() + "(" + this.getGroupsIdField() + "=" + LDAPUtility.normalizeFilterValue(value) + "))";
    }

    public String getGroupsNameFilter(String value) {
        return "(&" + this.getGroupsFullFilter() + "(" + this.getGroupsNameField() + "=" + value + "))";
    }

    protected String[] getUserAttributes() {
        if (this.isLDAPOpAttributesUsed()) {
            String usersAccountControlAttribute = this.getUsersAccountControl();
            String[] attrs = new String[StringUtil.isDefined((String)usersAccountControlAttribute) ? 6 : 5];
            attrs[0] = this.getUsersIdField();
            attrs[1] = this.getUsersEmailField();
            attrs[2] = this.getUsersFirstNameField();
            attrs[3] = this.getUsersLastNameField();
            attrs[4] = this.getUsersLoginField();
            if (StringUtil.isDefined((String)usersAccountControlAttribute)) {
                attrs[5] = usersAccountControlAttribute;
            }
            return attrs;
        }
        return ArrayUtil.emptyStringArray();
    }

    protected String[] getGroupAttributes() {
        if (this.isLDAPOpAttributesUsed()) {
            String[] attrs = new String[]{this.getGroupsDescriptionField(), this.getGroupsIdField(), this.getGroupsMemberField(), this.getGroupsNameField()};
            return attrs;
        }
        return ArrayUtil.emptyStringArray();
    }

    public boolean isSortControlSupported() {
        return this.sortControlSupported;
    }
}

