/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.component.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.silverpeas.core.admin.user.model.UserDetail;

public class ComponentSearchCriteria
implements Serializable {
    private static final long serialVersionUID = -8747314498972863730L;
    private List<String> componentInstanceIds;
    private String workspaceId;
    private UserDetail user;

    public ComponentSearchCriteria onWorkspace(String workspaceId) {
        this.workspaceId = workspaceId;
        return this;
    }

    public ComponentSearchCriteria onComponentInstances(List<String> instanceIds) {
        this.componentInstanceIds = Optional.ofNullable(instanceIds).stream().flatMap(Collection::stream).sorted().collect(Collectors.toList());
        return this;
    }

    public ComponentSearchCriteria onUser(UserDetail user) {
        this.user = user;
        return this;
    }

    public boolean hasCriterionOnComponentInstances() {
        return this.componentInstanceIds != null && !this.componentInstanceIds.isEmpty();
    }

    public boolean hasCriterionOnWorkspace() {
        return this.workspaceId != null;
    }

    public boolean hasCriterionOnUser() {
        return this.user != null;
    }

    public List<String> getComponentInstanceIds() {
        return this.componentInstanceIds;
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public UserDetail getUser() {
        return this.user;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentSearchCriteria that = (ComponentSearchCriteria)o;
        return Objects.equals(this.componentInstanceIds, that.componentInstanceIds) && Objects.equals(this.workspaceId, that.workspaceId) && Objects.equals(this.user, that.user);
    }

    public int hashCode() {
        return Objects.hash(this.componentInstanceIds, this.workspaceId, this.user);
    }
}

