/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.scim.spec.resources;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.AnnotationIntrospectorPair;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationModule;
import edu.psu.swe.scim.spec.annotation.ScimAttribute;
import edu.psu.swe.scim.spec.annotation.ScimExtensionType;
import edu.psu.swe.scim.spec.exception.InvalidExtensionException;
import edu.psu.swe.scim.spec.extension.ScimExtensionRegistry;
import edu.psu.swe.scim.spec.resources.BaseResource;
import edu.psu.swe.scim.spec.resources.ScimExtension;
import edu.psu.swe.scim.spec.schema.Meta;
import edu.psu.swe.scim.spec.schema.Schema;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlAccessorType(value=XmlAccessType.NONE)
public abstract class ScimResource
extends BaseResource
implements Serializable {
    private static final long serialVersionUID = 3673404125396687366L;
    private static final Logger LOG = LoggerFactory.getLogger(ScimResource.class);
    @XmlElement
    @NotNull
    @ScimAttribute(returned=Schema.Attribute.Returned.ALWAYS)
    Meta meta;
    @XmlElement
    @Size(min=1)
    @ScimAttribute(required=true, returned=Schema.Attribute.Returned.ALWAYS)
    String id;
    @XmlElement
    @ScimAttribute
    String externalId;
    private Map<String, ScimExtension> extensions = new HashMap<String, ScimExtension>();
    private String baseUrn;

    public ScimResource(String urn) {
        super(urn);
        this.baseUrn = urn;
    }

    public void addExtension(ScimExtension extension) {
        ScimExtensionType[] se = (ScimExtensionType[])extension.getClass().getAnnotationsByType(ScimExtensionType.class);
        if (se.length == 0 || se.length > 1) {
            throw new InvalidExtensionException("Registered extensions must have an ScimExtensionType annotation");
        }
        String extensionUrn = se[0].id();
        this.extensions.put(extensionUrn, extension);
        this.addSchema(extensionUrn);
    }

    public ScimExtension getExtension(String urn) {
        return this.extensions.get(urn);
    }

    public <T> T getExtension(Class<T> extensionClass) {
        ScimExtensionType se = this.lookupScimExtensionType(extensionClass);
        return (T)this.extensions.get(se.id());
    }

    private <T> ScimExtensionType lookupScimExtensionType(Class<T> extensionClass) {
        ScimExtensionType[] se = (ScimExtensionType[])extensionClass.getAnnotationsByType(ScimExtensionType.class);
        if (se.length == 0 || se.length > 1) {
            throw new InvalidExtensionException("Registered extensions must have an ScimExtensionType annotation");
        }
        return se[0];
    }

    public abstract String getResourceType();

    public String getBaseUrn() {
        return this.baseUrn;
    }

    @JsonAnyGetter
    public Map<String, ScimExtension> getExtensions() {
        return this.extensions;
    }

    @JsonAnySetter
    public void setExtensions(String key, Object value) {
        LOG.debug("Found a ScimExtension");
        LOG.debug("Extension's URN: " + key);
        LOG.debug("Extension's string representation: " + value);
        Class<?> resourceClass = this.getClass();
        LOG.debug("Resource class: " + resourceClass.getSimpleName());
        Class<? extends ScimExtension> extensionClass = ScimExtensionRegistry.getInstance().getExtensionClass(resourceClass, key);
        if (extensionClass != null) {
            LOG.debug("Extension class: " + extensionClass.getSimpleName());
            ObjectMapper objectMapper = new ObjectMapper();
            JaxbAnnotationModule jaxbAnnotationModule = new JaxbAnnotationModule();
            objectMapper.registerModule((Module)jaxbAnnotationModule);
            JaxbAnnotationIntrospector jaxbIntrospector = new JaxbAnnotationIntrospector(objectMapper.getTypeFactory());
            JacksonAnnotationIntrospector jacksonIntrospector = new JacksonAnnotationIntrospector();
            AnnotationIntrospectorPair pair = new AnnotationIntrospectorPair((AnnotationIntrospector)jacksonIntrospector, (AnnotationIntrospector)jaxbIntrospector);
            objectMapper.setAnnotationIntrospector((AnnotationIntrospector)pair);
            ScimExtension extension = (ScimExtension)objectMapper.convertValue(value, extensionClass);
            if (extension != null) {
                LOG.debug("    ***** Added extension to the resource *****");
                this.extensions.put(key, extension);
            }
        }
    }

    public ScimExtension removeExtension(String urn) {
        return this.extensions.remove(urn);
    }

    public <T> T removeExtension(Class<T> extensionClass) {
        ScimExtensionType se = this.lookupScimExtensionType(extensionClass);
        return (T)this.extensions.remove(se.id());
    }

    public Meta getMeta() {
        return this.meta;
    }

    public String getId() {
        return this.id;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public void setMeta(Meta meta) {
        this.meta = meta;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public void setExtensions(Map<String, ScimExtension> extensions) {
        this.extensions = extensions;
    }

    public void setBaseUrn(String baseUrn) {
        this.baseUrn = baseUrn;
    }

    @Override
    public String toString() {
        return "ScimResource(meta=" + this.getMeta() + ", id=" + this.getId() + ", externalId=" + this.getExternalId() + ", extensions=" + this.getExtensions() + ", baseUrn=" + this.getBaseUrn() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScimResource)) {
            return false;
        }
        ScimResource other = (ScimResource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Meta this$meta = this.getMeta();
        Meta other$meta = other.getMeta();
        if (this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$externalId = this.getExternalId();
        String other$externalId = other.getExternalId();
        if (this$externalId == null ? other$externalId != null : !this$externalId.equals(other$externalId)) {
            return false;
        }
        Map<String, ScimExtension> this$extensions = this.getExtensions();
        Map<String, ScimExtension> other$extensions = other.getExtensions();
        if (this$extensions == null ? other$extensions != null : !((Object)this$extensions).equals(other$extensions)) {
            return false;
        }
        String this$baseUrn = this.getBaseUrn();
        String other$baseUrn = other.getBaseUrn();
        return !(this$baseUrn == null ? other$baseUrn != null : !this$baseUrn.equals(other$baseUrn));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ScimResource;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        Meta $meta = this.getMeta();
        result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $externalId = this.getExternalId();
        result = result * 59 + ($externalId == null ? 43 : $externalId.hashCode());
        Map<String, ScimExtension> $extensions = this.getExtensions();
        result = result * 59 + ($extensions == null ? 43 : ((Object)$extensions).hashCode());
        String $baseUrn = this.getBaseUrn();
        result = result * 59 + ($baseUrn == null ? 43 : $baseUrn.hashCode());
        return result;
    }
}

