/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.scim.spec.extension;

import edu.psu.swe.scim.spec.annotation.ScimAttribute;
import edu.psu.swe.scim.spec.annotation.ScimExtensionType;
import edu.psu.swe.scim.spec.resources.ScimExtension;
import edu.psu.swe.scim.spec.schema.Schema;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
@ScimExtensionType(required=false, name="EnterpriseUser", id="urn:ietf:params:scim:schemas:extension:enterprise:2.0:User", description="Attributes commonly used in representing users that belong to, or act on behalf of, a business or enterprise.")
public class EnterpriseExtension
implements ScimExtension {
    private static final long serialVersionUID = -6850246976790442980L;
    public static final String URN = "urn:ietf:params:scim:schemas:extension:enterprise:2.0:User";
    @ScimAttribute(description="A string identifier, typically numeric or alphanumeric, assigned to a person, typically based on order of hire or association with an organization.")
    @XmlElement
    private String employeeNumber;
    @ScimAttribute(description="Identifies the name of a cost center.")
    @XmlElement
    private String costCenter;
    @ScimAttribute(description="Identifies the name of an organization.")
    @XmlElement
    private String organization;
    @ScimAttribute(description="Identifies the name of a division.")
    @XmlElement
    private String division;
    @ScimAttribute(description="Identifies the name of a department.")
    @XmlElement
    private String department;
    @ScimAttribute(description="The user's manager.  A complex type that optionally allows service providers to represent organizational hierarchy by referencing the \"id\" attribute of another User.")
    @XmlElement
    private Manager manager;

    @Override
    public String getUrn() {
        return URN;
    }

    public String getEmployeeNumber() {
        return this.employeeNumber;
    }

    public String getCostCenter() {
        return this.costCenter;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getDivision() {
        return this.division;
    }

    public String getDepartment() {
        return this.department;
    }

    public Manager getManager() {
        return this.manager;
    }

    public void setEmployeeNumber(String employeeNumber) {
        this.employeeNumber = employeeNumber;
    }

    public void setCostCenter(String costCenter) {
        this.costCenter = costCenter;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public void setDivision(String division) {
        this.division = division;
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    public void setManager(Manager manager) {
        this.manager = manager;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EnterpriseExtension)) {
            return false;
        }
        EnterpriseExtension other = (EnterpriseExtension)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$employeeNumber = this.getEmployeeNumber();
        String other$employeeNumber = other.getEmployeeNumber();
        if (this$employeeNumber == null ? other$employeeNumber != null : !this$employeeNumber.equals(other$employeeNumber)) {
            return false;
        }
        String this$costCenter = this.getCostCenter();
        String other$costCenter = other.getCostCenter();
        if (this$costCenter == null ? other$costCenter != null : !this$costCenter.equals(other$costCenter)) {
            return false;
        }
        String this$organization = this.getOrganization();
        String other$organization = other.getOrganization();
        if (this$organization == null ? other$organization != null : !this$organization.equals(other$organization)) {
            return false;
        }
        String this$division = this.getDivision();
        String other$division = other.getDivision();
        if (this$division == null ? other$division != null : !this$division.equals(other$division)) {
            return false;
        }
        String this$department = this.getDepartment();
        String other$department = other.getDepartment();
        if (this$department == null ? other$department != null : !this$department.equals(other$department)) {
            return false;
        }
        Manager this$manager = this.getManager();
        Manager other$manager = other.getManager();
        return !(this$manager == null ? other$manager != null : !((Object)this$manager).equals(other$manager));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EnterpriseExtension;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $employeeNumber = this.getEmployeeNumber();
        result = result * 59 + ($employeeNumber == null ? 43 : $employeeNumber.hashCode());
        String $costCenter = this.getCostCenter();
        result = result * 59 + ($costCenter == null ? 43 : $costCenter.hashCode());
        String $organization = this.getOrganization();
        result = result * 59 + ($organization == null ? 43 : $organization.hashCode());
        String $division = this.getDivision();
        result = result * 59 + ($division == null ? 43 : $division.hashCode());
        String $department = this.getDepartment();
        result = result * 59 + ($department == null ? 43 : $department.hashCode());
        Manager $manager = this.getManager();
        result = result * 59 + ($manager == null ? 43 : ((Object)$manager).hashCode());
        return result;
    }

    public String toString() {
        return "EnterpriseExtension(employeeNumber=" + this.getEmployeeNumber() + ", costCenter=" + this.getCostCenter() + ", organization=" + this.getOrganization() + ", division=" + this.getDivision() + ", department=" + this.getDepartment() + ", manager=" + this.getManager() + ")";
    }

    @XmlType
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class Manager
    implements Serializable {
        private static final long serialVersionUID = -7930518578899296192L;
        @ScimAttribute(description="The \"id\" of the SCIM resource representing the user's manager.  RECOMMENDED.")
        @XmlElement
        private String value;
        @ScimAttribute(description="The URI of the SCIM resource representing the User's manager.  RECOMMENDED.")
        @XmlElement(name="$ref")
        private String ref;
        @ScimAttribute(mutability=Schema.Attribute.Mutability.READ_ONLY, description="he displayName of the user's manager.  This attribute is OPTIONAL.")
        @XmlElement
        private String displayName;

        public String getValue() {
            return this.value;
        }

        public String getRef() {
            return this.ref;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void setRef(String ref) {
            this.ref = ref;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Manager)) {
                return false;
            }
            Manager other = (Manager)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            String this$ref = this.getRef();
            String other$ref = other.getRef();
            if (this$ref == null ? other$ref != null : !this$ref.equals(other$ref)) {
                return false;
            }
            String this$displayName = this.getDisplayName();
            String other$displayName = other.getDisplayName();
            return !(this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Manager;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            String $ref = this.getRef();
            result = result * 59 + ($ref == null ? 43 : $ref.hashCode());
            String $displayName = this.getDisplayName();
            result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
            return result;
        }

        public String toString() {
            return "EnterpriseExtension.Manager(value=" + this.getValue() + ", ref=" + this.getRef() + ", displayName=" + this.getDisplayName() + ")";
        }
    }
}

