/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.scim.spec.protocol.data;

import edu.psu.swe.scim.spec.protocol.ErrorMessageType;
import edu.psu.swe.scim.spec.protocol.data.StatusAdapter;
import edu.psu.swe.scim.spec.resources.BaseResource;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class ErrorResponse
extends BaseResource {
    private static final long serialVersionUID = 9045421198080348116L;
    public static String SCHEMA_URI = "urn:ietf:params:scim:api:messages:2.0:Error";
    @XmlElement(nillable=true)
    private String detail;
    @XmlElement
    @XmlJavaTypeAdapter(value=StatusAdapter.class)
    private Response.Status status;
    @XmlElement
    private ErrorMessageType scimType;
    private List<String> errorMessageList;

    protected ErrorResponse() {
        super(SCHEMA_URI);
    }

    public ErrorResponse(Response.Status status, String detail) {
        super(SCHEMA_URI);
        this.status = status;
        this.detail = detail;
    }

    public void addErrorMessage(String message) {
        if (this.errorMessageList == null) {
            this.errorMessageList = new ArrayList<String>();
        }
        this.errorMessageList.add(message);
    }

    public Response toResponse() {
        if (this.errorMessageList != null) {
            StringBuilder sb = new StringBuilder();
            for (String s : this.errorMessageList) {
                sb.append("\n").append(s);
            }
            this.detail = this.detail + sb.toString();
        }
        return Response.status((Response.Status)this.status).entity((Object)this).build();
    }

    public String getDetail() {
        return this.detail;
    }

    public Response.Status getStatus() {
        return this.status;
    }

    public ErrorMessageType getScimType() {
        return this.scimType;
    }

    public List<String> getErrorMessageList() {
        return this.errorMessageList;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public void setStatus(Response.Status status) {
        this.status = status;
    }

    public void setScimType(ErrorMessageType scimType) {
        this.scimType = scimType;
    }

    public void setErrorMessageList(List<String> errorMessageList) {
        this.errorMessageList = errorMessageList;
    }

    public String toString() {
        return "ErrorResponse(detail=" + this.getDetail() + ", status=" + this.getStatus() + ", scimType=" + (Object)((Object)this.getScimType()) + ", errorMessageList=" + this.getErrorMessageList() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ErrorResponse)) {
            return false;
        }
        ErrorResponse other = (ErrorResponse)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$detail = this.getDetail();
        String other$detail = other.getDetail();
        if (this$detail == null ? other$detail != null : !this$detail.equals(other$detail)) {
            return false;
        }
        Response.Status this$status = this.getStatus();
        Response.Status other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        ErrorMessageType this$scimType = this.getScimType();
        ErrorMessageType other$scimType = other.getScimType();
        if (this$scimType == null ? other$scimType != null : !((Object)((Object)this$scimType)).equals((Object)other$scimType)) {
            return false;
        }
        List<String> this$errorMessageList = this.getErrorMessageList();
        List<String> other$errorMessageList = other.getErrorMessageList();
        return !(this$errorMessageList == null ? other$errorMessageList != null : !((Object)this$errorMessageList).equals(other$errorMessageList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ErrorResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $detail = this.getDetail();
        result = result * 59 + ($detail == null ? 43 : $detail.hashCode());
        Response.Status $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        ErrorMessageType $scimType = this.getScimType();
        result = result * 59 + ($scimType == null ? 43 : ((Object)((Object)$scimType)).hashCode());
        List<String> $errorMessageList = this.getErrorMessageList();
        result = result * 59 + ($errorMessageList == null ? 43 : ((Object)$errorMessageList).hashCode());
        return result;
    }
}

