/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.common.descriptor;

import com.sun.portal.portletcontainer.common.descriptor.InitParamDescriptor;
import com.sun.portal.portletcontainer.common.descriptor.PortletXMLDocumentHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterDescriptor {
    private String filterName;
    private String filterClass;
    private Set<String> lifecycle;
    private Map<String, String> descriptionMap;
    private List<InitParamDescriptor> initParamDescriptors;

    public void load(Element filterElement, String namespaceURI) {
        this.filterName = PortletXMLDocumentHelper.getChildTextTrim(filterElement, "filter-name");
        this.filterClass = PortletXMLDocumentHelper.getChildTextTrim(filterElement, "filter-class");
        this.lifecycle = PortletXMLDocumentHelper.getChildElementsTextSet(filterElement, "lifecycle");
        this.descriptionMap = PortletXMLDocumentHelper.getDescriptionMap(filterElement);
        NodeList initParamElements = filterElement.getElementsByTagName("init-param");
        if (initParamElements.getLength() > 0) {
            this.initParamDescriptors = new ArrayList<InitParamDescriptor>(initParamElements.getLength());
            for (int i = 0; i < initParamElements.getLength(); ++i) {
                Element initParamElement = (Element)initParamElements.item(i);
                InitParamDescriptor initParamDescriptor = new InitParamDescriptor();
                initParamDescriptor.load(initParamElement, namespaceURI);
                this.initParamDescriptors.add(initParamDescriptor);
            }
        }
    }

    public String getFilterName() {
        return this.filterName;
    }

    public String getFilterClass() {
        return this.filterClass;
    }

    public Set<String> getFilterLifecycles() {
        return this.lifecycle;
    }

    public List<String> getDescriptions() {
        return new ArrayList<String>(this.descriptionMap.values());
    }

    public String getDescription() {
        return PortletXMLDocumentHelper.getDescription(this.descriptionMap);
    }

    public String getDescription(String lang) {
        return this.descriptionMap.get(lang);
    }

    public List<InitParamDescriptor> getInitParamDescriptors() {
        if (this.initParamDescriptors == null) {
            return Collections.emptyList();
        }
        return this.initParamDescriptors;
    }
}

