/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.container;

import com.sun.portal.container.ContainerLogger;
import com.sun.portal.container.ContainerUtil;
import com.sun.portal.container.service.EventHolder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class PortletEvent {
    private EventHolder eventHolder;
    private QName eventQName;
    private Serializable eventPayload;
    private static Logger logger = ContainerLogger.getLogger(PortletEvent.class, "CLogMessages");

    public PortletEvent(EventHolder eventHolder, QName eventQName, Serializable value) {
        this.eventHolder = eventHolder;
        this.eventQName = eventQName;
        try {
            this.eventPayload = ContainerUtil.serializeJavaToXml(eventQName, value);
        }
        catch (Exception ex) {
            logger.log(this.getLogRecord("PSC_CSPCS019", ex));
        }
    }

    public PortletEvent(EventHolder eventHolder, QName eventName, JAXBElement value) {
        this.eventQName = eventName;
        this.eventHolder = eventHolder;
        String xmlData = null;
        if (value != null) {
            try {
                Class<?> clazz = value.getClass();
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
                Marshaller marshaller = jaxbContext.createMarshaller();
                StringWriter out = new StringWriter();
                marshaller.marshal((Object)value, (Writer)out);
                xmlData = ((Object)out).toString();
            }
            catch (JAXBException jaxbe) {
                logger.log(this.getLogRecord("PSC_CSPCS019", (Exception)((Object)jaxbe)));
            }
        }
        this.eventPayload = xmlData;
    }

    public PortletEvent(EventHolder eventHolder, QName eventName, Element value) {
        this.eventQName = eventName;
        this.eventHolder = eventHolder;
        String xmlData = null;
        if (value != null) {
            try {
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer trans = tf.newTransformer();
                StringWriter sw = new StringWriter();
                trans.transform(new DOMSource(value), new StreamResult(sw));
                xmlData = sw.toString();
            }
            catch (TransformerConfigurationException e) {
                logger.log(this.getLogRecord("PSC_CSPCS019", e));
            }
            catch (TransformerException e1) {
                logger.log(this.getLogRecord("PSC_CSPCS019", e1));
            }
        }
        this.eventPayload = xmlData;
    }

    public EventHolder getEventHolder() {
        return this.eventHolder;
    }

    public QName getQName() {
        return this.eventQName;
    }

    public void setQName(QName eventQName) {
        this.eventQName = eventQName;
    }

    public String getName() {
        return this.eventQName.getLocalPart();
    }

    public Serializable getValue() {
        Serializable value = null;
        try {
            value = ContainerUtil.deserializeXmlToJava(this.getValueType(), this.eventPayload);
        }
        catch (Exception ex) {
            logger.log(this.getLogRecord("PSC_CSPCS020", ex));
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element getElementValue() {
        Element docElement = null;
        ByteArrayInputStream bais = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            bais = new ByteArrayInputStream(((String)((Object)this.eventPayload)).getBytes("UTF-8"));
            Document doc = parser.parse(bais);
            docElement = doc.getDocumentElement();
        }
        catch (SAXException ex) {
            logger.log(this.getLogRecord("PSC_CSPCS024", ex));
        }
        catch (ParserConfigurationException pcex) {
            logger.log(this.getLogRecord("PSC_CSPCS024", pcex));
        }
        catch (IOException ioex) {
            logger.log(this.getLogRecord("PSC_CSPCS024", ioex));
        }
        finally {
            try {
                if (bais != null) {
                    bais.close();
                }
            }
            catch (Exception ignore) {}
        }
        return docElement;
    }

    public String getValueType() {
        return this.eventHolder.getValueType();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PortletEvent other = (PortletEvent)obj;
        if (!(this.eventHolder == other.eventHolder || this.eventHolder != null && this.eventHolder.equals(other.eventHolder))) {
            return false;
        }
        return this.eventQName == other.eventQName || this.eventQName != null && this.eventQName.equals(other.eventQName);
    }

    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + (this.eventHolder != null ? this.eventHolder.hashCode() : 0);
        hash = 17 * hash + (this.eventQName != null ? this.eventQName.hashCode() : 0);
        return hash;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("PortletEvent[");
        sb.append(this.eventQName);
        sb.append("]");
        return sb.toString();
    }

    private LogRecord getLogRecord(String code, Exception cause) {
        LogRecord record = new LogRecord(Level.SEVERE, code);
        record.setThrown(cause);
        record.setParameters(new Object[]{this.getValueType(), this.getQName()});
        record.setLoggerName(logger.getName());
        return record;
    }
}

