/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.community.notification.user;

import java.util.Collection;
import org.silverpeas.components.community.model.CommunityOfUsers;
import org.silverpeas.components.community.notification.user.AbstractCommunityUserNotificationBuilder;
import org.silverpeas.core.admin.service.SpaceProfile;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.template.SilverpeasTemplate;
import org.silverpeas.core.util.URLUtil;

public class MembershipRequestUserNotificationBuilder
extends AbstractCommunityUserNotificationBuilder {
    private final SpaceProfile spaceProfile = this.getSpaceManagerProfile();
    private User requester;

    protected MembershipRequestUserNotificationBuilder(CommunityOfUsers resource) {
        super(resource);
    }

    public static MembershipRequestUserNotificationBuilder about(CommunityOfUsers community) {
        return new MembershipRequestUserNotificationBuilder(community);
    }

    public MembershipRequestUserNotificationBuilder newRequestFrom(User requester) {
        this.requester = requester;
        return this;
    }

    protected String getBundleSubjectKey() {
        return "community.join.request.notif.subject";
    }

    protected String getTemplateFileName() {
        return "communityMembershipRequest";
    }

    protected String getTitle(String language) {
        return this.getBundle(language).getStringWithParams(this.getBundleSubjectKey(), new Object[]{this.getSpace().getName(language)});
    }

    protected Collection<String> getUserIdsToNotify() {
        return this.spaceProfile.getAllUserIds();
    }

    protected Collection<String> getGroupIdsToNotify() {
        return this.spaceProfile.getAllGroupIds();
    }

    @Override
    protected String getSender() {
        return this.requester.getId();
    }

    @Override
    protected String getResourceURL(CommunityOfUsers resource) {
        return URLUtil.getSimpleURL((int)URLUtil.Permalink.COMPONENT.getType(), (String)resource.getComponentInstanceId(), (boolean)false);
    }

    @Override
    protected void performTemplateData(String language, CommunityOfUsers resource, SilverpeasTemplate template) {
        super.performTemplateData(language, resource, template);
        template.setAttribute("requesterFullName", (Object)this.requester.getDisplayedName());
    }
}

