/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.mylinks.dao;

import java.lang.annotation.Annotation;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.silverpeas.core.annotation.Repository;
import org.silverpeas.core.mylinks.dao.LinkCategoryDAO;
import org.silverpeas.core.mylinks.model.CategoryDetail;
import org.silverpeas.core.mylinks.model.LinkDetail;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQuery;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.util.StringUtil;

@Repository
public class LinkDAO {
    private static final String LINK_TABLE = "SB_MyLinks_Link";
    private static final String LINK_ID = "linkId";
    private static final String LINK_ID_CLAUSE = "linkId = ?";
    private static final String USER_ID_CLAUSE = "userId = ?";
    private static final String INSTANCE_ID_CLAUSE = "instanceId = ?";
    private static final String OBJECT_ID_CLAUSE = "objectId = ?";
    @Inject
    private LinkCategoryDAO linkCategoryDAO;

    protected static LinkDAO get() {
        return (LinkDAO)ServiceProvider.getService(LinkDAO.class, (Annotation[])new Annotation[0]);
    }

    protected LinkDAO() {
    }

    public void deleteComponentInstanceData(String componentInstanceId) throws SQLException {
        this.linkCategoryDAO.deleteComponentInstanceData(componentInstanceId);
        JdbcSqlQuery.deleteFrom((String)LINK_TABLE).where(INSTANCE_ID_CLAUSE, new Object[]{componentInstanceId}).or("url like ?", new Object[]{"%" + componentInstanceId}).execute();
    }

    protected List<Integer> getLinkIdsByComponentInstance(String componentInstanceId) throws SQLException {
        return JdbcSqlQuery.select((String)LINK_ID).from(new String[]{LINK_TABLE}).where(INSTANCE_ID_CLAUSE, new Object[]{componentInstanceId}).or("url like ?", new Object[]{"%" + componentInstanceId}).execute(r -> r.getInt(1));
    }

    public void deleteUserData(String userId) throws SQLException {
        this.linkCategoryDAO.deleteUserData(userId);
        JdbcSqlQuery.deleteFrom((String)LINK_TABLE).where(USER_ID_CLAUSE, new Object[]{userId}).and("(instanceId IS NULL", new Object[0]).or("instanceId = '')", new Object[0]).and("(objectId IS NULL", new Object[0]).or("objectId = '')", new Object[0]).execute();
    }

    public List<LinkDetail> getAllLinksByUser(String userId) throws SQLException {
        Map<Integer, CategoryDetail> categoriesByLinkId = this.linkCategoryDAO.getAllCategoriesByLinkOfUser(userId);
        return JdbcSqlQuery.select((String)"*").from(new String[]{LINK_TABLE}).where(USER_ID_CLAUSE, new Object[]{userId}).and("(instanceId IS NULL", new Object[0]).or("instanceId = '')", new Object[0]).and("(objectId IS NULL", new Object[0]).or("objectId = '')", new Object[0]).execute(rs -> this.fetchLink((ResultSet)rs, categoriesByLinkId));
    }

    public List<LinkDetail> getAllLinksByInstance(String instanceId) throws SQLException {
        return JdbcSqlQuery.select((String)"*").from(new String[]{LINK_TABLE}).where(INSTANCE_ID_CLAUSE, new Object[]{instanceId}).execute(rs -> this.fetchLink((ResultSet)rs, Collections.emptyMap()));
    }

    public List<LinkDetail> getAllLinksByObject(String instanceId, String objectId) throws SQLException {
        return JdbcSqlQuery.select((String)"*").from(new String[]{LINK_TABLE}).where(INSTANCE_ID_CLAUSE, new Object[]{instanceId}).and(OBJECT_ID_CLAUSE, new Object[]{objectId}).execute(rs -> this.fetchLink((ResultSet)rs, Collections.emptyMap()));
    }

    public LinkDetail getLink(int linkId) throws SQLException {
        Map<Integer, CategoryDetail> categoriesByLinkId = this.linkCategoryDAO.getAllCategoriesByLink(linkId);
        return (LinkDetail)JdbcSqlQuery.select((String)"*").from(new String[]{LINK_TABLE}).where(LINK_ID_CLAUSE, new Object[]{linkId}).executeUnique(rs -> this.fetchLink((ResultSet)rs, categoriesByLinkId));
    }

    public LinkDetail createLink(LinkDetail link) throws SQLException {
        LinkDetail linkToPersist = new LinkDetail(link);
        linkToPersist.setLinkId(DBUtil.getNextId((String)LINK_TABLE, (String)LINK_ID));
        linkToPersist.setHasPosition(false);
        JdbcSqlQuery insertQuery = JdbcSqlQuery.insertInto((String)LINK_TABLE);
        LinkDAO.setupSaveQuery(insertQuery, linkToPersist, true).execute();
        this.linkCategoryDAO.saveByLink(linkToPersist);
        return linkToPersist;
    }

    public LinkDetail updateLink(LinkDetail link) throws SQLException {
        LinkDetail linkToUpdate = new LinkDetail(link);
        JdbcSqlQuery updateQuery = JdbcSqlQuery.update((String)LINK_TABLE);
        LinkDAO.setupSaveQuery(updateQuery, linkToUpdate, false).execute();
        this.linkCategoryDAO.saveByLink(linkToUpdate);
        return linkToUpdate;
    }

    public void deleteLink(String linkId) throws SQLException {
        this.linkCategoryDAO.deleteByLink(Integer.parseInt(linkId));
        JdbcSqlQuery.deleteFrom((String)LINK_TABLE).where(LINK_ID_CLAUSE, new Object[]{Integer.parseInt(linkId)}).execute();
    }

    private LinkDetail fetchLink(ResultSet rs, Map<Integer, CategoryDetail> categoriesByLinkId) throws SQLException {
        LinkDetail link = new LinkDetail();
        int linkId = rs.getInt(LINK_ID);
        link.setLinkId(linkId);
        link.setPosition(rs.getInt("position"));
        link.setHasPosition(!rs.wasNull());
        link.setName(rs.getString("name"));
        link.setDescription(rs.getString("description"));
        link.setUrl(rs.getString("url"));
        link.setVisible(rs.getInt("visible") == 1);
        link.setPopup(rs.getInt("popup") == 1);
        link.setUserId(rs.getString("userId"));
        link.setInstanceId(rs.getString("instanceId"));
        link.setObjectId(rs.getString("objectId"));
        link.setCategory(categoriesByLinkId.getOrDefault(linkId, null));
        return link;
    }

    private static JdbcSqlQuery setupSaveQuery(JdbcSqlQuery saveQuery, LinkDetail link, boolean isInsert) {
        if (isInsert) {
            saveQuery.withSaveParam(LINK_ID, (Object)link.getLinkId(), true);
        }
        String name = StringUtil.truncate((String)link.getName(), (int)255);
        String description = StringUtil.truncate((String)link.getDescription(), (int)255);
        String url = StringUtil.truncate((String)link.getUrl(), (int)255);
        saveQuery.withSaveParam("name", (Object)name, isInsert).withSaveParam("description", (Object)description, isInsert).withSaveParam("url", (Object)url, isInsert).withSaveParam("visible", (Object)(link.isVisible() ? 1 : 0), isInsert).withSaveParam("popup", (Object)(link.isPopup() ? 1 : 0), isInsert).withSaveParam("userId", (Object)link.getUserId(), isInsert).withSaveParam("instanceId", (Object)link.getInstanceId(), isInsert).withSaveParam("objectId", (Object)link.getObjectId(), isInsert);
        if (link.hasPosition()) {
            saveQuery.withSaveParam("position", (Object)link.getPosition(), isInsert);
        }
        if (!isInsert) {
            saveQuery.where(LINK_ID_CLAUSE, new Object[]{link.getLinkId()});
        }
        return saveQuery;
    }
}

