/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.search;

import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.index.search.PlainSearchResult;
import org.silverpeas.core.index.search.SearchEngineProvider;
import org.silverpeas.core.index.search.SearchQueryProcessor;
import org.silverpeas.core.index.search.model.MatchingIndexEntry;
import org.silverpeas.core.index.search.model.QueryDescription;
import org.silverpeas.core.index.search.model.SearchEngineException;
import org.silverpeas.core.index.search.model.SearchResult;
import org.silverpeas.core.index.search.qualifiers.TaxonomySearch;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.logging.SilverLogger;

@Service
public class SearchService {
    @Inject
    @TaxonomySearch
    SearchQueryProcessor taxonomySearchProcessor;

    public static SearchService get() {
        return (SearchService)ServiceProvider.getService(SearchService.class, (Annotation[])new Annotation[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SearchResult> search(QueryDescription queryDescription) throws SearchEngineException {
        long startTime = System.currentTimeMillis();
        try {
            List<SearchResult> list;
            boolean taxonomySearch = queryDescription.isTaxonomyUsed();
            boolean fullTextSearch = !queryDescription.isEmpty();
            List<SearchResult> fullTextResults = Collections.emptyList();
            List<SearchResult> taxonomyResults = taxonomySearch ? this.taxonomySearchProcessor.process(queryDescription, null) : Collections.emptyList();
            if (fullTextSearch) {
                if (!taxonomyResults.isEmpty()) {
                    Set<String> componentIds = this.extractComponentIds(taxonomyResults);
                    queryDescription.getWhereToSearch().clear();
                    queryDescription.getWhereToSearch().addAll(componentIds);
                }
                fullTextResults = this.searchOnIndexes(queryDescription);
            }
            if (fullTextSearch && taxonomySearch) {
                list = this.getResultsFromMixedSearch(taxonomyResults, fullTextResults);
                return list;
            }
            if (fullTextSearch) {
                list = fullTextResults;
                return list;
            }
            list = taxonomyResults;
            return list;
        }
        finally {
            long endTime = System.currentTimeMillis();
            SilverLogger.getLogger((Object)this).debug(() -> MessageFormat.format(" search service duration of {0}", DurationFormatUtils.formatDurationHMS((long)(endTime - startTime))));
        }
    }

    private List<SearchResult> getResultsFromMixedSearch(List<SearchResult> taxonomyResults, List<SearchResult> fullTextResults) {
        List<Object> results;
        if (CollectionUtil.isNotEmpty(fullTextResults)) {
            HashMap indexedSearchResult = new HashMap(fullTextResults.size());
            fullTextResults.forEach(f -> indexedSearchResult.put(f, f));
            results = taxonomyResults.stream().map(indexedSearchResult::get).filter(Objects::nonNull).collect(Collectors.toList());
        } else {
            results = new ArrayList<SearchResult>();
        }
        return results;
    }

    private Set<String> extractComponentIds(List<SearchResult> results) {
        HashSet<String> distinctComponentIds = new HashSet<String>();
        for (SearchResult result : results) {
            distinctComponentIds.add(result.getInstanceId());
        }
        return distinctComponentIds;
    }

    private List<SearchResult> searchOnIndexes(QueryDescription fullTextRequest) throws SearchEngineException {
        try {
            PlainSearchResult searchResult = SearchEngineProvider.getSearchEngine().search(fullTextRequest);
            ArrayList<SearchResult> results = new ArrayList<SearchResult>();
            for (MatchingIndexEntry mie : searchResult.getEntries()) {
                results.add(SearchResult.fromIndexEntry((MatchingIndexEntry)mie));
            }
            return results;
        }
        catch (Exception e) {
            throw new SearchEngineException((Throwable)e);
        }
    }
}

