/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.connectionpool;

import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPConstraints;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPLocalException;
import com.novell.ldap.LDAPResponseQueue;
import com.novell.ldap.LDAPSocketFactory;

class Connection
extends LDAPConnection
implements Cloneable {
    private boolean inUse = false;
    private boolean allowPoolBind = false;

    public Connection(LDAPSocketFactory factory) {
        super(factory);
    }

    boolean inUse() {
        return this.inUse;
    }

    boolean setInUse() {
        this.inUse = true;
        return this.inUse;
    }

    boolean clearInUse() {
        this.inUse = false;
        return this.inUse;
    }

    public Object clone() {
        return super.clone();
    }

    void poolBind(int version, String dn, byte[] passwd) throws LDAPException {
        try {
            this.allowPoolBind = true;
            super.bind(version, dn, passwd);
        }
        catch (LDAPException e) {
            throw e;
        }
        finally {
            this.allowPoolBind = false;
        }
    }

    public LDAPResponseQueue bind(int version, String dn, byte[] passwd, LDAPResponseQueue queue, LDAPConstraints cons) throws LDAPException {
        if (this.allowPoolBind) {
            return super.bind(version, dn, passwd, queue, cons);
        }
        throw new LDAPLocalException("CANNOT_BIND", 82);
    }
}

